/*
 * Decompiled with CFR 0.152.
 */
package reactor;

import java.util.Arrays;
import java.util.List;
import org.reactivestreams.ColdPublisher;
import org.reactivestreams.Recorded;
import org.reactivestreams.SchedulerFactory;
import org.reactivestreams.Subscriber;
import org.reactivestreams.SubscriptionLog;
import org.reactivestreams.TestablePublisher;
import reactor.SchedulerAdapter;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;

public class ColdFlux<T>
extends Flux<T>
implements TestablePublisher<T> {
    private final TestablePublisher<T> publisher;

    protected ColdFlux(TestablePublisher<T> publisher) {
        this.publisher = publisher;
    }

    public void subscribe(Subscriber<? super T> s) {
        this.publisher.subscribe(s);
    }

    @Override
    public List<SubscriptionLog> getSubscriptions() {
        return this.publisher.getSubscriptions();
    }

    @Override
    public List<Recorded<T>> getMessages() {
        return this.publisher.getMessages();
    }

    public static <T> ColdFlux<T> create(Scheduler scheduler, Recorded<T> ... notifications) {
        return ColdFlux.create(scheduler, Arrays.asList(notifications));
    }

    public static <T> ColdFlux<T> create(final Scheduler scheduler, List<Recorded<T>> notifications) {
        ColdPublisher<T> coldPublisher = new ColdPublisher<T>(new SchedulerFactory(){

            @Override
            public org.reactivestreams.Scheduler create() {
                return new SchedulerAdapter(scheduler);
            }
        }, notifications);
        return new ColdFlux<T>(coldPublisher);
    }
}

