/*
 * Decompiled with CFR 0.152.
 */
package reactor;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.ISetupSubscriptionsTest;
import org.reactivestreams.ISetupTest;
import org.reactivestreams.MarbleSchedulerState;
import org.reactivestreams.Parser;
import org.reactivestreams.Recorded;
import org.reactivestreams.SubscriptionLog;
import reactor.ColdFlux;
import reactor.HotFlux;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.test.scheduler.VirtualTimeScheduler;

public class MarbleScheduler
extends VirtualTimeScheduler {
    private final MarbleSchedulerState state;
    private final long frameTimeFactor;

    public MarbleScheduler() {
        this(10L);
    }

    public MarbleScheduler(long frameTimeFactor) {
        this.frameTimeFactor = frameTimeFactor;
        this.state = new MarbleSchedulerState(frameTimeFactor, new MarbleSchedulerState.ISchedule(){

            @Override
            public long now() {
                return MarbleScheduler.this.now(TimeUnit.MILLISECONDS);
            }

            @Override
            public void schedule(Runnable runnable, long time) {
                MarbleScheduler.this.schedule(runnable, time, TimeUnit.MILLISECONDS);
            }
        }, ((Object)((Object)this)).getClass());
    }

    public <T> ColdFlux<T> createColdFlux(String marbles, Map<String, T> values) {
        List<Recorded<T>> notifications = Parser.parseMarbles(marbles, values, null, this.frameTimeFactor);
        return ColdFlux.create((Scheduler)this, notifications);
    }

    public <T> ColdFlux<T> createColdFlux(String marbles) {
        return this.createColdFlux(marbles, null);
    }

    public <T> HotFlux<T> createHotFlux(String marbles, Map<String, T> values) {
        List<Recorded<T>> notifications = Parser.parseMarbles(marbles, values, null, this.frameTimeFactor);
        return HotFlux.create((Scheduler)this, notifications);
    }

    public <T> HotFlux<T> createHotFlux(String marbles) {
        return this.createHotFlux(marbles, null);
    }

    public long createTime(String marbles) {
        int endIndex = marbles.indexOf("|");
        if (endIndex == -1) {
            throw new RuntimeException("Marble diagram for time should have a completion marker '|'");
        }
        return (long)endIndex * this.frameTimeFactor;
    }

    public void flush() {
        this.advanceTimeTo(Instant.ofEpochMilli(Long.MAX_VALUE));
        this.state.flush();
    }

    public <T> ISetupTest expectFlux(Flux<T> flux) {
        return this.expectFlux(flux, null);
    }

    public <T> ISetupTest expectFlux(Flux<T> flux, String unsubscriptionMarbles) {
        return this.state.expectPublisher(flux, unsubscriptionMarbles);
    }

    public ISetupSubscriptionsTest expectSubscriptions(List<SubscriptionLog> subscriptions) {
        return this.state.expectSubscriptions(subscriptions);
    }
}

