/*
 * Decompiled with CFR 0.152.
 */
package rx.marble;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.marble.Recorded;
import rx.marble.SubscriptionLog;
import rx.marble.TestableObservable;
import rx.subscriptions.Subscriptions;

public class ColdObservable<T>
extends Observable<T>
implements TestableObservable<T> {
    private final List<Recorded<T>> notifications;
    private List<SubscriptionLog> subscriptions = new ArrayList<SubscriptionLog>();

    private ColdObservable(Observable.OnSubscribe<T> f, List<Recorded<T>> notifications) {
        super(f);
        this.notifications = notifications;
    }

    @Override
    public List<SubscriptionLog> getSubscriptions() {
        return Collections.unmodifiableList(this.subscriptions);
    }

    @Override
    public List<Recorded<T>> getMessages() {
        return Collections.unmodifiableList(this.notifications);
    }

    public static <T> ColdObservable<T> create(Scheduler scheduler, Recorded<T> ... notifications) {
        return ColdObservable.create(scheduler, Arrays.asList(notifications));
    }

    public static <T> ColdObservable<T> create(Scheduler scheduler, List<Recorded<T>> notifications) {
        ColdObservable<T> observable;
        OnSubscribeHandler<T> onSubscribeFunc = new OnSubscribeHandler<T>(scheduler, notifications);
        onSubscribeFunc.observable = observable = new ColdObservable<T>(onSubscribeFunc, notifications);
        return observable;
    }

    private static class OnSubscribeHandler<T>
    implements Observable.OnSubscribe<T> {
        private final Scheduler scheduler;
        private final List<Recorded<T>> notifications;
        public ColdObservable observable;

        public OnSubscribeHandler(Scheduler scheduler, List<Recorded<T>> notifications) {
            this.scheduler = scheduler;
            this.notifications = notifications;
        }

        public void call(final Subscriber<? super T> subscriber) {
            final SubscriptionLog subscriptionLog = new SubscriptionLog(this.scheduler.now());
            this.observable.subscriptions.add(subscriptionLog);
            final int subscriptionIndex = this.observable.getSubscriptions().size() - 1;
            Scheduler.Worker worker = this.scheduler.createWorker();
            subscriber.add((Subscription)worker);
            for (final Recorded<T> notification : this.notifications) {
                worker.schedule(new Action0(){

                    public void call() {
                        notification.value.accept((Observer)subscriber);
                    }
                }, notification.time, TimeUnit.MILLISECONDS);
            }
            subscriber.add(Subscriptions.create((Action0)new Action0(){

                public void call() {
                    OnSubscribeHandler.this.observable.subscriptions.set(subscriptionIndex, new SubscriptionLog(subscriptionLog.subscribe, OnSubscribeHandler.this.scheduler.now()));
                }
            }));
        }
    }
}

