/*
 * Decompiled with CFR 0.152.
 */
package rx.marble;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.marble.Recorded;
import rx.marble.SubscriptionLog;
import rx.marble.TestableObservable;
import rx.subscriptions.Subscriptions;

public class HotObservable<T>
extends Observable<T>
implements TestableObservable<T> {
    private final List<Recorded<T>> notifications;
    List<SubscriptionLog> subscriptions = new ArrayList<SubscriptionLog>();

    protected HotObservable(Observable.OnSubscribe<T> f, List<Recorded<T>> notifications) {
        super(f);
        this.notifications = notifications;
    }

    @Override
    public List<SubscriptionLog> getSubscriptions() {
        return Collections.unmodifiableList(this.subscriptions);
    }

    @Override
    public List<Recorded<T>> getMessages() {
        return Collections.unmodifiableList(this.notifications);
    }

    public static <T> HotObservable<T> create(Scheduler scheduler, Recorded<T> ... notifications) {
        return HotObservable.create(scheduler, Arrays.asList(notifications));
    }

    public static <T> HotObservable<T> create(Scheduler scheduler, List<Recorded<T>> notifications) {
        OnSubscribeHandler<T> onSubscribeFunc = new OnSubscribeHandler<T>(scheduler, notifications);
        HotObservable<T> observable = new HotObservable<T>(onSubscribeFunc, notifications);
        onSubscribeFunc.observable = observable;
        return observable;
    }

    private static class OnSubscribeHandler<T>
    implements Observable.OnSubscribe<T> {
        private final Scheduler scheduler;
        private final List<Subscriber<? super T>> subscribers = new ArrayList<Subscriber<? super T>>();
        public HotObservable<T> observable;

        public OnSubscribeHandler(Scheduler scheduler, List<Recorded<T>> notifications) {
            this.scheduler = scheduler;
            Scheduler.Worker worker = scheduler.createWorker();
            for (final Recorded<T> event : notifications) {
                worker.schedule(new Action0(){

                    public void call() {
                        ArrayList subscribers = new ArrayList(OnSubscribeHandler.this.subscribers);
                        for (Subscriber subscriber : subscribers) {
                            event.value.accept((Observer)subscriber);
                        }
                    }
                }, event.time, TimeUnit.MILLISECONDS);
            }
        }

        public void call(final Subscriber<? super T> subscriber) {
            final SubscriptionLog subscriptionLog = new SubscriptionLog(this.scheduler.now());
            this.observable.subscriptions.add(subscriptionLog);
            final int subscriptionIndex = this.observable.getSubscriptions().size() - 1;
            this.subscribers.add(subscriber);
            subscriber.add(Subscriptions.create((Action0)new Action0(){

                public void call() {
                    OnSubscribeHandler.this.observable.subscriptions.set(subscriptionIndex, new SubscriptionLog(subscriptionLog.subscribe, OnSubscribeHandler.this.scheduler.now()));
                    OnSubscribeHandler.this.subscribers.remove(subscriber);
                }
            }));
        }
    }
}

