/*
 * Decompiled with CFR 0.152.
 */
package rx.marble;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import rx.Notification;
import rx.Observable;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.marble.ColdObservable;
import rx.marble.ExceptionHelper;
import rx.marble.ExpectObservableException;
import rx.marble.ExpectSubscriptionsException;
import rx.marble.HotObservable;
import rx.marble.ISetupSubscriptionsTest;
import rx.marble.ISetupTest;
import rx.marble.Parser;
import rx.marble.Recorded;
import rx.marble.RecordedStreamComparator;
import rx.marble.SetupTestSupport;
import rx.marble.SubscriptionLog;
import rx.schedulers.TestScheduler;

public class MarbleScheduler
extends TestScheduler {
    private final List<ITestOnFlush> flushTests = new ArrayList<ITestOnFlush>();
    private final long frameTimeFactor;

    public MarbleScheduler(long frameTimeFactor) {
        this.frameTimeFactor = frameTimeFactor;
    }

    public MarbleScheduler() {
        this.frameTimeFactor = 10L;
    }

    public <T> ColdObservable<T> createColdObservable(String marbles, Map<String, T> values) {
        List<Recorded<T>> notifications = Parser.parseMarbles(marbles, values, null, this.frameTimeFactor);
        return ColdObservable.create((Scheduler)this, notifications);
    }

    public <T> ColdObservable<T> createColdObservable(String marbles) {
        return this.createColdObservable(marbles, null);
    }

    public <T> HotObservable<T> createHotObservable(String marbles, Map<String, T> values) {
        List<Recorded<T>> notifications = Parser.parseMarbles(marbles, values, null, this.frameTimeFactor);
        return HotObservable.create((Scheduler)this, notifications);
    }

    public <T> HotObservable<T> createHotObservable(String marbles) {
        return this.createHotObservable(marbles, null);
    }

    public long createTime(String marbles) {
        int endIndex = marbles.indexOf("|");
        if (endIndex == -1) {
            throw new RuntimeException("Marble diagram for time should have a completion marker '|'");
        }
        return (long)endIndex * this.frameTimeFactor;
    }

    public void flush() {
        this.advanceTimeTo(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        for (ITestOnFlush test : this.flushTests) {
            if (!test.isReady()) continue;
            test.run();
        }
    }

    public <T> ISetupTest expectObservable(Observable<T> observable) {
        return this.expectObservable(observable, null);
    }

    public <T> ISetupTest expectObservable(Observable<T> observable, String unsubscriptionMarbles) {
        String caller = ExceptionHelper.findCallerInStackTrace(((Object)((Object)this)).getClass());
        FlushableTest flushTest = new FlushableTest(caller);
        final ArrayList actual = new ArrayList();
        flushTest.actual = actual;
        long unsubscriptionFrame = Long.MAX_VALUE;
        if (unsubscriptionMarbles != null) {
            unsubscriptionFrame = Parser.parseMarblesAsSubscriptions((String)unsubscriptionMarbles, (long)this.frameTimeFactor).unsubscribe;
        }
        final Subscription subscription = observable.subscribe(new Action1<T>(){

            public void call(T x) {
                Object value = x;
                if (value instanceof Observable) {
                    value = MarbleScheduler.this.materializeInnerObservable((Observable)value, MarbleScheduler.this.now());
                }
                actual.add(new Recorded(MarbleScheduler.this.now(), Notification.createOnNext(value)));
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                actual.add(new Recorded(MarbleScheduler.this.now(), Notification.createOnError((Throwable)throwable)));
            }
        }, new Action0(){

            public void call() {
                actual.add(new Recorded(MarbleScheduler.this.now(), Notification.createOnCompleted()));
            }
        });
        if (unsubscriptionFrame != Long.MAX_VALUE) {
            this.createWorker().schedule(new Action0(){

                public void call() {
                    subscription.unsubscribe();
                }
            }, unsubscriptionFrame, TimeUnit.MILLISECONDS);
        }
        this.flushTests.add(flushTest);
        return new SetupTest(flushTest, this.frameTimeFactor);
    }

    private List<Recorded<Object>> materializeInnerObservable(Observable observable, final long outerFrame) {
        final ArrayList<Recorded<Object>> messages = new ArrayList<Recorded<Object>>();
        observable.subscribe(new Action1(){

            public void call(Object x) {
                messages.add(new Recorded(MarbleScheduler.this.now() - outerFrame, Notification.createOnNext((Object)x)));
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                messages.add(new Recorded(MarbleScheduler.this.now() - outerFrame, Notification.createOnError((Throwable)throwable)));
            }
        }, new Action0(){

            public void call() {
                messages.add(new Recorded(MarbleScheduler.this.now() - outerFrame, Notification.createOnCompleted()));
            }
        });
        return messages;
    }

    public ISetupSubscriptionsTest expectSubscriptions(List<SubscriptionLog> subscriptions) {
        String caller = ExceptionHelper.findCallerInStackTrace(((Object)((Object)this)).getClass());
        FlushableSubscriptionTest flushTest = new FlushableSubscriptionTest(caller);
        flushTest.actual = subscriptions;
        this.flushTests.add(flushTest);
        return new SetupSubscriptionsTest(flushTest, this.frameTimeFactor);
    }

    class FlushableSubscriptionTest
    implements ITestOnFlush {
        private final String caller;
        private boolean ready;
        public List<SubscriptionLog> actual;
        public List<SubscriptionLog> expected;

        public FlushableSubscriptionTest(String caller) {
            this.caller = caller;
        }

        @Override
        public void run() {
            if (this.actual.size() != this.expected.size()) {
                throw new ExpectSubscriptionsException(this.expected.size() + " subscription(s) expected, only " + this.actual.size() + " observed", this.caller);
            }
            for (int i = 0; i < this.actual.size(); ++i) {
                if ((this.actual.get(i) == null || this.actual.get(i).equals(this.expected.get(i))) && (this.actual.get(i) != null || this.expected.get(i) == null)) continue;
                throw new ExpectSubscriptionsException("Expected subscription was " + this.expected.get(i) + ", instead received " + this.actual.get(i), this.caller);
            }
        }

        @Override
        public boolean isReady() {
            return this.ready;
        }
    }

    class SetupSubscriptionsTest
    implements ISetupSubscriptionsTest {
        private final FlushableSubscriptionTest flushTest;
        private final long frameTimeFactor;

        public SetupSubscriptionsTest(FlushableSubscriptionTest flushTest, long frameTimeFactor) {
            this.flushTest = flushTest;
            this.frameTimeFactor = frameTimeFactor;
        }

        @Override
        public void toBe(String ... marbles) {
            this.flushTest.ready = true;
            this.flushTest.expected = new ArrayList<SubscriptionLog>();
            for (String marble : marbles) {
                SubscriptionLog subscriptionLog = Parser.parseMarblesAsSubscriptions(marble, this.frameTimeFactor);
                this.flushTest.expected.add(subscriptionLog);
            }
        }
    }

    class FlushableTest
    implements ITestOnFlush {
        private final String caller;
        private boolean ready;
        public List<Recorded<?>> actual;
        public List expected;

        public FlushableTest(String caller) {
            this.caller = caller;
        }

        @Override
        public void run() {
            RecordedStreamComparator.StreamComparison result = new RecordedStreamComparator().compare(this.actual, this.expected);
            if (!result.streamEquals) {
                throw new ExpectObservableException(result.toString(), this.caller);
            }
        }

        @Override
        public boolean isReady() {
            return this.ready;
        }
    }

    static interface ITestOnFlush {
        public void run();

        public boolean isReady();
    }

    class SetupTest
    extends SetupTestSupport {
        private final FlushableTest flushTest;
        private final long frameTimeFactor;

        public SetupTest(FlushableTest flushTest, long frameTimeFactor) {
            this.flushTest = flushTest;
            this.frameTimeFactor = frameTimeFactor;
        }

        @Override
        public void toBe(String marble, Map<String, ?> values, Exception errorValue) {
            this.flushTest.ready = true;
            this.flushTest.expected = values == null ? Parser.parseMarbles(marble, null, errorValue, this.frameTimeFactor, true) : Parser.parseMarbles(marble, new HashMap(values), errorValue, this.frameTimeFactor, true);
        }
    }
}

