/*
 * Decompiled with CFR 0.152.
 */
package rx.marble.junit;

import java.util.List;
import java.util.Map;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import rx.Observable;
import rx.marble.ColdObservable;
import rx.marble.HotObservable;
import rx.marble.ISetupSubscriptionsTest;
import rx.marble.ISetupTest;
import rx.marble.MarbleScheduler;
import rx.marble.SubscriptionLog;

public class MarbleRule
implements TestRule {
    private static ThreadLocal<MarbleScheduler> schedulerHolder = new ThreadLocal();
    public final MarbleScheduler scheduler;

    public MarbleRule() {
        this.scheduler = new MarbleScheduler();
    }

    public MarbleRule(long frameTimeFactor) {
        this.scheduler = new MarbleScheduler(frameTimeFactor);
    }

    public static <T> HotObservable<T> hot(String marbles, Map<String, T> values) {
        return schedulerHolder.get().createHotObservable(marbles, values);
    }

    public static HotObservable<String> hot(String marbles) {
        return schedulerHolder.get().createHotObservable(marbles);
    }

    public static <T> ColdObservable<T> cold(String marbles, Map<String, T> values) {
        return schedulerHolder.get().createColdObservable(marbles, values);
    }

    public static ColdObservable<String> cold(String marbles) {
        return schedulerHolder.get().createColdObservable(marbles);
    }

    public static ISetupTest expectObservable(Observable<?> actual) {
        return schedulerHolder.get().expectObservable(actual);
    }

    public static ISetupTest expectObservable(Observable<?> actual, String unsubscriptionMarbles) {
        return schedulerHolder.get().expectObservable(actual, unsubscriptionMarbles);
    }

    public static ISetupSubscriptionsTest expectSubscriptions(List<SubscriptionLog> subscriptions) {
        return schedulerHolder.get().expectSubscriptions(subscriptions);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                schedulerHolder.set(MarbleRule.this.scheduler);
                try {
                    base.evaluate();
                    MarbleRule.this.scheduler.flush();
                }
                finally {
                    schedulerHolder.remove();
                }
            }
        };
    }
}

