/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexvictoor.livereload;

import io.netty.util.internal.ConcurrentSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemWatcher {
    public static final Logger logger = LoggerFactory.getLogger(FileSystemWatcher.class);
    private String rootFolder;
    private Set<Callback> callbacks = new ConcurrentSet();
    private ExecutorService executor;
    private WatchService watcher;
    private Map<WatchKey, Path> folders = new ConcurrentHashMap<WatchKey, Path>();

    public FileSystemWatcher(String rootFolder) {
        this.rootFolder = rootFolder;
    }

    private void registerFolder(Path folder) throws IOException {
        Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                WatchKey key = dir.register(FileSystemWatcher.this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                logger.debug("registering folder {}", (Object)dir);
                FileSystemWatcher.this.folders.put(key, dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public void start() {
        final Path rootPath = Paths.get(this.rootFolder, new String[0]);
        File root = rootPath.toFile();
        if (!root.exists() || root.isFile()) {
            throw new RuntimeException("Cannot watch a directory that does not exist; " + this.rootFolder);
        }
        try {
            logger.info("Starting to watch {}", (Object)root.getCanonicalPath());
            this.watcher = FileSystems.getDefault().newWatchService();
            this.registerFolder(rootPath);
            rootPath.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            this.executor = Executors.newSingleThreadExecutor();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        block5: while (true) {
                            WatchKey key = FileSystemWatcher.this.watcher.take();
                            List<WatchEvent<?>> events = key.pollEvents();
                            Iterator<WatchEvent<?>> iterator = events.iterator();
                            while (true) {
                                if (!iterator.hasNext()) continue block5;
                                WatchEvent<?> event = iterator.next();
                                WatchEvent.Kind<?> kind = event.kind();
                                if (kind == StandardWatchEventKinds.OVERFLOW) {
                                    FileSystemWatcher.this.sendNotification(rootPath);
                                    continue;
                                }
                                Path path = (Path)event.context();
                                Path folder = (Path)FileSystemWatcher.this.folders.get(key);
                                Path fullPath = folder.resolve(path);
                                logger.debug("Filesystem event {} {}", (Object)event.kind().name(), (Object)fullPath);
                                if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                                    try {
                                        if (Files.isDirectory(fullPath, LinkOption.NOFOLLOW_LINKS)) {
                                            FileSystemWatcher.this.registerFolder(fullPath);
                                        }
                                    }
                                    catch (IOException ex) {
                                        logger.error("Folder registration error", (Throwable)ex);
                                    }
                                }
                                if (!Files.isDirectory(fullPath, LinkOption.NOFOLLOW_LINKS)) {
                                    FileSystemWatcher.this.sendNotification(fullPath);
                                }
                                key.reset();
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        logger.warn("Filesystem watcher interrupted", (Throwable)e);
                    }
                    catch (IOException e) {
                        logger.warn("File path error", (Throwable)e);
                    }
                }
            });
        }
        catch (IOException e) {
            logger.error("Error while creating file system watcher", (Throwable)e);
        }
    }

    private void sendNotification(Path fullPath) throws IOException {
        String canonicalPath = fullPath.toFile().getCanonicalPath();
        for (Callback callback : this.callbacks) {
            callback.onFileChanged(canonicalPath);
        }
    }

    public void stop() {
        if (!this.executor.isShutdown()) {
            this.executor.shutdown();
        }
    }

    public void addCallback(Callback callback) {
        this.callbacks.add(callback);
    }

    public static interface Callback {
        public void onFileChanged(String var1);
    }
}

