/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexvictoor.livereload;

import com.github.alexvictoor.livereload.Broadcaster;
import com.github.alexvictoor.livereload.FileReader;
import com.github.alexvictoor.livereload.FileSystemWatcher;
import com.github.alexvictoor.livereload.WebSocketServerInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebSocketServer {
    public static final Logger logger = LoggerFactory.getLogger(WebSocketServer.class);
    static final int DEFAULT_PORT = 35729;
    public final int port;
    private final String rootFolder;

    public WebSocketServer(String rootFolder) {
        this.rootFolder = rootFolder;
        this.port = 35729;
    }

    public WebSocketServer(int port, String rootFolder) {
        this.port = port;
        this.rootFolder = rootFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws InterruptedException {
        File root = new File(this.rootFolder);
        if (!root.exists() || root.isFile()) {
            throw new IllegalArgumentException(this.rootFolder + " is not a valid folder path to watch");
        }
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            DefaultChannelGroup allChannels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
            Broadcaster broadcaster = new Broadcaster((ChannelGroup)allChannels);
            FileSystemWatcher watcher = new FileSystemWatcher(this.rootFolder);
            watcher.addCallback(broadcaster);
            FileReader fileReader = new FileReader();
            String jsContent = fileReader.readFileFromClassPath("/livereload.js");
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new WebSocketServerInitializer((ChannelGroup)allChannels, jsContent));
            Channel ch = b.bind(this.port).sync().channel();
            watcher.start();
            logger.info("Livereload server ready");
            ch.closeFuture().sync();
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }
}

