/*
 * Decompiled with CFR 0.152.
 */
package com.allantl.jira4s.auth.jwt;

import com.allantl.jira4s.auth.AcJwtConfig;
import com.allantl.jira4s.auth.AuthContext;
import com.allantl.jira4s.auth.jwt.domain.CanonicalURIHttpRequest;
import com.allantl.jira4s.auth.jwt.errors.BaseUrlMismatchError$;
import com.allantl.jira4s.auth.jwt.errors.InvalidSecretKey$;
import com.allantl.jira4s.auth.jwt.errors.InvalidSigningError$;
import com.allantl.jira4s.auth.jwt.errors.InvalidUriError$;
import com.allantl.jira4s.auth.jwt.errors.JwtGeneratorError;
import com.allantl.jira4s.auth.jwt.errors.RelativeUriError$;
import com.nimbusds.jose.JWSAlgorithm;
import io.toolsplus.atlassian.jwt.HttpRequestCanonicalizer$;
import io.toolsplus.atlassian.jwt.JwtBuilder;
import io.toolsplus.atlassian.jwt.api.CanonicalHttpRequest;
import java.io.Serializable;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import scala.Function0;
import scala.Function1;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Try$;

public final class JwtGenerator$ {
    public static JwtGenerator$ MODULE$;

    static {
        new JwtGenerator$();
    }

    public Either<JwtGeneratorError, String> generateToken(String httpMethod, String uri, AuthContext acContext, AcJwtConfig acConfig) {
        return this.isSecretKeyLessThan256Bits(acContext).right().flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.toJavaUri(uri).right().flatMap((Function1 & Serializable & scala.Serializable)uri -> MODULE$.toJavaUri(acContext.instanceUrl()).right().flatMap((Function1 & Serializable & scala.Serializable)hostUri -> MODULE$.isAbsoluteUri((URI)uri).right().flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.isRequestToHost((URI)uri, (URI)hostUri).right().flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.createToken(httpMethod, (URI)uri, acContext, acConfig).right().map((Function1 & Serializable & scala.Serializable)token -> token))))));
    }

    private Either<JwtGeneratorError, String> createToken(String httpMethod, URI uri, AuthContext acContext, AcJwtConfig acConfig) {
        CanonicalURIHttpRequest canonicalHttpRequest = new CanonicalURIHttpRequest(httpMethod, uri);
        String queryHash = HttpRequestCanonicalizer$.MODULE$.computeCanonicalRequestHash((CanonicalHttpRequest)canonicalHttpRequest);
        Duration expireAfter = Duration.of(acConfig.jwtExpirationInSeconds(), ChronoUnit.SECONDS);
        JwtBuilder qual$1 = new JwtBuilder(expireAfter).withIssuer(acConfig.addOnKey()).withQueryHash(queryHash);
        String x$12 = acContext.accessToken();
        JWSAlgorithm x$2 = qual$1.build$default$2();
        return qual$1.build(x$12, x$2).left().map((Function1 & Serializable & scala.Serializable)x$1 -> InvalidSigningError$.MODULE$);
    }

    private Either<JwtGeneratorError, BoxedUnit> isSecretKeyLessThan256Bits(AuthContext authContext) {
        return authContext.accessToken().getBytes().length < 32 ? package$.MODULE$.Left().apply((Object)InvalidSecretKey$.MODULE$) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    private Either<JwtGeneratorError, URI> toJavaUri(String str) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new URI(str)).toOption().toRight((Function0 & Serializable & scala.Serializable)() -> InvalidUriError$.MODULE$);
    }

    private Either<JwtGeneratorError, URI> isAbsoluteUri(URI uri) {
        return uri.isAbsolute() ? package$.MODULE$.Right().apply((Object)uri) : package$.MODULE$.Left().apply((Object)RelativeUriError$.MODULE$);
    }

    private Either<JwtGeneratorError, URI> isRequestToHost(URI uri, URI hostUri) {
        boolean isReqToHost = !hostUri.relativize(uri).isAbsolute();
        return isReqToHost ? package$.MODULE$.Right().apply((Object)uri) : package$.MODULE$.Left().apply((Object)BaseUrlMismatchError$.MODULE$);
    }

    private JwtGenerator$() {
        MODULE$ = this;
    }
}

