/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.components;

import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.entity.component.CoreComponent;
import com.almasb.fxgl.entity.component.SerializableComponent;
import com.almasb.fxgl.entity.components.TransformComponent;
import com.almasb.fxgl.physics.BoundingShape;
import com.almasb.fxgl.physics.Box3DShapeData;
import com.almasb.fxgl.physics.CollisionResult;
import com.almasb.fxgl.physics.HitBox;
import com.almasb.fxgl.physics.SAT;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@CoreComponent
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0005J\r\u00101\u001a\u00020/H\u0000\u00a2\u0006\u0002\b2J\u0016\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u000eJ8\u00103\u001a\u0002042\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u001a2\u0006\u0010:\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020(2\u0006\u0010<\u001a\u00020(H\u0002J\u0016\u0010=\u001a\u0002042\u0006\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u000eJ(\u0010=\u001a\u0002042\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\u0006\u0010;\u001a\u00020(2\u0006\u0010<\u001a\u00020(H\u0002J\u0006\u0010>\u001a\u00020/J\b\u0010?\u001a\u00020\u001aH\u0002J\b\u0010@\u001a\u00020\u001aH\u0002J\b\u0010A\u001a\u00020\u001aH\u0002J\b\u0010B\u001a\u00020\u001aH\u0002J\u0006\u0010C\u001a\u00020\u001aJ\u0006\u0010D\u001a\u00020\u001aJ\u0006\u0010E\u001a\u00020\u001aJ\u0006\u0010F\u001a\u00020\u001aJ\u0006\u0010G\u001a\u00020\u001aJ\u0006\u0010H\u001a\u00020\u001aJ\u0006\u0010I\u001a\u00020\u001aJ\u0006\u0010J\u001a\u00020\u001aJ\u0006\u0010K\u001a\u00020LJ\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012J\u000e\u0010N\u001a\u0002042\u0006\u00105\u001a\u00020\u0000J\b\u0010O\u001a\u000204H\u0016J\u000e\u0010P\u001a\u0002042\u0006\u0010Q\u001a\u00020RJ&\u0010P\u001a\u0002042\u0006\u0010S\u001a\u00020\u001a2\u0006\u0010T\u001a\u00020\u001a2\u0006\u0010U\u001a\u00020\u001a2\u0006\u0010V\u001a\u00020\u001aJ\u000e\u0010W\u001a\u0002042\u0006\u0010Q\u001a\u00020RJ&\u0010W\u001a\u0002042\u0006\u0010S\u001a\u00020\u001a2\u0006\u0010T\u001a\u00020\u001a2\u0006\u0010U\u001a\u00020\u001a2\u0006\u0010V\u001a\u00020\u001aJ\u0006\u0010X\u001a\u00020LJ\u0006\u0010Y\u001a\u00020LJ\u0006\u0010Z\u001a\u00020LJ\u0006\u0010[\u001a\u00020LJ\u0006\u0010\\\u001a\u00020LJ\u0006\u0010]\u001a\u00020LJ\b\u0010^\u001a\u00020/H\u0016J\b\u0010_\u001a\u00020/H\u0016J\u0016\u0010`\u001a\u00020R2\u0006\u0010-\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u001aJ\u0010\u0010a\u001a\u00020/2\u0006\u0010b\u001a\u00020cH\u0016J\u000e\u0010d\u001a\u00020/2\u0006\u0010e\u001a\u00020fJ\b\u0010g\u001a\u00020fH\u0016J\u0006\u0010h\u001a\u00020LJ\u0010\u0010i\u001a\u00020/2\u0006\u0010b\u001a\u00020cH\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0011\u001a&\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00050\u0005 \u0013*\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R?\u0010\u0014\u001a&\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00050\u0005 \u0013*\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00120\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001cR\u000e\u0010 \u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u00020(X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006j"}, d2={"Lcom/almasb/fxgl/entity/components/BoundingBoxComponent;", "Lcom/almasb/fxgl/entity/component/Component;", "Lcom/almasb/fxgl/entity/component/SerializableComponent;", "boxes", "", "Lcom/almasb/fxgl/physics/HitBox;", "([Lcom/almasb/fxgl/physics/HitBox;)V", "centerLocal", "Ljavafx/geometry/Point2D;", "getCenterLocal", "()Ljavafx/geometry/Point2D;", "centerWorld", "getCenterWorld", "dummy", "Lcom/almasb/fxgl/physics/CollisionResult;", "height", "Ljavafx/beans/property/ReadOnlyDoubleWrapper;", "hitBoxes", "Ljavafx/collections/ObservableList;", "kotlin.jvm.PlatformType", "hitBoxesReadOnly", "getHitBoxesReadOnly", "()Ljavafx/collections/ObservableList;", "hitBoxesReadOnly$delegate", "Lkotlin/Lazy;", "maxXLocal", "", "getMaxXLocal", "()D", "maxXWorld", "maxYLocal", "getMaxYLocal", "maxYWorld", "minXLocal", "minXWorld", "minYLocal", "minYWorld", "onHitBoxChange", "Ljavafx/collections/ListChangeListener;", "transform", "Lcom/almasb/fxgl/entity/components/TransformComponent;", "getTransform", "()Lcom/almasb/fxgl/entity/components/TransformComponent;", "setTransform", "(Lcom/almasb/fxgl/entity/components/TransformComponent;)V", "width", "addHitBox", "", "hitBox", "applyTransformToHitBoxes", "applyTransformToHitBoxes$fxgl_entity", "checkCollision", "", "other", "result", "box1", "box2", "angle1", "angle2", "t1", "t2", "checkCollisionPAT", "clearHitBoxes", "computeHeight", "computeMinXLocal", "computeMinYLocal", "computeWidth", "getHeight", "getMaxXWorld", "getMaxYWorld", "getMinXLocal", "getMinXWorld", "getMinYLocal", "getMinYWorld", "getWidth", "heightProperty", "Ljavafx/beans/property/ReadOnlyDoubleProperty;", "hitBoxesProperty", "isCollidingWith", "isComponentInjectionRequired", "isOutside", "bounds", "Ljavafx/geometry/Rectangle2D;", "minX", "minY", "maxX", "maxY", "isWithin", "maxXWorldProperty", "maxYWorldProperty", "minXLocalProperty", "minXWorldProperty", "minYLocalProperty", "minYWorldProperty", "onAdded", "onRemoved", "range", "read", "bundle", "Lcom/almasb/fxgl/core/serialization/Bundle;", "removeHitBox", "name", "", "toString", "widthProperty", "write", "fxgl-entity"})
public final class BoundingBoxComponent
extends Component
implements SerializableComponent {
    public TransformComponent transform;
    private final ObservableList<HitBox> hitBoxes;
    @NotNull
    private final Lazy hitBoxesReadOnly$delegate;
    @NotNull
    private final ReadOnlyDoubleWrapper width;
    @NotNull
    private final ReadOnlyDoubleWrapper height;
    @NotNull
    private final ReadOnlyDoubleWrapper minXLocal;
    @NotNull
    private final ReadOnlyDoubleWrapper minYLocal;
    @NotNull
    private final ReadOnlyDoubleWrapper minXWorld;
    @NotNull
    private final ReadOnlyDoubleWrapper minYWorld;
    @NotNull
    private final ReadOnlyDoubleWrapper maxXWorld;
    @NotNull
    private final ReadOnlyDoubleWrapper maxYWorld;
    @NotNull
    private final ListChangeListener<HitBox> onHitBoxChange;
    @NotNull
    private final CollisionResult dummy;

    public BoundingBoxComponent(HitBox ... boxes) {
        Intrinsics.checkNotNullParameter((Object)boxes, (String)"boxes");
        this.hitBoxes = FXCollections.observableArrayList();
        this.hitBoxesReadOnly$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ObservableList<HitBox>>(this){
            final /* synthetic */ BoundingBoxComponent this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final ObservableList<HitBox> invoke() {
                return FXCollections.unmodifiableObservableList((ObservableList)BoundingBoxComponent.access$getHitBoxes$p(this.this$0));
            }
        }));
        this.width = new ReadOnlyDoubleWrapper();
        this.height = new ReadOnlyDoubleWrapper();
        this.minXLocal = new ReadOnlyDoubleWrapper();
        this.minYLocal = new ReadOnlyDoubleWrapper();
        this.minXWorld = new ReadOnlyDoubleWrapper();
        this.minYWorld = new ReadOnlyDoubleWrapper();
        this.maxXWorld = new ReadOnlyDoubleWrapper();
        this.maxYWorld = new ReadOnlyDoubleWrapper();
        this.onHitBoxChange = arg_0 -> BoundingBoxComponent.onHitBoxChange$lambda-2(this, arg_0);
        this.hitBoxes.addAll((Object[])Arrays.copyOf(boxes, boxes.length));
        this.minXLocal.set(this.computeMinXLocal());
        this.minYLocal.set(this.computeMinYLocal());
        this.width.set(this.computeWidth());
        this.height.set(this.computeHeight());
        this.hitBoxes.addListener(this.onHitBoxChange);
        this.dummy = new CollisionResult();
    }

    @NotNull
    public final TransformComponent getTransform() {
        TransformComponent transformComponent = this.transform;
        if (transformComponent != null) {
            return transformComponent;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"transform");
        throw null;
    }

    public final void setTransform(@NotNull TransformComponent transformComponent) {
        Intrinsics.checkNotNullParameter((Object)transformComponent, (String)"<set-?>");
        this.transform = transformComponent;
    }

    private final ObservableList<HitBox> getHitBoxesReadOnly() {
        Lazy lazy = this.hitBoxesReadOnly$delegate;
        boolean bl = false;
        return (ObservableList)lazy.getValue();
    }

    public final double getMaxXLocal() {
        return this.getWidth();
    }

    public final double getMaxYLocal() {
        return this.getHeight();
    }

    @NotNull
    public final Point2D getCenterLocal() {
        return new Point2D(this.getWidth() / (double)2, this.getHeight() / (double)2);
    }

    @NotNull
    public final Point2D getCenterWorld() {
        Point2D point2D = this.getCenterLocal().add(this.getMinXWorld(), this.getMinYWorld());
        Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"centerLocal.add(getMinXWorld(), getMinYWorld())");
        return point2D;
    }

    @NotNull
    public final ReadOnlyDoubleProperty minXLocalProperty() {
        ReadOnlyDoubleProperty readOnlyDoubleProperty = this.minXLocal.getReadOnlyProperty();
        Intrinsics.checkNotNullExpressionValue((Object)readOnlyDoubleProperty, (String)"minXLocal.readOnlyProperty");
        return readOnlyDoubleProperty;
    }

    public final double getMinXLocal() {
        Double d = this.minXLocal.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"minXLocal.value");
        return ((Number)d).doubleValue();
    }

    @NotNull
    public final ReadOnlyDoubleProperty minYLocalProperty() {
        ReadOnlyDoubleProperty readOnlyDoubleProperty = this.minYLocal.getReadOnlyProperty();
        Intrinsics.checkNotNullExpressionValue((Object)readOnlyDoubleProperty, (String)"minYLocal.readOnlyProperty");
        return readOnlyDoubleProperty;
    }

    public final double getMinYLocal() {
        Double d = this.minYLocal.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"minYLocal.value");
        return ((Number)d).doubleValue();
    }

    @NotNull
    public final ReadOnlyDoubleProperty minXWorldProperty() {
        ReadOnlyDoubleProperty readOnlyDoubleProperty = this.minXWorld.getReadOnlyProperty();
        Intrinsics.checkNotNullExpressionValue((Object)readOnlyDoubleProperty, (String)"minXWorld.readOnlyProperty");
        return readOnlyDoubleProperty;
    }

    @NotNull
    public final ReadOnlyDoubleProperty minYWorldProperty() {
        ReadOnlyDoubleProperty readOnlyDoubleProperty = this.minYWorld.getReadOnlyProperty();
        Intrinsics.checkNotNullExpressionValue((Object)readOnlyDoubleProperty, (String)"minYWorld.readOnlyProperty");
        return readOnlyDoubleProperty;
    }

    @NotNull
    public final ReadOnlyDoubleProperty maxXWorldProperty() {
        ReadOnlyDoubleProperty readOnlyDoubleProperty = this.maxXWorld.getReadOnlyProperty();
        Intrinsics.checkNotNullExpressionValue((Object)readOnlyDoubleProperty, (String)"maxXWorld.readOnlyProperty");
        return readOnlyDoubleProperty;
    }

    @NotNull
    public final ReadOnlyDoubleProperty maxYWorldProperty() {
        ReadOnlyDoubleProperty readOnlyDoubleProperty = this.maxYWorld.getReadOnlyProperty();
        Intrinsics.checkNotNullExpressionValue((Object)readOnlyDoubleProperty, (String)"maxYWorld.readOnlyProperty");
        return readOnlyDoubleProperty;
    }

    public final double getMinXWorld() {
        return this.getTransform().getX() + this.getMinXLocal();
    }

    public final double getMinYWorld() {
        return this.getTransform().getY() + this.getMinYLocal();
    }

    public final double getMaxXWorld() {
        return this.getTransform().getX() + this.getMinXLocal() + this.getWidth();
    }

    public final double getMaxYWorld() {
        return this.getTransform().getY() + this.getMinYLocal() + this.getHeight();
    }

    @Override
    public void onAdded() {
        ObservableList<HitBox> observableList = this.entity.getTransformComponent();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"entity.transformComponent");
        this.setTransform((TransformComponent)observableList);
        this.minXWorld.bind((ObservableValue)this.minXLocal.add((ObservableNumberValue)this.getTransform().xProperty()));
        this.minYWorld.bind((ObservableValue)this.minYLocal.add((ObservableNumberValue)this.getTransform().yProperty()));
        this.maxXWorld.bind((ObservableValue)this.minXWorld.add((ObservableNumberValue)this.width));
        this.maxYWorld.bind((ObservableValue)this.minYWorld.add((ObservableNumberValue)this.height));
        observableList = this.hitBoxes;
        Intrinsics.checkNotNullExpressionValue(observableList, (String)"hitBoxes");
        Iterable $this$forEach$iv = (Iterable)observableList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HitBox it = (HitBox)element$iv;
            boolean bl = false;
            it.bindXY(this.getTransform());
        }
    }

    @Override
    public void onRemoved() {
        this.hitBoxes.removeListener(this.onHitBoxChange);
        ObservableList<HitBox> observableList = this.hitBoxes;
        Intrinsics.checkNotNullExpressionValue(observableList, (String)"hitBoxes");
        Iterable $this$forEach$iv = (Iterable)observableList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HitBox it = (HitBox)element$iv;
            boolean bl = false;
            it.unbind();
        }
        this.minXWorld.unbind();
        this.minYWorld.unbind();
        this.maxXWorld.unbind();
        this.maxYWorld.unbind();
    }

    @NotNull
    public final ObservableList<HitBox> hitBoxesProperty() {
        ObservableList<HitBox> observableList = this.getHitBoxesReadOnly();
        Intrinsics.checkNotNullExpressionValue(observableList, (String)"hitBoxesReadOnly");
        return observableList;
    }

    public final void addHitBox(@NotNull HitBox hitBox) {
        Intrinsics.checkNotNullParameter((Object)hitBox, (String)"hitBox");
        this.hitBoxes.add((Object)hitBox);
    }

    public final void removeHitBox(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.hitBoxes.removeIf(arg_0 -> BoundingBoxComponent.removeHitBox$lambda-5(name, arg_0));
    }

    public final void clearHitBoxes() {
        this.hitBoxes.clear();
    }

    public final double getWidth() {
        Double d = this.width.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"width.value");
        return ((Number)d).doubleValue();
    }

    @NotNull
    public final ReadOnlyDoubleProperty widthProperty() {
        ReadOnlyDoubleProperty readOnlyDoubleProperty = this.width.getReadOnlyProperty();
        Intrinsics.checkNotNullExpressionValue((Object)readOnlyDoubleProperty, (String)"width.readOnlyProperty");
        return readOnlyDoubleProperty;
    }

    public final double getHeight() {
        Double d = this.height.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"height.value");
        return ((Number)d).doubleValue();
    }

    @NotNull
    public final ReadOnlyDoubleProperty heightProperty() {
        ReadOnlyDoubleProperty readOnlyDoubleProperty = this.height.getReadOnlyProperty();
        Intrinsics.checkNotNullExpressionValue((Object)readOnlyDoubleProperty, (String)"height.readOnlyProperty");
        return readOnlyDoubleProperty;
    }

    /*
     * WARNING - void declaration
     */
    private final double computeWidth() {
        void $this$mapTo$iv$iv;
        ObservableList<HitBox> observableList = this.hitBoxes;
        Intrinsics.checkNotNullExpressionValue(observableList, (String)"hitBoxes");
        Iterable $this$map$iv = (Iterable)observableList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HitBox hitBox = (HitBox)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Double d = it.getBounds().getMaxX() - this.getMinXLocal();
            collection.add(d);
        }
        Double d = CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        return d == null ? 0.0 : d;
    }

    /*
     * WARNING - void declaration
     */
    private final double computeHeight() {
        void $this$mapTo$iv$iv;
        ObservableList<HitBox> observableList = this.hitBoxes;
        Intrinsics.checkNotNullExpressionValue(observableList, (String)"hitBoxes");
        Iterable $this$map$iv = (Iterable)observableList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HitBox hitBox = (HitBox)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Double d = it.getBounds().getMaxY() - this.getMinYLocal();
            collection.add(d);
        }
        Double d = CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        return d == null ? 0.0 : d;
    }

    /*
     * WARNING - void declaration
     */
    private final double computeMinXLocal() {
        void $this$mapTo$iv$iv;
        ObservableList<HitBox> observableList = this.hitBoxes;
        Intrinsics.checkNotNullExpressionValue(observableList, (String)"hitBoxes");
        Iterable $this$map$iv = (Iterable)observableList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HitBox hitBox = (HitBox)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Double d = it.getMinX();
            collection.add(d);
        }
        Double d = CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv));
        return d == null ? 0.0 : d;
    }

    /*
     * WARNING - void declaration
     */
    private final double computeMinYLocal() {
        void $this$mapTo$iv$iv;
        ObservableList<HitBox> observableList = this.hitBoxes;
        Intrinsics.checkNotNullExpressionValue(observableList, (String)"hitBoxes");
        Iterable $this$map$iv = (Iterable)observableList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HitBox hitBox = (HitBox)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Double d = it.getMinY();
            collection.add(d);
        }
        Double d = CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv));
        return d == null ? 0.0 : d;
    }

    public final void applyTransformToHitBoxes$fxgl_entity() {
        ObservableList<HitBox> observableList = this.hitBoxes;
        Intrinsics.checkNotNullExpressionValue(observableList, (String)"hitBoxes");
        Iterable $this$forEach$iv = (Iterable)observableList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HitBox it = (HitBox)element$iv;
            boolean bl = false;
            it.applyTransform(this.getTransform());
        }
    }

    public final boolean isCollidingWith(@NotNull BoundingBoxComponent other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.checkCollision(other, this.dummy);
    }

    public final boolean checkCollision(@NotNull BoundingBoxComponent other, @NotNull CollisionResult result) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.applyTransformToHitBoxes$fxgl_entity();
        other.applyTransformToHitBoxes$fxgl_entity();
        return this.checkCollisionPAT(other, result);
    }

    public final boolean checkCollisionPAT(@NotNull BoundingBoxComponent other, @NotNull CollisionResult result) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        int n = 0;
        int n2 = this.hitBoxes.size() + -1;
        if (n <= n2) {
            do {
                int i = n++;
                HitBox box1 = (HitBox)this.hitBoxes.get(i);
                int n3 = 0;
                int n4 = other.hitBoxes.size() + -1;
                if (n3 > n4) continue;
                do {
                    int j = n3++;
                    HitBox box2 = (HitBox)other.hitBoxes.get(j);
                    boolean collision = false;
                    double angle1 = this.getEntity().getRotation();
                    double angle2 = other.getEntity().getRotation();
                    if (angle1 == 0.0 && angle2 == 0.0) {
                        Intrinsics.checkNotNullExpressionValue((Object)box1, (String)"box1");
                        Intrinsics.checkNotNullExpressionValue((Object)box2, (String)"box2");
                        collision = this.checkCollisionPAT(box1, box2, this.getTransform(), other.getTransform());
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)box1, (String)"box1");
                        Intrinsics.checkNotNullExpressionValue((Object)box2, (String)"box2");
                        collision = this.checkCollision(box1, box2, angle1, angle2, this.getTransform(), other.getTransform());
                    }
                    if (!collision) continue;
                    result.init(box1, box2);
                    return true;
                } while (n3 <= n4);
            } while (n <= n2);
        }
        return false;
    }

    private final boolean checkCollisionPAT(HitBox box1, HitBox box2, TransformComponent t1, TransformComponent t2) {
        if (box1.getShape() instanceof Box3DShapeData && box2.getShape() instanceof Box3DShapeData) {
            BoundingShape boundingShape = box1.getShape();
            if (boundingShape == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.almasb.fxgl.physics.Box3DShapeData");
            }
            Box3DShapeData shape1 = (Box3DShapeData)boundingShape;
            BoundingShape boundingShape2 = box2.getShape();
            if (boundingShape2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.almasb.fxgl.physics.Box3DShapeData");
            }
            Box3DShapeData shape2 = (Box3DShapeData)boundingShape2;
            BoundingBox bbox1 = new BoundingBox(t1.getX() - shape1.getWidth() / 2.0, t1.getY() - shape1.getHeight() / 2.0, t1.getZ() - shape1.getDepth() / 2.0, shape1.getWidth(), shape1.getHeight(), shape1.getDepth());
            BoundingBox bbox2 = new BoundingBox(t2.getX() - shape2.getWidth() / 2.0, t2.getY() - shape2.getHeight() / 2.0, t2.getZ() - shape2.getDepth() / 2.0, shape2.getWidth(), shape2.getHeight(), shape2.getDepth());
            return bbox1.intersects((Bounds)bbox2);
        }
        return box2.getFastMaxX() >= box1.getFastMinX() && box2.getFastMaxY() >= box1.getFastMinY() && box2.getFastMinX() <= box1.getFastMaxX() && box2.getFastMinY() <= box1.getFastMaxY();
    }

    private final boolean checkCollision(HitBox box1, HitBox box2, double angle1, double angle2, TransformComponent t1, TransformComponent t2) {
        return SAT.isColliding(box1, box2, angle1, angle2, t1, t2);
    }

    public final boolean isWithin(@NotNull Rectangle2D bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return this.isWithin(bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY());
    }

    public final boolean isWithin(double minX, double minY, double maxX, double maxY) {
        return !this.isOutside(minX, minY, maxX, maxY);
    }

    public final boolean isOutside(@NotNull Rectangle2D bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return this.isOutside(bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY());
    }

    public final boolean isOutside(double minX, double minY, double maxX, double maxY) {
        return this.getTransform().getX() + this.getMinXLocal() + this.getWidth() < minX || this.getTransform().getX() + this.getMinXLocal() > maxX || this.getTransform().getY() + this.getMinYLocal() + this.getHeight() < minY || this.getTransform().getY() + this.getMinYLocal() > maxY;
    }

    @NotNull
    public final Rectangle2D range(double width, double height) {
        double minX = this.getMinXWorld() - width;
        double minY = this.getMinYWorld() - height;
        double maxX = this.getMaxXWorld() + width;
        double maxY = this.getMaxYWorld() + height;
        return new Rectangle2D(minX, minY, maxX - minX, maxY - minY);
    }

    public void write(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        bundle.put("hitBoxes", (Serializable)new ArrayList((Collection)this.hitBoxes));
    }

    public void read(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        this.hitBoxes.addAll((Collection)bundle.get("hitBoxes"));
    }

    @Override
    public boolean isComponentInjectionRequired() {
        return false;
    }

    @Override
    @NotNull
    public String toString() {
        return "bbox(" + this.hitBoxes + ')';
    }

    private static final void onHitBoxChange$lambda-2(BoundingBoxComponent this$0, ListChangeListener.Change c) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.minXLocal.set(this$0.computeMinXLocal());
        this$0.minYLocal.set(this$0.computeMinYLocal());
        this$0.width.set(this$0.computeWidth());
        this$0.height.set(this$0.computeHeight());
        while (c.next()) {
            HitBox it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            if (c.wasAdded()) {
                List list = c.getAddedSubList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"c.addedSubList");
                $this$forEach$iv = list;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (HitBox)element$iv;
                    boolean bl = false;
                    it.bindXY(this$0.getTransform());
                }
                continue;
            }
            if (!c.wasRemoved()) continue;
            $this$forEach$iv = c.getRemoved();
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"c.removed");
            $this$forEach$iv = $this$forEach$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (HitBox)element$iv;
                boolean bl = false;
                it.unbind();
            }
        }
    }

    private static final boolean removeHitBox$lambda-5(String $name, HitBox h) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        return Intrinsics.areEqual((Object)h.getName(), (Object)$name);
    }

    public static final /* synthetic */ ObservableList access$getHitBoxes$p(BoundingBoxComponent $this) {
        return $this.hitBoxes;
    }
}

