/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.dynamics;

import com.almasb.fxgl.physics.box2d.callbacks.ContactFilter;
import com.almasb.fxgl.physics.box2d.callbacks.ContactListener;
import com.almasb.fxgl.physics.box2d.callbacks.PairCallback;
import com.almasb.fxgl.physics.box2d.collision.broadphase.BroadPhase;
import com.almasb.fxgl.physics.box2d.collision.shapes.ShapeType;
import com.almasb.fxgl.physics.box2d.dynamics.Body;
import com.almasb.fxgl.physics.box2d.dynamics.BodyType;
import com.almasb.fxgl.physics.box2d.dynamics.Fixture;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.Contact;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.ContactEdge;
import com.almasb.fxgl.physics.box2d.pooling.IDynamicStack;
import com.almasb.fxgl.physics.box2d.pooling.IWorldPool;

class ContactManager
implements PairCallback {
    Contact contactList = null;
    int contactCount = 0;
    private ContactListener contactListener = null;
    private ContactFilter contactFilter = new ContactFilter();
    private final IWorldPool pool;
    final BroadPhase broadPhase;
    private ContactRegister[][] contactStacks = new ContactRegister[ShapeType.values().length][ShapeType.values().length];

    ContactManager(IWorldPool pool, BroadPhase broadPhase) {
        this.pool = pool;
        this.broadPhase = broadPhase;
        this.initializeRegisters();
    }

    private void initializeRegisters() {
        this.addType(this.pool.getCircleContactStack(), ShapeType.CIRCLE, ShapeType.CIRCLE);
        this.addType(this.pool.getPolyCircleContactStack(), ShapeType.POLYGON, ShapeType.CIRCLE);
        this.addType(this.pool.getPolyContactStack(), ShapeType.POLYGON, ShapeType.POLYGON);
        this.addType(this.pool.getEdgeCircleContactStack(), ShapeType.EDGE, ShapeType.CIRCLE);
        this.addType(this.pool.getEdgePolyContactStack(), ShapeType.EDGE, ShapeType.POLYGON);
        this.addType(this.pool.getChainCircleContactStack(), ShapeType.CHAIN, ShapeType.CIRCLE);
        this.addType(this.pool.getChainPolyContactStack(), ShapeType.CHAIN, ShapeType.POLYGON);
    }

    private void addType(IDynamicStack<Contact> creator, ShapeType type1, ShapeType type2) {
        this.contactStacks[type1.ordinal()][type2.ordinal()] = new ContactRegister(creator, true);
        if (type1 != type2) {
            this.contactStacks[type2.ordinal()][type1.ordinal()] = new ContactRegister(creator, false);
        }
    }

    void setContactFilter(ContactFilter contactFilter) {
        this.contactFilter = contactFilter;
    }

    void setContactListener(ContactListener contactListener) {
        this.contactListener = contactListener;
    }

    ContactListener getContactListener() {
        return this.contactListener;
    }

    @Override
    public void addPair(Object proxyUserDataA, Object proxyUserDataB) {
        Body bodyB;
        Fixture.FixtureProxy proxyA = (Fixture.FixtureProxy)proxyUserDataA;
        Fixture.FixtureProxy proxyB = (Fixture.FixtureProxy)proxyUserDataB;
        Fixture fixtureA = proxyA.fixture;
        Fixture fixtureB = proxyB.fixture;
        int indexA = proxyA.childIndex;
        int indexB = proxyB.childIndex;
        Body bodyA = fixtureA.getBody();
        if (bodyA == (bodyB = fixtureB.getBody())) {
            return;
        }
        ContactEdge edge = bodyB.getContactList();
        while (edge != null) {
            if (edge.other == bodyA) {
                Fixture fA = edge.contact.getFixtureA();
                Fixture fB = edge.contact.getFixtureB();
                int iA = edge.contact.getChildIndexA();
                int iB = edge.contact.getChildIndexB();
                if (fA == fixtureA && iA == indexA && fB == fixtureB && iB == indexB) {
                    return;
                }
                if (fA == fixtureB && iA == indexB && fB == fixtureA && iB == indexA) {
                    return;
                }
            }
            edge = edge.next;
        }
        if (!bodyB.shouldCollide(bodyA)) {
            return;
        }
        if (this.contactFilter != null && !this.contactFilter.shouldCollide(fixtureA, fixtureB)) {
            return;
        }
        Contact c = this.popContact(fixtureA, indexA, fixtureB, indexB);
        if (c == null) {
            return;
        }
        fixtureA = c.getFixtureA();
        fixtureB = c.getFixtureB();
        bodyA = fixtureA.getBody();
        bodyB = fixtureB.getBody();
        c.m_prev = null;
        c.m_next = this.contactList;
        if (this.contactList != null) {
            this.contactList.m_prev = c;
        }
        this.contactList = c;
        c.m_nodeA.contact = c;
        c.m_nodeA.other = bodyB;
        c.m_nodeA.prev = null;
        c.m_nodeA.next = bodyA.m_contactList;
        if (bodyA.m_contactList != null) {
            bodyA.m_contactList.prev = c.m_nodeA;
        }
        bodyA.m_contactList = c.m_nodeA;
        c.m_nodeB.contact = c;
        c.m_nodeB.other = bodyA;
        c.m_nodeB.prev = null;
        c.m_nodeB.next = bodyB.m_contactList;
        if (bodyB.m_contactList != null) {
            bodyB.m_contactList.prev = c.m_nodeB;
        }
        bodyB.m_contactList = c.m_nodeB;
        if (!fixtureA.isSensor() && !fixtureB.isSensor()) {
            bodyA.setAwake(true);
            bodyB.setAwake(true);
        }
        ++this.contactCount;
    }

    void findNewContacts() {
        this.broadPhase.updatePairs(this);
    }

    void destroy(Contact c) {
        Fixture fixtureA = c.getFixtureA();
        Fixture fixtureB = c.getFixtureB();
        Body bodyA = fixtureA.getBody();
        Body bodyB = fixtureB.getBody();
        if (this.contactListener != null && c.isTouching()) {
            this.contactListener.endContact(c);
        }
        if (c.m_prev != null) {
            c.m_prev.m_next = c.m_next;
        }
        if (c.m_next != null) {
            c.m_next.m_prev = c.m_prev;
        }
        if (c == this.contactList) {
            this.contactList = c.m_next;
        }
        if (c.m_nodeA.prev != null) {
            c.m_nodeA.prev.next = c.m_nodeA.next;
        }
        if (c.m_nodeA.next != null) {
            c.m_nodeA.next.prev = c.m_nodeA.prev;
        }
        if (c.m_nodeA == bodyA.m_contactList) {
            bodyA.m_contactList = c.m_nodeA.next;
        }
        if (c.m_nodeB.prev != null) {
            c.m_nodeB.prev.next = c.m_nodeB.next;
        }
        if (c.m_nodeB.next != null) {
            c.m_nodeB.next.prev = c.m_nodeB.prev;
        }
        if (c.m_nodeB == bodyB.m_contactList) {
            bodyB.m_contactList = c.m_nodeB.next;
        }
        this.pushContact(c);
        --this.contactCount;
    }

    void collide() {
        Contact c = this.contactList;
        while (c != null) {
            int proxyIdB;
            boolean activeB;
            Fixture fixtureA = c.getFixtureA();
            Fixture fixtureB = c.getFixtureB();
            int indexA = c.getChildIndexA();
            int indexB = c.getChildIndexB();
            Body bodyA = fixtureA.getBody();
            Body bodyB = fixtureB.getBody();
            if ((c.m_flags & 8) == 8) {
                if (!bodyB.shouldCollide(bodyA)) {
                    Contact cNuke = c;
                    c = cNuke.getNext();
                    this.destroy(cNuke);
                    continue;
                }
                if (this.contactFilter != null && !this.contactFilter.shouldCollide(fixtureA, fixtureB)) {
                    Contact cNuke = c;
                    c = cNuke.getNext();
                    this.destroy(cNuke);
                    continue;
                }
                c.m_flags &= 0xFFFFFFF7;
            }
            boolean activeA = bodyA.isAwake() && bodyA.getType() != BodyType.STATIC;
            boolean bl = activeB = bodyB.isAwake() && bodyB.getType() != BodyType.STATIC;
            if (!activeA && !activeB) {
                c = c.getNext();
                continue;
            }
            int proxyIdA = fixtureA.getProxyId(indexA);
            boolean overlap = this.broadPhase.testOverlap(proxyIdA, proxyIdB = fixtureB.getProxyId(indexB));
            if (!overlap) {
                Contact cNuke = c;
                c = cNuke.getNext();
                this.destroy(cNuke);
                continue;
            }
            c.update(this.contactListener);
            c = c.getNext();
        }
    }

    private Contact popContact(Fixture fixtureA, int indexA, Fixture fixtureB, int indexB) {
        ShapeType type1 = fixtureA.getType();
        ShapeType type2 = fixtureB.getType();
        ContactRegister reg = this.contactStacks[type1.ordinal()][type2.ordinal()];
        if (reg == null) {
            return null;
        }
        Contact c = reg.creator.pop();
        if (reg.primary) {
            c.init(fixtureA, indexA, fixtureB, indexB);
        } else {
            c.init(fixtureB, indexB, fixtureA, indexA);
        }
        return c;
    }

    private void pushContact(Contact contact) {
        Fixture fixtureA = contact.getFixtureA();
        Fixture fixtureB = contact.getFixtureB();
        if (contact.m_manifold.pointCount > 0 && !fixtureA.isSensor() && !fixtureB.isSensor()) {
            fixtureA.getBody().setAwake(true);
            fixtureB.getBody().setAwake(true);
        }
        ShapeType type1 = fixtureA.getType();
        ShapeType type2 = fixtureB.getType();
        IDynamicStack<Contact> creator = this.contactStacks[type1.ordinal()][type2.ordinal()].creator;
        creator.push(contact);
    }

    private static class ContactRegister {
        final IDynamicStack<Contact> creator;
        final boolean primary;

        ContactRegister(IDynamicStack<Contact> creator, boolean primary) {
            this.creator = creator;
            this.primary = primary;
        }
    }
}

