/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.dynamics.joints;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.physics.box2d.dynamics.Body;
import com.almasb.fxgl.physics.box2d.dynamics.World;
import com.almasb.fxgl.physics.box2d.dynamics.joints.JointDef;
import com.almasb.fxgl.physics.box2d.dynamics.joints.WeldJoint;

public class WeldJointDef
extends JointDef<WeldJoint> {
    public final Vec2 localAnchorA = new Vec2();
    public final Vec2 localAnchorB = new Vec2();
    public float referenceAngle = 0.0f;
    public float frequencyHz;
    public float dampingRatio;

    public void initialize(Body bA, Body bB, Vec2 anchor) {
        this.setBodyA(bA);
        this.setBodyB(bB);
        bA.getLocalPointToOut(anchor, this.localAnchorA);
        bB.getLocalPointToOut(anchor, this.localAnchorB);
        this.referenceAngle = bB.getAngle() - bA.getAngle();
    }

    @Override
    protected WeldJoint createJoint(World world) {
        return new WeldJoint(world.getPool(), this);
    }
}

