/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.action;

import com.almasb.fxgl.entity.Entity;

public abstract class Action {
    protected Entity entity;
    private boolean isCompleted = false;
    private boolean isCancelled = false;

    public final Entity getEntity() {
        return this.entity;
    }

    public final void setEntity(Entity entity) {
        if (this.entity != null && this.entity != entity) {
            throw new IllegalArgumentException("Attempting to set a different entity to action");
        }
        this.entity = entity;
    }

    public final boolean isComplete() {
        return this.isCompleted;
    }

    public final void setComplete() {
        this.isCompleted = true;
    }

    public final boolean isCancelled() {
        return this.isCancelled;
    }

    public final void cancel() {
        if (this.isCancelled) {
            return;
        }
        this.isCancelled = true;
        this.onCancelled();
    }

    protected void onQueued() {
    }

    protected void onStarted() {
    }

    protected abstract void onUpdate(double var1);

    protected void onCompleted() {
    }

    protected void onCancelled() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

