/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.collision;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.physics.box2d.collision.Distance;
import com.almasb.fxgl.physics.box2d.collision.DistanceInput;
import com.almasb.fxgl.physics.box2d.collision.DistanceOutput;
import com.almasb.fxgl.physics.box2d.collision.DistanceProxy;
import com.almasb.fxgl.physics.box2d.collision.SeparationFunction;
import com.almasb.fxgl.physics.box2d.collision.shapes.Shape;
import com.almasb.fxgl.physics.box2d.common.JBoxSettings;
import com.almasb.fxgl.physics.box2d.common.Sweep;
import com.almasb.fxgl.physics.box2d.common.Transform;
import com.almasb.fxgl.physics.box2d.pooling.IWorldPool;

public class TimeOfImpact {
    private static final int MAX_ITERATIONS = 1000;
    private final Distance.SimplexCache cache = new Distance.SimplexCache();
    private final DistanceInput distanceInput = new DistanceInput();
    private final Transform xfA = new Transform();
    private final Transform xfB = new Transform();
    private final DistanceOutput distanceOutput = new DistanceOutput();
    private final SeparationFunction fcn = new SeparationFunction();
    private final int[] indexes = new int[2];
    private final Sweep sweepA = new Sweep();
    private final Sweep sweepB = new Sweep();
    private final IWorldPool pool;

    public TimeOfImpact(IWorldPool pool) {
        this.pool = pool;
    }

    public final void timeOfImpact(TOIOutput output, TOIInput input) {
        block12: {
            output.state = TOIOutputState.UNKNOWN;
            output.t = input.tMax;
            DistanceProxy proxyA = input.proxyA;
            DistanceProxy proxyB = input.proxyB;
            this.sweepA.set(input.sweepA);
            this.sweepB.set(input.sweepB);
            this.sweepA.normalize();
            this.sweepB.normalize();
            float tMax = input.tMax;
            float totalRadius = proxyA.getRadius() + proxyB.getRadius();
            float target = Math.max(JBoxSettings.linearSlop, totalRadius - 3.0f * JBoxSettings.linearSlop);
            float tolerance = 0.25f * JBoxSettings.linearSlop;
            assert (target > tolerance);
            float t1 = 0.0f;
            int iter = 0;
            this.cache.count = 0;
            this.distanceInput.proxyA = input.proxyA;
            this.distanceInput.proxyB = input.proxyB;
            this.distanceInput.useRadii = false;
            do {
                this.sweepA.getTransform(this.xfA, t1);
                this.sweepB.getTransform(this.xfB, t1);
                this.distanceInput.transformA = this.xfA;
                this.distanceInput.transformB = this.xfB;
                this.pool.getDistance().distance(this.distanceOutput, this.cache, this.distanceInput);
                if (this.distanceOutput.distance <= 0.0f) {
                    output.state = TOIOutputState.OVERLAPPED;
                    output.t = 0.0f;
                    break block12;
                }
                if (this.distanceOutput.distance < target + tolerance) {
                    output.state = TOIOutputState.TOUCHING;
                    output.t = t1;
                    break block12;
                }
                this.fcn.initialize(this.cache, proxyA, this.sweepA, proxyB, this.sweepB, t1);
                boolean done = false;
                float t2 = tMax;
                int pushBackIter = 0;
                block1: do {
                    float s2;
                    if ((s2 = this.fcn.findMinSeparation(this.indexes, t2)) > target + tolerance) {
                        output.state = TOIOutputState.SEPARATED;
                        output.t = tMax;
                        done = true;
                        break;
                    }
                    if (s2 > target - tolerance) {
                        t1 = t2;
                        break;
                    }
                    float s1 = this.fcn.evaluate(this.indexes[0], this.indexes[1], t1);
                    if (s1 < target - tolerance) {
                        output.state = TOIOutputState.FAILED;
                        output.t = t1;
                        done = true;
                        break;
                    }
                    if (s1 <= target + tolerance) {
                        output.state = TOIOutputState.TOUCHING;
                        output.t = t1;
                        done = true;
                        break;
                    }
                    int rootIterCount = 0;
                    float a1 = t1;
                    float a2 = t2;
                    do {
                        float t;
                        float s;
                        if (FXGLMath.abs((float)((s = this.fcn.evaluate(this.indexes[0], this.indexes[1], t = rootIterCount & true ? a1 + (target - s1) * (a2 - a1) / (s2 - s1) : 0.5f * (a1 + a2))) - target)) < tolerance) {
                            t2 = t;
                            continue block1;
                        }
                        if (s > target) {
                            a1 = t;
                            s1 = s;
                            continue;
                        }
                        a2 = t;
                        s2 = s;
                    } while (++rootIterCount != 50);
                } while (++pushBackIter != JBoxSettings.maxPolygonVertices);
                ++iter;
                if (done) break block12;
            } while (iter != 1000);
            output.state = TOIOutputState.FAILED;
            output.t = t1;
        }
    }

    public static enum TOIOutputState {
        UNKNOWN,
        FAILED,
        OVERLAPPED,
        TOUCHING,
        SEPARATED;

    }

    public static class TOIOutput {
        public TOIOutputState state;
        public float t;
    }

    public static class TOIInput {
        public final DistanceProxy proxyA = new DistanceProxy();
        public final DistanceProxy proxyB = new DistanceProxy();
        public final Sweep sweepA = new Sweep();
        public final Sweep sweepB = new Sweep();
        public float tMax;

        public void setProxyA(Shape shape, int index) {
            this.proxyA.set(shape, index);
        }

        public void setProxyB(Shape shape, int index) {
            this.proxyB.set(shape, index);
        }
    }
}

