/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.common;

import com.almasb.fxgl.core.math.Vec2;
import java.io.Serializable;

public final class Mat22
implements Serializable {
    private static final long serialVersionUID = 2L;
    public final Vec2 ex = new Vec2();
    public final Vec2 ey = new Vec2();

    public void setZero() {
        this.ex.setZero();
        this.ey.setZero();
    }

    public void invertToOut(Mat22 out) {
        float a = this.ex.x;
        float b = this.ey.x;
        float c = this.ex.y;
        float d = this.ey.y;
        float det = a * d - b * c;
        det = 1.0f / det;
        out.ex.x = det * d;
        out.ey.x = -det * b;
        out.ex.y = -det * c;
        out.ey.y = det * a;
    }

    public void solveToOut(Vec2 b, Vec2 out) {
        float a11 = this.ex.x;
        float a22 = this.ey.y;
        float a12 = this.ey.x;
        float a21 = this.ex.y;
        float det = a11 * a22 - a12 * a21;
        if (det != 0.0f) {
            det = 1.0f / det;
        }
        float tempy = det * (a11 * b.y - a21 * b.x);
        out.x = det * (a22 * b.x - a12 * b.y);
        out.y = tempy;
    }

    public static void mulToOutUnsafe(Mat22 R, Vec2 v, Vec2 out) {
        out.x = R.ex.x * v.x + R.ey.x * v.y;
        out.y = R.ex.y * v.x + R.ey.y * v.y;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.ex.hashCode();
        result = prime * result + this.ey.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Mat22 other = (Mat22)obj;
        if (this.ex == null ? other.ex != null : !this.ex.equals((Object)other.ex)) {
            return false;
        }
        return !(this.ey == null ? other.ey != null : !this.ey.equals((Object)other.ey));
    }

    public String toString() {
        return "[" + this.ex.x + "," + this.ey.x + "]\n[" + this.ex.y + "," + this.ey.y + "]";
    }
}

