/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.pooling;

import com.almasb.fxgl.physics.box2d.pooling.IDynamicStack;

public abstract class MutableStack<E>
implements IDynamicStack<E> {
    private E[] stack = null;
    private int index = 0;
    private int size;

    public MutableStack(int initialSize) {
        this.extendStack(initialSize);
    }

    private void extendStack(int newSize) {
        E[] newStack = this.newArray(newSize);
        if (this.stack != null) {
            System.arraycopy(this.stack, 0, newStack, 0, this.size);
        }
        for (int i = 0; i < newStack.length; ++i) {
            newStack[i] = this.newInstance();
        }
        this.stack = newStack;
        this.size = newStack.length;
    }

    @Override
    public final E pop() {
        if (this.index >= this.size) {
            this.extendStack(this.size * 2);
        }
        return this.stack[this.index++];
    }

    @Override
    public final void push(E argObject) {
        assert (this.index > 0);
        this.stack[--this.index] = argObject;
    }

    protected abstract E newInstance();

    protected abstract E[] newArray(int var1);
}

