/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.level.tiled;

import com.almasb.fxgl.entity.level.tiled.Layer;
import com.almasb.fxgl.entity.level.tiled.Tile;
import com.almasb.fxgl.entity.level.tiled.TiledMap;
import com.almasb.fxgl.entity.level.tiled.Tileset;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.texture.ImagesKt;
import com.almasb.fxgl.texture.Texture;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\u0000J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0002J(\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\tJ\u000e\u0010!\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\tR*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/almasb/fxgl/entity/level/tiled/TilesetLoader;", "", "map", "Lcom/almasb/fxgl/entity/level/tiled/TiledMap;", "mapURL", "Ljava/net/URL;", "(Lcom/almasb/fxgl/entity/level/tiled/TiledMap;Ljava/net/URL;)V", "imageCache", "Ljava/util/HashMap;", "", "Ljavafx/scene/image/Image;", "Lkotlin/collections/HashMap;", "log", "Lcom/almasb/fxgl/logging/Logger;", "copy", "findTileset", "Lcom/almasb/fxgl/entity/level/tiled/Tileset;", "gid", "", "tilesets", "", "loadImage", "tilesetImageName", "transparentcolor", "w", "h", "loadView", "Ljavafx/scene/Node;", "gidArg", "isFlippedHorizontal", "", "isFlippedVertical", "layerName", "loadViewHex", "fxgl-entity"})
public final class TilesetLoader {
    @NotNull
    private final TiledMap map;
    @NotNull
    private final URL mapURL;
    @NotNull
    private final Logger log;
    @NotNull
    private final HashMap<String, Image> imageCache;

    public TilesetLoader(@NotNull TiledMap map, @NotNull URL mapURL) {
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)mapURL, (String)"mapURL");
        this.map = map;
        this.mapURL = mapURL;
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$get = false;
        this.log = this_$iv.get(TilesetLoader.class);
        boolean bl = false;
        this.imageCache = new HashMap();
    }

    @NotNull
    public final Node loadView(int gidArg, boolean isFlippedHorizontal, boolean isFlippedVertical) {
        int gid = 0;
        gid = gidArg;
        Tileset tileset = this.findTileset(gid, this.map.getTilesets());
        gid -= tileset.getFirstgid();
        int w = tileset.getTilewidth();
        int h = tileset.getTileheight();
        WritableImage buffer = new WritableImage(w, h);
        Image sourceImage = null;
        int srcx = 0;
        int srcy = 0;
        if (tileset.isSpriteSheet()) {
            int tilex = gid % tileset.getColumns();
            int tiley = gid / tileset.getColumns();
            sourceImage = this.loadImage(tileset.getImage(), tileset.getTransparentcolor(), tileset.getImagewidth(), tileset.getImageheight());
            srcx = tilex * w + tileset.getMargin() + tilex * tileset.getSpacing();
            srcy = tiley * h + tileset.getMargin() + tiley * tileset.getSpacing();
        } else {
            Object v0;
            block4: {
                Iterable iterable = tileset.getTiles();
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    Tile it = (Tile)t;
                    boolean bl3 = false;
                    if (!(it.getId() == gid)) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            Tile tile = v0;
            if (tile == null) {
                throw new IllegalArgumentException("Tile with id=" + gid + " not found");
            }
            Tile tile2 = tile;
            sourceImage = this.loadImage(tile2.getImage(), tile2.getTransparentcolor(), tile2.getImagewidth(), tile2.getImageheight());
            srcx = 0;
            srcy = 0;
        }
        buffer.getPixelWriter().setPixels(0, 0, w, h, sourceImage.getPixelReader(), srcx, srcy);
        ImageView imageView = new ImageView((Image)buffer);
        boolean bl = false;
        boolean bl4 = false;
        ImageView it = imageView;
        boolean bl5 = false;
        it.setScaleX(isFlippedHorizontal ? -1.0 : 1.0);
        it.setScaleY(isFlippedVertical ? -1.0 : 1.0);
        return (Node)imageView;
    }

    @NotNull
    public final Node loadView(@NotNull String layerName) {
        Intrinsics.checkNotNullParameter((Object)layerName, (String)"layerName");
        this.log.debug("Loading view for layer " + layerName);
        Layer layer = this.map.getLayerByName(layerName);
        WritableImage buffer = new WritableImage(layer.getWidth() * this.map.getTilewidth(), layer.getHeight() * this.map.getTileheight());
        this.log.debug("Created buffer with size " + buffer.getWidth() + "x" + buffer.getHeight());
        int n = 0;
        int n2 = layer.getData().size();
        if (n < n2) {
            do {
                Iterable iterable;
                int i = n++;
                long tempGid = ((Number)layer.getData().get(i)).longValue();
                long FLIPPED_HORIZONTALLY_FLAG = 0x80000000L;
                long FLIPPED_VERTICALLY_FLAG = 0x40000000L;
                long FLIPPED_DIAGONALLY_FLAG = 0x20000000L;
                boolean isFlippedHorizontal = (tempGid & FLIPPED_HORIZONTALLY_FLAG) != 0L;
                boolean isFlippedVertical = (tempGid & FLIPPED_VERTICALLY_FLAG) != 0L;
                boolean isFlippedDiagonal = (tempGid & FLIPPED_DIAGONALLY_FLAG) != 0L;
                int gid = 0;
                gid = (int)(tempGid & ((FLIPPED_HORIZONTALLY_FLAG | FLIPPED_VERTICALLY_FLAG | FLIPPED_DIAGONALLY_FLAG) ^ 0xFFFFFFFFFFFFFFFFL));
                if (gid == 0) continue;
                Tileset tileset = this.findTileset(gid, this.map.getTilesets());
                gid -= tileset.getFirstgid();
                int x = i % layer.getWidth();
                int y = i / layer.getWidth();
                int w = tileset.getTilewidth();
                int h = tileset.getTileheight();
                Object sourceImage = null;
                int srcx = 0;
                int srcy = 0;
                if (tileset.isSpriteSheet()) {
                    sourceImage = this.loadImage(tileset.getImage(), tileset.getTransparentcolor(), tileset.getImagewidth(), tileset.getImageheight());
                    int tilex = gid % tileset.getColumns();
                    int tiley = gid / tileset.getColumns();
                    srcx = tilex * w + tileset.getMargin() + tilex * tileset.getSpacing();
                    srcy = tiley * h + tileset.getMargin() + tiley * tileset.getSpacing();
                    if (isFlippedHorizontal | isFlippedVertical | isFlippedDiagonal) {
                        iterable = new Texture(sourceImage).subTexture(new Rectangle2D((double)srcx, (double)srcy, (double)w, (double)h)).getImage();
                        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"Texture(sourceImage).sub\u2026e(), h.toDouble())).image");
                        sourceImage = iterable;
                        srcx = 0;
                        srcy = 0;
                    }
                } else {
                    Object v0;
                    block10: {
                        iterable = tileset.getTiles();
                        boolean bl = false;
                        Iterable iterable2 = iterable;
                        boolean bl2 = false;
                        for (Object t : iterable2) {
                            Tile it = (Tile)t;
                            boolean bl3 = false;
                            if (!(it.getId() == gid)) continue;
                            v0 = t;
                            break block10;
                        }
                        v0 = null;
                    }
                    Tile tile = v0;
                    if (tile == null) {
                        throw new IllegalArgumentException("Tile with id=" + gid + " not found");
                    }
                    Tile tile2 = tile;
                    sourceImage = this.loadImage(tile2.getImage(), tile2.getTransparentcolor(), tile2.getImagewidth(), tile2.getImageheight());
                    srcx = 0;
                    srcy = 0;
                }
                if (isFlippedHorizontal) {
                    sourceImage = ImagesKt.flipHorizontally((Image)sourceImage);
                }
                if (isFlippedVertical) {
                    sourceImage = ImagesKt.flipVertically((Image)sourceImage);
                }
                if (isFlippedDiagonal) {
                    this.log.warning("Diagonally flipped tiles are not currently supported");
                }
                buffer.getPixelWriter().setPixels(x * this.map.getTilewidth(), y * this.map.getTileheight(), w, h, sourceImage.getPixelReader(), srcx, srcy);
            } while (n < n2);
        }
        return (Node)new ImageView((Image)buffer);
    }

    @NotNull
    public final Node loadViewHex(@NotNull String layerName) {
        Intrinsics.checkNotNullParameter((Object)layerName, (String)"layerName");
        this.log.debug("Loading view for layer " + layerName);
        Layer layer = this.map.getLayerByName(layerName);
        WritableImage bufferBottom = new WritableImage(layer.getWidth() * this.map.getTilewidth() + 100, layer.getHeight() * this.map.getTileheight() + 100);
        this.log.debug("Created buffer with size " + bufferBottom.getWidth() + "x" + bufferBottom.getHeight());
        boolean bl = false;
        ArrayList delayedDrawings = new ArrayList();
        int oldY = 0;
        int n = 0;
        int n2 = layer.getData().size();
        if (n < n2) {
            do {
                int offsetY;
                Iterable iterable;
                int i = n++;
                int gid = 0;
                gid = (int)((Number)layer.getData().get(i)).longValue();
                if (gid == 0) continue;
                Tileset tileset = this.findTileset(gid, this.map.getTilesets());
                gid -= tileset.getFirstgid();
                int x = i % layer.getWidth();
                int y = i / layer.getWidth();
                boolean isColumnEven = x % 2 == 0;
                int w = tileset.getTilewidth();
                int h = tileset.getTileheight();
                Image sourceImage = null;
                int srcx = 0;
                int srcy = 0;
                if (tileset.isSpriteSheet()) {
                    sourceImage = this.loadImage(tileset.getImage(), tileset.getTransparentcolor(), tileset.getImagewidth(), tileset.getImageheight());
                    int tilex = gid % tileset.getColumns();
                    int tiley = gid / tileset.getColumns();
                    srcx = tilex * w + tileset.getMargin() + tilex * tileset.getSpacing();
                    srcy = tiley * h + tileset.getMargin() + tiley * tileset.getSpacing();
                } else {
                    Object v0;
                    block11: {
                        iterable = tileset.getTiles();
                        boolean bl2 = false;
                        Iterable iterable2 = iterable;
                        boolean bl3 = false;
                        Iterator iterator = iterable2.iterator();
                        while (iterator.hasNext()) {
                            Object t = iterator.next();
                            Tile it = (Tile)t;
                            boolean bl4 = false;
                            if (!(it.getId() == gid)) continue;
                            v0 = t;
                            break block11;
                        }
                        v0 = null;
                    }
                    Tile tiley = v0;
                    if (tiley == null) {
                        throw new IllegalArgumentException("Tile with id=" + gid + " not found");
                    }
                    Tile tile = tiley;
                    sourceImage = this.loadImage(tile.getImage(), tile.getTransparentcolor(), tile.getImagewidth(), tile.getImageheight());
                    srcx = 0;
                    srcy = 0;
                }
                this.log.debug("Writing to buffer: dst=" + x * this.map.getTilewidth() + "," + y * this.map.getTileheight() + ", w=" + w + ",h=" + h + ", src=" + srcx + "," + srcy);
                int offsetX = -(this.map.getHexsidelength() + 6) * x;
                int n3 = offsetY = Intrinsics.areEqual((Object)this.map.getStaggerindex(), (Object)"even") && isColumnEven || Intrinsics.areEqual((Object)this.map.getStaggerindex(), (Object)"odd") && !isColumnEven ? this.map.getTileheight() / 2 : 0;
                if (y > oldY) {
                    Iterable $this$forEach$iv = delayedDrawings;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Runnable it = (Runnable)element$iv;
                        boolean bl5 = false;
                        it.run();
                    }
                    delayedDrawings.clear();
                    oldY = y;
                }
                if (Intrinsics.areEqual((Object)this.map.getStaggerindex(), (Object)"odd") && isColumnEven || Intrinsics.areEqual((Object)this.map.getStaggerindex(), (Object)"even") && !isColumnEven) {
                    int n4 = 0;
                    if (n4 >= h) continue;
                    do {
                        int dy = n4++;
                        int n5 = 0;
                        if (n5 >= w) continue;
                        do {
                            int dx = n5++;
                            Color c = sourceImage.getPixelReader().getColor(srcx + dx, srcy + dy);
                            if (Intrinsics.areEqual((Object)c, (Object)Color.TRANSPARENT)) continue;
                            bufferBottom.getPixelWriter().setColor(x * this.map.getTilewidth() + offsetX + dx, y * this.map.getTileheight() + offsetY + dy, c);
                        } while (n5 < w);
                    } while (n4 < h);
                    continue;
                }
                iterable = delayedDrawings;
                Runnable runnable = () -> TilesetLoader.loadViewHex$lambda-5(h, w, sourceImage, srcx, srcy, bufferBottom, x, this, offsetX, y, offsetY);
                boolean bl6 = false;
                iterable.add(runnable);
            } while (n < n2);
        }
        return (Node)new ImageView((Image)bufferBottom);
    }

    private final Tileset findTileset(int gid, List<Tileset> tilesets) {
        for (Tileset tileset : tilesets) {
            if (gid < tileset.getFirstgid() || gid >= tileset.getFirstgid() + tileset.getTilecount()) continue;
            return tileset;
        }
        throw new IllegalArgumentException("Tileset for gid=" + gid + " not found");
    }

    private final Image loadImage(String tilesetImageName, String transparentcolor, int w, int h) {
        Object object;
        Object object2 = tilesetImageName;
        int n = StringsKt.lastIndexOf$default((CharSequence)tilesetImageName, (String)"/", (int)0, (boolean)false, (int)6, null) + 1;
        boolean bl = false;
        String string = object2;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        String imageName = string2;
        object2 = this.imageCache;
        n = 0;
        Object object3 = object2;
        boolean bl2 = false;
        if (object3.containsKey(imageName)) {
            Image image = this.imageCache.get(imageName);
            Intrinsics.checkNotNull((Object)image);
            object2 = image;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"imageCache[imageName]!!");
            return (Image)object2;
        }
        try {
            Image image;
            object3 = this.mapURL.toExternalForm();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"mapURL.toExternalForm()");
            String ext = StringsKt.substringBeforeLast$default((String)object3, (String)"/", null, (int)2, null) + "/";
            InputStream stream = new URL(ext + imageName).openStream();
            CharSequence charSequence = transparentcolor;
            boolean bl3 = false;
            if (charSequence.length() == 0) {
                image = new Image(stream);
            } else {
                Texture texture = new Texture(new Image(stream));
                charSequence = Color.web((String)transparentcolor);
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"web(transparentcolor)");
                image = texture.transparentColor((Color)charSequence).getImage();
            }
            Image img = image;
            stream.close();
            if (img.isError()) {
                this.log.warning(ext + imageName + " cannot be loaded");
                img = ImagesKt.resize((Image)ImagesKt.getDummyImage(), (int)w, (int)h);
            }
            object = img;
        }
        catch (Exception e) {
            this.log.warning(imageName + " cannot be loaded using mapURL=" + this.mapURL, (Throwable)e);
            object = ImagesKt.resize((Image)ImagesKt.getDummyImage(), (int)w, (int)h);
        }
        Image image = object;
        object = this.imageCache;
        Intrinsics.checkNotNullExpressionValue((Object)image, (String)"image");
        object3 = image;
        boolean bl4 = false;
        object.put(imageName, object3);
        return image;
    }

    @NotNull
    public final TilesetLoader copy() {
        return new TilesetLoader(this.map, this.mapURL);
    }

    private static final void loadViewHex$lambda-5(int $h, int $w, Image $sourceImage, int $srcx, int $srcy, WritableImage $bufferBottom, int $x, TilesetLoader this$0, int $offsetX, int $y, int $offsetY) {
        Intrinsics.checkNotNullParameter((Object)$sourceImage, (String)"$sourceImage");
        Intrinsics.checkNotNullParameter((Object)$bufferBottom, (String)"$bufferBottom");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int n = 0;
        if (n < $h) {
            do {
                int dy = n++;
                int n2 = 0;
                if (n2 >= $w) continue;
                do {
                    int dx = n2++;
                    Color c = $sourceImage.getPixelReader().getColor($srcx + dx, $srcy + dy);
                    if (Intrinsics.areEqual((Object)c, (Object)Color.TRANSPARENT)) continue;
                    $bufferBottom.getPixelWriter().setColor($x * this$0.map.getTilewidth() + $offsetX + dx, $y * this$0.map.getTileheight() + $offsetY + dy, c);
                } while (n2 < $w);
            } while (n < $h);
        }
    }
}

