/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.level.tiled;

import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.entity.SpawnData;
import com.almasb.fxgl.entity.components.IDComponent;
import com.almasb.fxgl.entity.components.ViewComponent;
import com.almasb.fxgl.entity.level.Level;
import com.almasb.fxgl.entity.level.LevelLoader;
import com.almasb.fxgl.entity.level.LevelLoadingException;
import com.almasb.fxgl.entity.level.tiled.Layer;
import com.almasb.fxgl.entity.level.tiled.TMXLevelLoaderKt;
import com.almasb.fxgl.entity.level.tiled.TextData;
import com.almasb.fxgl.entity.level.tiled.Tile;
import com.almasb.fxgl.entity.level.tiled.TiledMap;
import com.almasb.fxgl.entity.level.tiled.TiledObject;
import com.almasb.fxgl.entity.level.tiled.Tileset;
import com.almasb.fxgl.entity.level.tiled.TilesetLoader;
import com.almasb.fxgl.logging.Logger;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Polyline;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\rH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010&\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010'\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010(\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010+\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010,\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010-\u001a\u00020\u0003H\u0002J\u0018\u0010.\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010/\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u00100\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u00101\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u00102\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/almasb/fxgl/entity/level/tiled/TMXLevelLoader;", "Lcom/almasb/fxgl/entity/level/LevelLoader;", "isParallel", "", "(Z)V", "log", "Lcom/almasb/fxgl/logging/Logger;", "createObjectLayerEntities", "", "Lcom/almasb/fxgl/entity/Entity;", "map", "Lcom/almasb/fxgl/entity/level/tiled/TiledMap;", "tilesetLoader", "Lcom/almasb/fxgl/entity/level/tiled/TilesetLoader;", "world", "Lcom/almasb/fxgl/entity/GameWorld;", "createTileLayerEntities", "loader", "load", "Lcom/almasb/fxgl/entity/level/Level;", "url", "Ljava/net/URL;", "parse", "inputStream", "Ljava/io/InputStream;", "parseData", "", "layer", "Lcom/almasb/fxgl/entity/level/tiled/Layer;", "data", "", "start", "Ljavax/xml/stream/events/StartElement;", "parseImage", "tile", "Lcom/almasb/fxgl/entity/level/tiled/Tile;", "tileset", "Lcom/almasb/fxgl/entity/level/tiled/Tileset;", "parseMap", "parseMapProperty", "parseObject", "obj", "Lcom/almasb/fxgl/entity/level/tiled/TiledObject;", "parseObjectGroupLayer", "parseObjectPolyline", "isClosed", "parseObjectProperty", "parseTextProperty", "parseTile", "parseTileLayer", "parseTileset", "fxgl-entity"})
@SourceDebugExtension(value={"SMAP\nTMXLevelLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TMXLevelLoader.kt\ncom/almasb/fxgl/entity/level/tiled/TMXLevelLoader\n+ 2 Logger.kt\ncom/almasb/fxgl/logging/Logger$Companion\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,566:1\n157#2:567\n1#3:568\n215#4,2:569\n215#4,2:586\n215#4,2:588\n766#5:571\n857#5,2:572\n766#5:574\n857#5,2:575\n1360#5:577\n1446#5,5:578\n1549#5:583\n1620#5,2:584\n1622#5:590\n1549#5:591\n1620#5,3:592\n1360#5:595\n1446#5,5:596\n1549#5:601\n1620#5,3:602\n*S KotlinDebug\n*F\n+ 1 TMXLevelLoader.kt\ncom/almasb/fxgl/entity/level/tiled/TMXLevelLoader\n*L\n48#1:567\n64#1:569,2\n148#1:586,2\n155#1:588,2\n84#1:571\n84#1:572,2\n122#1:574\n122#1:575,2\n123#1:577\n123#1:578,5\n124#1:583\n124#1:584,2\n124#1:590\n360#1:591\n360#1:592,3\n524#1:595\n524#1:596,5\n525#1:601\n525#1:602,3\n*E\n"})
public final class TMXLevelLoader
implements LevelLoader {
    private final boolean isParallel;
    @NotNull
    private final Logger log;

    @JvmOverloads
    public TMXLevelLoader(boolean isParallel) {
        this.isParallel = isParallel;
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$get = false;
        this.log = this_$iv.get(TMXLevelLoader.class);
    }

    public /* synthetic */ TMXLevelLoader(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Level load(@NotNull URL url, @NotNull GameWorld world) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        try {
            Closeable closeable = url.openStream();
            Throwable throwable = null;
            try {
                Object it = (InputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                it = this.parse((InputStream)it);
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object map = it;
            this.log.debug("Parsed TiledMap: " + url);
            TilesetLoader tilesetLoader = new TilesetLoader((TiledMap)map, url);
            List<Entity> tileLayerEntities = this.createTileLayerEntities((TiledMap)map, tilesetLoader);
            List<Entity> objectEntities = this.createObjectLayerEntities((TiledMap)map, tilesetLoader, world);
            Level level = new Level(((TiledMap)map).getWidth() * ((TiledMap)map).getTilewidth(), ((TiledMap)map).getHeight() * ((TiledMap)map).getTileheight(), CollectionsKt.plus((Collection)tileLayerEntities, (Iterable)objectEntities));
            Map<String, Object> $this$forEach$iv = ((TiledMap)map).getProperties();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Object>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> element$iv;
                Map.Entry<String, Object> entry = element$iv = iterator.next();
                boolean bl = false;
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Float) {
                    level.getProperties().setValue(key, (Object)((Number)value).floatValue());
                    continue;
                }
                level.getProperties().setValue(key, value);
            }
            return level;
        }
        catch (Exception e) {
            this.log.warning("Parse error", (Throwable)e);
            throw new LevelLoadingException(String.valueOf(e.getMessage()), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Entity> createTileLayerEntities(TiledMap map, TilesetLoader loader) {
        void $this$filterTo$iv$iv;
        this.log.debug("Creating tile layer entities");
        Iterable $this$filter$iv = map.getLayers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Layer it = (Layer)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)"tilelayer")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List layers = (List)destination$iv$iv;
        Stream stream = this.isParallel ? layers.parallelStream() : layers.stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"if (isParallel) layers.p\u2026am() else layers.stream()");
        Stream stream2 = stream;
        List<Entity> list = stream2.map(arg_0 -> TMXLevelLoader.createTileLayerEntities$lambda$3((Function1)new Function1<Layer, Entity>(this, loader, map){
            final /* synthetic */ TMXLevelLoader this$0;
            final /* synthetic */ TilesetLoader $loader;
            final /* synthetic */ TiledMap $map;
            {
                this.this$0 = $receiver;
                this.$loader = $loader;
                this.$map = $map;
                super(1);
            }

            public final Entity invoke(Layer layer) {
                TilesetLoader tilesetLoader = TMXLevelLoader.access$isParallel$p(this.this$0) ? this.$loader.copy() : this.$loader;
                Entity entity = new Entity();
                TiledMap tiledMap = this.$map;
                TMXLevelLoader tMXLevelLoader = this.this$0;
                Entity it = entity;
                boolean bl = false;
                it.setType((Serializable)((Object)"TiledMapLayer"));
                it.setProperty("layer", layer);
                switch (tiledMap.getOrientation()) {
                    case "orthogonal": {
                        ViewComponent viewComponent = it.getViewComponent();
                        Intrinsics.checkNotNullExpressionValue((Object)viewComponent, (String)"it.viewComponent");
                        ViewComponent.addChild$default(viewComponent, tilesetLoader.loadView(layer.getName()), false, 2, null);
                        break;
                    }
                    case "hexagonal": {
                        ViewComponent viewComponent = it.getViewComponent();
                        Intrinsics.checkNotNullExpressionValue((Object)viewComponent, (String)"it.viewComponent");
                        ViewComponent.addChild$default(viewComponent, tilesetLoader.loadViewHex(layer.getName()), false, 2, null);
                        break;
                    }
                    case "isometric": {
                        ViewComponent viewComponent = it.getViewComponent();
                        Intrinsics.checkNotNullExpressionValue((Object)viewComponent, (String)"it.viewComponent");
                        ViewComponent.addChild$default(viewComponent, tilesetLoader.loadViewIsometric(layer.getName()), false, 2, null);
                        break;
                    }
                    default: {
                        TMXLevelLoader.access$getLog$p(tMXLevelLoader).warning("Unknown map orientation: " + tiledMap.getOrientation());
                    }
                }
                return entity;
            }
        }, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"private fun createTileLa\u2026ollectors.toList())\n    }");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Entity> createObjectLayerEntities(TiledMap map, TilesetLoader tilesetLoader, GameWorld world) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Layer it;
        void $this$filterTo$iv$iv;
        this.log.debug("Creating object layer entities");
        Iterable $this$filter$iv = map.getLayers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Layer)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)"objectgroup")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Layer)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getObjects();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Entity entity;
            Map.Entry it2;
            Object it3;
            void tiledObject;
            SpawnData data;
            list$iv$iv = (TiledObject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SpawnData $this$createObjectLayerEntities_u24lambda_u2411_u24lambda_u248 = data = new SpawnData(tiledObject.getX(), tiledObject.getY() - (tiledObject.getGid() == 0 ? 0 : tiledObject.getHeight()), 0.0, 4, null);
            boolean bl2 = false;
            $this$createObjectLayerEntities_u24lambda_u2411_u24lambda_u248.put("name", tiledObject.getName());
            $this$createObjectLayerEntities_u24lambda_u2411_u24lambda_u248.put("type", tiledObject.getType());
            $this$createObjectLayerEntities_u24lambda_u2411_u24lambda_u248.put("class", tiledObject.getType());
            $this$createObjectLayerEntities_u24lambda_u2411_u24lambda_u248.put("width", tiledObject.getWidth());
            $this$createObjectLayerEntities_u24lambda_u2411_u24lambda_u248.put("height", tiledObject.getHeight());
            $this$createObjectLayerEntities_u24lambda_u2411_u24lambda_u248.put("rotation", Float.valueOf(tiledObject.getRotation()));
            $this$createObjectLayerEntities_u24lambda_u2411_u24lambda_u248.put("id", tiledObject.getId());
            $this$createObjectLayerEntities_u24lambda_u2411_u24lambda_u248.put("gid", tiledObject.getGid());
            TextData textData = tiledObject.getTextData();
            if (textData != null) {
                it3 = textData;
                boolean bl3 = false;
                $this$createObjectLayerEntities_u24lambda_u2411_u24lambda_u248.put("text", ((TextData)it3).getText());
                $this$createObjectLayerEntities_u24lambda_u2411_u24lambda_u248.put("color", ((TextData)it3).getColor());
            }
            Map<String, Object> $this$forEach$iv = tiledObject.getProperties();
            boolean $i$f$forEach = false;
            it3 = $this$forEach$iv.entrySet().iterator();
            while (it3.hasNext()) {
                Map.Entry element$iv;
                it2 = element$iv = (Map.Entry)it3.next();
                boolean bl4 = false;
                $this$createObjectLayerEntities_u24lambda_u2411_u24lambda_u248.put((String)it2.getKey(), it2.getValue());
            }
            Entity e = entity = world.create(tiledObject.getType(), data);
            boolean bl5 = false;
            Map $this$forEach$iv2 = data.getData();
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                it2 = element$iv = iterator.next();
                boolean bl6 = false;
                e.setProperty((String)it2.getKey(), it2.getValue());
            }
            e.addComponent(new IDComponent(tiledObject.getName(), tiledObject.getId()));
            e.setPosition(data.getX(), data.getY());
            e.setRotation(tiledObject.getRotation());
            if (tiledObject.getGid() != 0) {
                ViewComponent viewComponent = e.getViewComponent();
                Intrinsics.checkNotNullExpressionValue((Object)viewComponent, (String)"e.viewComponent");
                ViewComponent.addChild$default(viewComponent, tilesetLoader.loadView(tiledObject.getGid(), tiledObject.isFlippedHorizontal(), tiledObject.isFlippedVertical()), false, 2, null);
            }
            collection.add(entity);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final TiledMap parse(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader eventReader = inputFactory.createXMLEventReader(inputStream, "UTF-8");
        TiledMap map = new TiledMap(0, 0, 0, 0, null, null, null, null, null, 0, 0, null, null, false, 0, null, null, null, null, 524287, null);
        ArrayList<Layer> layers = new ArrayList<Layer>();
        ArrayList<Tileset> tilesets = new ArrayList<Tileset>();
        Layer currentLayer = new Layer(0, 0, null, null, false, 0, 0, null, null, 0.0f, null, 2047, null);
        Tileset currentTileset = new Tileset(0, null, null, 0, 0, 0, 0, 0, 0, 0, 0, null, null, 8191, null);
        Tile currentTile = new Tile(0, null, 0, 0, null, 31, null);
        TiledObject currentObject = new TiledObject(0, 0, 0, null, null, null, false, 0, 0, 0.0f, 0, false, false, null, null, null, 65535, null);
        boolean insideTileTag = false;
        boolean mapPropertiesFinished = false;
        while (eventReader.hasNext()) {
            EndElement endElement;
            int n;
            String string;
            XMLEvent event;
            block58: {
                StartElement start;
                event = eventReader.nextEvent();
                if (!event.isStartElement() || (string = (start = event.asStartElement()).getName().getLocalPart()) == null) break block58;
                n = -1;
                switch (string.hashCode()) {
                    case 100313435: {
                        if (string.equals("image")) {
                            n = 1;
                        }
                        break;
                    }
                    case 3076010: {
                        if (string.equals("data")) {
                            n = 2;
                        }
                        break;
                    }
                    case -397519558: {
                        if (string.equals("polygon")) {
                            n = 3;
                        }
                        break;
                    }
                    case -1314831628: {
                        if (string.equals("tileset")) {
                            n = 4;
                        }
                        break;
                    }
                    case 3560110: {
                        if (string.equals("tile")) {
                            n = 5;
                        }
                        break;
                    }
                    case -993141291: {
                        if (string.equals("property")) {
                            n = 6;
                        }
                        break;
                    }
                    case 3556653: {
                        if (string.equals("text")) {
                            n = 7;
                        }
                        break;
                    }
                    case 107868: {
                        if (string.equals("map")) {
                            n = 8;
                        }
                        break;
                    }
                    case 102749521: {
                        if (string.equals("layer")) {
                            n = 9;
                        }
                        break;
                    }
                    case 561938880: {
                        if (string.equals("polyline")) {
                            n = 10;
                        }
                        break;
                    }
                    case -1269857632: {
                        if (string.equals("objectgroup")) {
                            n = 11;
                        }
                        break;
                    }
                    case -1023368385: {
                        if (string.equals("object")) {
                            n = 12;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 8: {
                        Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                        this.parseMap(map, start);
                        break;
                    }
                    case 4: {
                        currentTileset = new Tileset(0, null, null, 0, 0, 0, 0, 0, 0, 0, 0, null, null, 8191, null);
                        Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                        this.parseTileset(currentTileset, start);
                        break;
                    }
                    case 5: {
                        currentTile = new Tile(0, null, 0, 0, null, 31, null);
                        Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                        this.parseTile(currentTile, start);
                        insideTileTag = true;
                        break;
                    }
                    case 1: {
                        if (insideTileTag) {
                            Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                            this.parseImage(currentTile, start);
                            break;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                        this.parseImage(currentTileset, start);
                        break;
                    }
                    case 9: {
                        currentLayer = new Layer(0, 0, null, null, false, 0, 0, null, null, 0.0f, null, 2047, null);
                        Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                        this.parseTileLayer(currentLayer, start);
                        break;
                    }
                    case 2: {
                        String string2 = eventReader.getElementText();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"eventReader.elementText");
                        Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                        this.parseData(currentLayer, string2, start);
                        break;
                    }
                    case 11: {
                        currentLayer = new Layer(0, 0, null, null, false, 0, 0, null, null, 0.0f, null, 2047, null);
                        Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                        this.parseObjectGroupLayer(currentLayer, start);
                        break;
                    }
                    case 12: {
                        mapPropertiesFinished = true;
                        currentObject = new TiledObject(0, 0, 0, null, null, null, false, 0, 0, 0.0f, 0, false, false, null, null, null, 65535, null);
                        Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                        this.parseObject(currentLayer, currentObject, start);
                        break;
                    }
                    case 6: {
                        if (mapPropertiesFinished) {
                            Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                            this.parseObjectProperty(currentObject, start);
                            break;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                        this.parseMapProperty(map, start);
                        break;
                    }
                    case 7: {
                        String string3 = eventReader.getElementText();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"eventReader.elementText");
                        Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                        this.parseTextProperty(currentObject, string3, start);
                        break;
                    }
                    case 3: {
                        Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                        this.parseObjectPolyline(currentObject, start, true);
                        break;
                    }
                    case 10: {
                        Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
                        this.parseObjectPolyline(currentObject, start, false);
                    }
                }
            }
            if (!event.isEndElement() || (string = (endElement = event.asEndElement()).getName().getLocalPart()) == null) continue;
            tmp = -1;
            switch (string.hashCode()) {
                case -1314831628: {
                    if (string.equals("tileset")) {
                        tmp = 1;
                    }
                    break;
                }
                case 3560110: {
                    if (string.equals("tile")) {
                        tmp = 2;
                    }
                    break;
                }
                case 102749521: {
                    if (string.equals("layer")) {
                        tmp = 3;
                    }
                    break;
                }
                case -1269857632: {
                    if (string.equals("objectgroup")) {
                        tmp = 3;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    tilesets.add(currentTileset);
                    break;
                }
                case 2: {
                    currentTileset.getTiles().add(currentTile);
                    insideTileTag = false;
                    break;
                }
                case 3: {
                    layers.add(currentLayer);
                }
            }
        }
        map.setLayers((List<Layer>)layers);
        map.setTilesets((List<Tileset>)tilesets);
        return map;
    }

    private final void parseMap(TiledMap map, StartElement start) {
        map.setWidth(TMXLevelLoaderKt.access$getInt(start, "width"));
        map.setHeight(TMXLevelLoaderKt.access$getInt(start, "height"));
        map.setTilewidth(TMXLevelLoaderKt.access$getInt(start, "tilewidth"));
        map.setTileheight(TMXLevelLoaderKt.access$getInt(start, "tileheight"));
        map.setNextobjectid(TMXLevelLoaderKt.access$getInt(start, "nextobjectid"));
        map.setType("map");
        map.setVersion(1);
        map.setInfinite(TMXLevelLoaderKt.access$getInt(start, "infinite") == 1);
        map.setBackgroundcolor(TMXLevelLoaderKt.access$getString(start, "backgroundcolor"));
        map.setOrientation(TMXLevelLoaderKt.access$getString(start, "orientation"));
        map.setHexsidelength(TMXLevelLoaderKt.access$getInt(start, "hexsidelength"));
        map.setStaggeraxis(TMXLevelLoaderKt.access$getString(start, "staggeraxis"));
        map.setStaggerindex(TMXLevelLoaderKt.access$getString(start, "staggerindex"));
        map.setRenderorder(TMXLevelLoaderKt.access$getString(start, "renderorder"));
        map.setTiledversion(TMXLevelLoaderKt.access$getString(start, "tiledversion"));
        if (!Intrinsics.areEqual((Object)map.getTiledversion(), (Object)"1.9.0")) {
            this.log.warning("TiledMap generated from " + map.getTiledversion() + ". Supported version: 1.9.0. Some features may not be parsed fully.");
        }
    }

    private final void parseTileset(Tileset tileset, StartElement start) {
        tileset.setFirstgid(TMXLevelLoaderKt.access$getInt(start, "firstgid"));
        tileset.setName(TMXLevelLoaderKt.access$getString(start, "name"));
        tileset.setTilewidth(TMXLevelLoaderKt.access$getInt(start, "tilewidth"));
        tileset.setTileheight(TMXLevelLoaderKt.access$getInt(start, "tileheight"));
        tileset.setMargin(TMXLevelLoaderKt.access$getInt(start, "margin"));
        tileset.setSpacing(TMXLevelLoaderKt.access$getInt(start, "spacing"));
        tileset.setTilecount(TMXLevelLoaderKt.access$getInt(start, "tilecount"));
        tileset.setColumns(TMXLevelLoaderKt.access$getInt(start, "columns"));
    }

    private final void parseTile(Tile tile, StartElement start) {
        tile.setId(TMXLevelLoaderKt.access$getInt(start, "id"));
    }

    private final void parseImage(Tileset tileset, StartElement start) {
        tileset.setImage(TMXLevelLoaderKt.access$getString(start, "source"));
        tileset.setImagewidth(TMXLevelLoaderKt.access$getInt(start, "width"));
        tileset.setImageheight(TMXLevelLoaderKt.access$getInt(start, "height"));
        tileset.setTransparentcolor(TMXLevelLoaderKt.access$getString(start, "trans"));
    }

    private final void parseImage(Tile tile, StartElement start) {
        tile.setImage(TMXLevelLoaderKt.access$getString(start, "source"));
        tile.setImagewidth(TMXLevelLoaderKt.access$getInt(start, "width"));
        tile.setImageheight(TMXLevelLoaderKt.access$getInt(start, "height"));
        tile.setTransparentcolor(TMXLevelLoaderKt.access$getString(start, "trans"));
    }

    private final void parseTileLayer(Layer layer, StartElement start) {
        layer.setType("tilelayer");
        layer.setName(TMXLevelLoaderKt.access$getString(start, "name"));
        layer.setWidth(TMXLevelLoaderKt.access$getInt(start, "width"));
        layer.setHeight(TMXLevelLoaderKt.access$getInt(start, "height"));
        layer.setOpacity(TMXLevelLoaderKt.access$getFloat(start, "opacity"));
        layer.setVisible(TMXLevelLoaderKt.access$getInt(start, "visible") == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void parseData(Layer layer, String data, StartElement start) {
        String string = TMXLevelLoaderKt.access$getString(start, "encoding");
        if (Intrinsics.areEqual((Object)string, (Object)"csv")) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object = new String[]{","};
            object = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)data, (String)"\n", (String)"", (boolean)false, (int)4, null), (String[])object, (boolean)false, (int)0, (int)6, null);
            Layer layer2 = layer;
            boolean $i$f$map = false;
            void var7_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Long.parseLong(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString()));
            }
            layer2.setData((List)destination$iv$iv);
        } else if (Intrinsics.areEqual((Object)string, (Object)"base64")) {
            InputStream inputStream;
            byte[] bytes = Base64.getDecoder().decode(((Object)StringsKt.trim((CharSequence)data)).toString());
            String $this$mapTo$iv$iv = TMXLevelLoaderKt.access$getString(start, "compression");
            if (Intrinsics.areEqual((Object)$this$mapTo$iv$iv, (Object)"zlib")) {
                Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
                inputStream = new InflaterInputStream(new ByteArrayInputStream(bytes));
            } else if (Intrinsics.areEqual((Object)$this$mapTo$iv$iv, (Object)"gzip")) {
                Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
                inputStream = new GZIPInputStream(new ByteArrayInputStream(bytes));
            } else {
                this.log.warning("Unsupported base64 compression: '" + TMXLevelLoaderKt.access$getString(start, "compression") + "'. " + layer.getName() + " may fail to render.");
                inputStream = InputStream.nullInputStream();
            }
            InputStream inputStream2 = inputStream;
            ArrayList<Long> longArray = new ArrayList<Long>();
            Closeable closeable = inputStream2;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                while (it.available() > 0) {
                    byte[] rawInt = it.readNBytes(4);
                    long value = ((long)rawInt[0] & 0xFFL) << 0 | ((long)rawInt[1] & 0xFFL) << 8 | ((long)rawInt[2] & 0xFFL) << 16 | ((long)rawInt[3] & 0xFFL) << 24;
                    longArray.add(value);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            layer.setData((List<Long>)longArray);
        }
    }

    private final void parseObjectGroupLayer(Layer layer, StartElement start) {
        layer.setType("objectgroup");
        layer.setName(TMXLevelLoaderKt.access$getString(start, "name"));
    }

    private final void parseObject(Layer layer, TiledObject obj, StartElement start) {
        obj.setName(TMXLevelLoaderKt.access$getString(start, "name"));
        obj.setType(TMXLevelLoaderKt.access$getString(start, "type"));
        obj.setTypeClass(TMXLevelLoaderKt.access$getString(start, "class"));
        obj.setId(TMXLevelLoaderKt.access$getInt(start, "id"));
        obj.setX(TMXLevelLoaderKt.access$getInt(start, "x"));
        obj.setY(TMXLevelLoaderKt.access$getInt(start, "y"));
        obj.setRotation(TMXLevelLoaderKt.access$getFloat(start, "rotation"));
        obj.setWidth(TMXLevelLoaderKt.access$getInt(start, "width"));
        obj.setHeight(TMXLevelLoaderKt.access$getInt(start, "height"));
        if (((CharSequence)obj.getTypeClass()).length() > 0 && ((CharSequence)obj.getType()).length() == 0) {
            obj.setType(obj.getTypeClass());
        }
        int gidUInt = TMXLevelLoaderKt.access$getUInt(start, "gid");
        int FLIPPED_HORIZONTALLY_FLAG = UInt.constructor-impl((int)Integer.MIN_VALUE);
        int FLIPPED_VERTICALLY_FLAG = UInt.constructor-impl((int)0x40000000);
        int FLIPPED_DIAGONALLY_FLAG = UInt.constructor-impl((int)0x20000000);
        obj.setFlippedHorizontal(UInt.constructor-impl((int)(gidUInt & FLIPPED_HORIZONTALLY_FLAG)) != UInt.constructor-impl((int)0));
        obj.setFlippedVertical(UInt.constructor-impl((int)(gidUInt & FLIPPED_VERTICALLY_FLAG)) != UInt.constructor-impl((int)0));
        int gid = UInt.constructor-impl((int)(gidUInt & UInt.constructor-impl((int)(~UInt.constructor-impl((int)(UInt.constructor-impl((int)(FLIPPED_HORIZONTALLY_FLAG | FLIPPED_VERTICALLY_FLAG)) | FLIPPED_DIAGONALLY_FLAG))))));
        obj.setGid(gid);
        List<TiledObject> list = layer.getObjects();
        Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<com.almasb.fxgl.entity.level.tiled.TiledObject>");
        TypeIntrinsics.asMutableList(list).add(obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void parseObjectProperty(TiledObject obj, StartElement start) {
        Object object;
        Object object2;
        Map map;
        String propName;
        block15: {
            String propType;
            block13: {
                block12: {
                    block14: {
                        propName = TMXLevelLoaderKt.access$getString(start, "name");
                        propType = TMXLevelLoaderKt.access$getString(start, "type");
                        Map<String, String> map2 = obj.getPropertytypes();
                        Intrinsics.checkNotNull(map2, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.String>");
                        TypeIntrinsics.asMutableMap(map2).put(propName, propType);
                        Map<String, Object> map3 = obj.getProperties();
                        Intrinsics.checkNotNull(map3, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
                        map = TypeIntrinsics.asMutableMap(map3);
                        object2 = propType;
                        switch (((String)object2).hashCode()) {
                            case 0: {
                                if (!((String)object2).equals("")) {
                                    throw new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                }
                                break block12;
                            }
                            case 3029738: {
                                if (((String)object2).equals("bool")) break;
                                throw new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                            }
                            case -891985903: {
                                if (!((String)object2).equals("string")) {
                                    throw new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                }
                                break block12;
                            }
                            case 94842723: {
                                if (!((String)object2).equals("color")) {
                                    throw new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                }
                                break block13;
                            }
                            case 97526364: {
                                if (!((String)object2).equals("float")) {
                                    throw new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                }
                                break block14;
                            }
                            case 104431: {
                                if (!((String)object2).equals("int")) throw new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                object = TMXLevelLoaderKt.access$getInt(start, "value");
                                break block15;
                            }
                        }
                        object = TMXLevelLoaderKt.access$getBoolean(start, "value");
                        break block15;
                    }
                    object = Float.valueOf(TMXLevelLoaderKt.access$getFloat(start, "value"));
                    break block15;
                }
                object = TMXLevelLoaderKt.access$getString(start, "value");
                break block15;
            }
            object = TMXLevelLoaderKt.access$getColor(start, "value");
            break block15;
            throw new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
        }
        object2 = object;
        map.put(propName, object2);
    }

    private final void parseTextProperty(TiledObject obj, String data, StartElement start) {
        TextData textData = new TextData(null, false, null, 7, null);
        textData.setText(data);
        textData.setColor(TMXLevelLoaderKt.access$getColor(start, "color"));
        obj.setTextData(textData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void parseMapProperty(TiledMap map, StartElement start) {
        Object object;
        Object object2;
        Map map2;
        String propName;
        block15: {
            String propType;
            block13: {
                block12: {
                    block14: {
                        propName = TMXLevelLoaderKt.access$getString(start, "name");
                        propType = TMXLevelLoaderKt.access$getString(start, "type");
                        Map<String, String> map3 = map.getPropertytypes();
                        Intrinsics.checkNotNull(map3, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.String>");
                        TypeIntrinsics.asMutableMap(map3).put(propName, propType);
                        Map<String, Object> map4 = map.getProperties();
                        Intrinsics.checkNotNull(map4, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
                        map2 = TypeIntrinsics.asMutableMap(map4);
                        object2 = propType;
                        switch (((String)object2).hashCode()) {
                            case 0: {
                                if (!((String)object2).equals("")) {
                                    throw new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                }
                                break block12;
                            }
                            case 3029738: {
                                if (((String)object2).equals("bool")) break;
                                throw new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                            }
                            case -891985903: {
                                if (!((String)object2).equals("string")) {
                                    throw new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                }
                                break block12;
                            }
                            case 94842723: {
                                if (!((String)object2).equals("color")) {
                                    throw new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                }
                                break block13;
                            }
                            case 97526364: {
                                if (!((String)object2).equals("float")) {
                                    throw new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                }
                                break block14;
                            }
                            case 104431: {
                                if (!((String)object2).equals("int")) throw new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                object = TMXLevelLoaderKt.access$getInt(start, "value");
                                break block15;
                            }
                        }
                        object = TMXLevelLoaderKt.access$getBoolean(start, "value");
                        break block15;
                    }
                    object = Float.valueOf(TMXLevelLoaderKt.access$getFloat(start, "value"));
                    break block15;
                }
                object = TMXLevelLoaderKt.access$getString(start, "value");
                break block15;
            }
            object = TMXLevelLoaderKt.access$getColor(start, "value");
            break block15;
            throw new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
        }
        object2 = object;
        map2.put(propName, object2);
    }

    /*
     * WARNING - void declaration
     */
    private final void parseObjectPolyline(TiledObject obj, StartElement start, boolean isClosed) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object list$iv$iv;
        String it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        String data = TMXLevelLoaderKt.access$getString(start, "points");
        Object object = data;
        Regex regex = new Regex(" +");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$flatMap = false;
        void var8_11 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{","};
            list$iv$iv = StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Double.parseDouble(it));
        }
        double[] points = CollectionsKt.toDoubleArray((Collection)((List)destination$iv$iv));
        if (isClosed) {
            Polygon polygon = new Polygon(Arrays.copyOf(points, points.length));
            Map<String, Object> map = obj.getProperties();
            Intrinsics.checkNotNull(map, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
            Map map2 = TypeIntrinsics.asMutableMap(map);
            map2.put("polygon", polygon);
        } else {
            Polyline polyline = new Polyline(Arrays.copyOf(points, points.length));
            Map<String, Object> map = obj.getProperties();
            Intrinsics.checkNotNull(map, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
            Map map3 = TypeIntrinsics.asMutableMap(map);
            map3.put("polyline", polyline);
        }
    }

    @JvmOverloads
    public TMXLevelLoader() {
        this(false, 1, null);
    }

    private static final Entity createTileLayerEntities$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Entity)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isParallel$p(TMXLevelLoader $this) {
        return $this.isParallel;
    }

    public static final /* synthetic */ Logger access$getLog$p(TMXLevelLoader $this) {
        return $this.log;
    }
}

