/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.collection.UnorderedArray;
import com.almasb.fxgl.core.collection.UnorderedPairMap;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.core.pool.Pool;
import com.almasb.fxgl.core.pool.Pools;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.EntityWorldListener;
import com.almasb.fxgl.entity.components.BooleanComponent;
import com.almasb.fxgl.entity.components.BoundingBoxComponent;
import com.almasb.fxgl.entity.components.CollidableComponent;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.physics.ChainShapeData;
import com.almasb.fxgl.physics.CollisionDetectionStrategy;
import com.almasb.fxgl.physics.CollisionGrid;
import com.almasb.fxgl.physics.CollisionHandler;
import com.almasb.fxgl.physics.CollisionPair;
import com.almasb.fxgl.physics.CollisionResult;
import com.almasb.fxgl.physics.EdgeCallback;
import com.almasb.fxgl.physics.HitBox;
import com.almasb.fxgl.physics.PhysicsComponent;
import com.almasb.fxgl.physics.PhysicsUnitConverter;
import com.almasb.fxgl.physics.RaycastResult;
import com.almasb.fxgl.physics.SensorCollisionHandler;
import com.almasb.fxgl.physics.box2d.callbacks.ContactFilter;
import com.almasb.fxgl.physics.box2d.callbacks.ContactImpulse;
import com.almasb.fxgl.physics.box2d.callbacks.ContactListener;
import com.almasb.fxgl.physics.box2d.collision.Manifold;
import com.almasb.fxgl.physics.box2d.collision.shapes.Shape;
import com.almasb.fxgl.physics.box2d.dynamics.Body;
import com.almasb.fxgl.physics.box2d.dynamics.BodyType;
import com.almasb.fxgl.physics.box2d.dynamics.Fixture;
import com.almasb.fxgl.physics.box2d.dynamics.FixtureDef;
import com.almasb.fxgl.physics.box2d.dynamics.World;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.Contact;
import com.almasb.fxgl.physics.box2d.dynamics.joints.Joint;
import com.almasb.fxgl.physics.box2d.dynamics.joints.JointDef;
import com.almasb.fxgl.physics.box2d.dynamics.joints.PrismaticJoint;
import com.almasb.fxgl.physics.box2d.dynamics.joints.PrismaticJointDef;
import com.almasb.fxgl.physics.box2d.dynamics.joints.RevoluteJoint;
import com.almasb.fxgl.physics.box2d.dynamics.joints.RevoluteJointDef;
import com.almasb.fxgl.physics.box2d.dynamics.joints.RopeJoint;
import com.almasb.fxgl.physics.box2d.dynamics.joints.RopeJointDef;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Point2D;

public final class PhysicsWorld
implements EntityWorldListener,
ContactListener,
PhysicsUnitConverter {
    private static final Logger log = Logger.get(PhysicsWorld.class);
    private final double PIXELS_PER_METER;
    private final double METERS_PER_PIXELS;
    private World jboxWorld = new World(new Vec2(0.0f, -10.0f));
    private Array<Entity> entities = new UnorderedArray(128);
    private UnorderedPairMap<Object, CollisionHandler> collisionHandlers = new UnorderedPairMap(16);
    private UnorderedPairMap<Entity, CollisionPair> collisionsMap = new UnorderedPairMap(128);
    private CollisionDetectionStrategy strategy;
    private int appHeight;
    private Array<Entity> delayedBodiesAdd = new UnorderedArray();
    private Array<Body> delayedBodiesRemove = new UnorderedArray();
    private Map<Entity, ChangeListener<Number>> scaleListeners = new HashMap<Entity, ChangeListener<Number>>();
    private Array<Entity> collidables = new UnorderedArray(128);
    private CollisionResult collisionResult = new CollisionResult();
    private CollisionGrid collisionGrid = new CollisionGrid(64, 64);
    private EdgeCallback raycastCallback = new EdgeCallback();

    public PhysicsWorld(int appHeight, double ppm) {
        this(appHeight, ppm, CollisionDetectionStrategy.BRUTE_FORCE);
    }

    public PhysicsWorld(int appHeight, double ppm, CollisionDetectionStrategy strategy) {
        this.appHeight = appHeight;
        this.strategy = strategy;
        this.PIXELS_PER_METER = ppm;
        this.METERS_PER_PIXELS = 1.0 / this.PIXELS_PER_METER;
        this.initCollisionPool();
        this.initContactListener();
        this.initParticles();
        this.jboxWorld.setContactFilter(new CollisionFilterCallback());
        log.debugf("Physics world initialized: appHeight=%d, physics.ppm=%.1f", new Object[]{appHeight, ppm});
        log.debug("Using strategy: " + String.valueOf((Object)strategy));
    }

    private void initCollisionPool() {
        Pools.set(CollisionPair.class, (Pool)new Pool<CollisionPair>(this){

            protected CollisionPair newObject() {
                return new CollisionPair();
            }
        });
    }

    private void initContactListener() {
        this.jboxWorld.setContactListener(this);
    }

    private void initParticles() {
        this.jboxWorld.setParticleGravityScale(1.0f);
        this.jboxWorld.setParticleDensity(1.2f);
        this.jboxWorld.setParticleRadius(this.toMetersF(1.0));
    }

    @Override
    public void onEntityAdded(Entity entity) {
        this.entities.add((Object)entity);
        if (entity.hasComponent(PhysicsComponent.class)) {
            this.onPhysicsEntityAdded(entity);
        }
    }

    private void onPhysicsEntityAdded(Entity entity) {
        if (!this.jboxWorld.isLocked()) {
            this.createBody(entity);
        } else {
            this.delayedBodiesAdd.add((Object)entity);
        }
        ChangeListener scaleChangeListener = (observable, oldValue, newValue) -> {
            Body b = entity.getComponent(PhysicsComponent.class).body;
            if (b != null) {
                List<Fixture> fixtures = List.copyOf(b.getFixtures());
                fixtures.forEach(b::destroyFixture);
                this.createFixtures(entity);
                this.createSensors(entity);
            }
        };
        this.scaleListeners.put(entity, (ChangeListener<Number>)scaleChangeListener);
        entity.getTransformComponent().scaleXProperty().addListener(scaleChangeListener);
        entity.getTransformComponent().scaleYProperty().addListener(scaleChangeListener);
    }

    @Override
    public void onEntityRemoved(Entity entity) {
        this.entities.removeValueByIdentity((Object)entity);
        if (entity.hasComponent(PhysicsComponent.class)) {
            this.onPhysicsEntityRemoved(entity);
        }
    }

    private void onPhysicsEntityRemoved(Entity entity) {
        if (this.scaleListeners.containsKey(entity)) {
            ChangeListener<Number> scaleChangeListener = this.scaleListeners.get(entity);
            entity.getTransformComponent().scaleXProperty().removeListener(scaleChangeListener);
            entity.getTransformComponent().scaleYProperty().removeListener(scaleChangeListener);
            this.scaleListeners.remove(entity);
        }
        if (!this.jboxWorld.isLocked()) {
            this.destroyBody(entity);
        } else {
            this.delayedBodiesRemove.add((Object)entity.getComponent(PhysicsComponent.class).getBody());
        }
    }

    public void onUpdate(double tpf) {
        this.jboxWorld.step((float)tpf, 8, 3);
        this.postStep();
        this.checkCollisions();
        this.notifyCollisions();
    }

    private void postStep() {
        for (Entity e : this.delayedBodiesAdd) {
            this.createBody(e);
        }
        this.delayedBodiesAdd.clear();
        for (Body body : this.delayedBodiesRemove) {
            this.jboxWorld.destroyBody(body);
        }
        this.delayedBodiesRemove.clear();
    }

    public void clear() {
        log.debug("Clearing physics world");
        this.entities.clear();
        this.collisionsMap.clear();
    }

    public void clearCollisionHandlers() {
        this.collisionHandlers.clear();
    }

    @Override
    public void beginContact(Contact contact) {
        Entity e1 = contact.getFixtureA().getBody().getEntity();
        Entity e2 = contact.getFixtureB().getBody().getEntity();
        if (contact.getFixtureA().isSensor()) {
            this.notifySensorCollisionBegin(e1, e2, contact.getFixtureA().getHitBox());
            return;
        }
        if (contact.getFixtureB().isSensor()) {
            this.notifySensorCollisionBegin(e2, e1, contact.getFixtureB().getHitBox());
            return;
        }
        if (!this.areCollidable(e1, e2)) {
            return;
        }
        CollisionHandler handler = this.getHandler(e1, e2);
        if (handler != null) {
            HitBox a = contact.getFixtureA().getHitBox();
            HitBox b = contact.getFixtureB().getHitBox();
            this.collisionBeginFor(handler, e1, e2, a, b);
        }
    }

    @Override
    public void endContact(Contact contact) {
        Entity e1 = contact.getFixtureA().getBody().getEntity();
        Entity e2 = contact.getFixtureB().getBody().getEntity();
        if (contact.getFixtureA().isSensor()) {
            this.notifySensorCollisionEnd(e1, e2, contact.getFixtureA().getHitBox());
            return;
        }
        if (contact.getFixtureB().isSensor()) {
            this.notifySensorCollisionEnd(e2, e1, contact.getFixtureB().getHitBox());
            return;
        }
        if (!this.areCollidable(e1, e2)) {
            return;
        }
        CollisionHandler handler = this.getHandler(e1, e2);
        if (handler != null) {
            this.collisionEndFor(e1, e2);
        }
    }

    public World getJBox2DWorld() {
        return this.jboxWorld;
    }

    private boolean isCollidable(Entity e) {
        if (!e.isActive()) {
            return false;
        }
        return e.getComponentOptional(CollidableComponent.class).map(BooleanComponent::getValue).orElse(false);
    }

    private boolean areCollidable(Entity e1, Entity e2) {
        return this.isCollidable(e1) && this.isCollidable(e2);
    }

    private boolean needManualCheck(Entity e1, Entity e2) {
        BodyType type1 = e1.getComponentOptional(PhysicsComponent.class).map(p -> p.body.getType()).orElse(null);
        if (type1 == null) {
            return true;
        }
        BodyType type2 = e2.getComponentOptional(PhysicsComponent.class).map(p -> p.body.getType()).orElse(null);
        if (type2 == null) {
            return true;
        }
        return type1 == BodyType.KINEMATIC && type2 == BodyType.STATIC || type2 == BodyType.KINEMATIC && type1 == BodyType.STATIC;
    }

    private CollisionHandler getHandler(Entity e1, Entity e2) {
        if (!e1.isActive() || !e2.isActive()) {
            return null;
        }
        return (CollisionHandler)this.collisionHandlers.get((Object)e1.getType(), (Object)e2.getType());
    }

    private void notifySensorCollisionBegin(Entity eWithSensor, Entity eTriggered, HitBox box) {
        SensorCollisionHandler handler = eWithSensor.getComponent(PhysicsComponent.class).getSensorHandlers().get(box);
        handler.onCollisionBegin(eTriggered);
    }

    private void notifySensorCollisionEnd(Entity eWithSensor, Entity eTriggered, HitBox box) {
        SensorCollisionHandler handler = eWithSensor.getComponent(PhysicsComponent.class).getSensorHandlers().get(box);
        handler.onCollisionEnd(eTriggered);
    }

    @Override
    public void preSolve(Contact contact, Manifold oldManifold) {
    }

    @Override
    public void postSolve(Contact contact, ContactImpulse impulse) {
    }

    private void checkCollisions() {
        if (this.strategy == CollisionDetectionStrategy.GRID_INDEXING) {
            for (Entity e : this.entities) {
                if (!this.isCollidable(e)) continue;
                e.getBoundingBoxComponent().applyTransformToHitBoxes$fxgl_entity();
                this.collisionGrid.insert(e);
            }
            this.collisionGrid.getCells().forEach((p, cell) -> this.checkCollisionsInGroup(cell.getEntities()));
            this.collisionGrid.getCells().clear();
        } else {
            for (Entity e : this.entities) {
                if (!this.isCollidable(e)) continue;
                e.getBoundingBoxComponent().applyTransformToHitBoxes$fxgl_entity();
                this.collidables.add((Object)e);
            }
            this.checkCollisionsInGroup(this.collidables);
            this.collidables.clear();
        }
    }

    private void checkCollisionsInGroup(Array<Entity> group) {
        for (int i = 0; i < group.size(); ++i) {
            Entity e1 = (Entity)group.get(i);
            for (int j = i + 1; j < group.size(); ++j) {
                Entity e2 = (Entity)group.get(j);
                CollisionHandler handler = this.getHandler(e1, e2);
                if (handler == null || !this.needManualCheck(e1, e2) || this.isIgnored(e1, e2)) continue;
                boolean collision = e1.getBoundingBoxComponent().checkCollisionPAT(e2.getBoundingBoxComponent(), this.collisionResult);
                if (collision) {
                    this.collisionBeginFor(handler, e1, e2, this.collisionResult.getBoxA(), this.collisionResult.getBoxB());
                    continue;
                }
                this.collisionEndFor(e1, e2);
            }
        }
    }

    private boolean isIgnored(Entity e1, Entity e2) {
        if (!e1.hasComponent(CollidableComponent.class) || !e2.hasComponent(CollidableComponent.class)) {
            return false;
        }
        CollidableComponent c1 = e1.getComponent(CollidableComponent.class);
        for (Serializable t1 : c1.getIgnoredTypes()) {
            if (!e2.isType(t1)) continue;
            return true;
        }
        CollidableComponent c2 = e2.getComponent(CollidableComponent.class);
        for (Serializable t2 : c2.getIgnoredTypes()) {
            if (!e1.isType(t2)) continue;
            return true;
        }
        return false;
    }

    private void collisionBeginFor(CollisionHandler handler, Entity e1, Entity e2, HitBox a, HitBox b) {
        CollisionPair pair = (CollisionPair)this.collisionsMap.get((Object)e1, (Object)e2);
        if (pair == null) {
            pair = (CollisionPair)Pools.obtain(CollisionPair.class);
            pair.init(e1, e2, handler);
            this.collisionsMap.put((Object)((Entity)pair.getA()), (Object)((Entity)pair.getB()), (Object)pair);
            handler.onHitBoxTrigger((Entity)pair.getA(), (Entity)pair.getB(), e1 == pair.getA() ? a : b, e2 == pair.getB() ? b : a);
            pair.collisionBegin();
        }
    }

    private void collisionEndFor(Entity e1, Entity e2) {
        CollisionPair pair = (CollisionPair)this.collisionsMap.get((Object)e1, (Object)e2);
        if (pair != null) {
            this.collisionsMap.remove((Object)((Entity)pair.getA()), (Object)((Entity)pair.getB()));
            pair.collisionEnd();
            Pools.free((Object)pair);
        }
    }

    private void notifyCollisions() {
        Iterator it = this.collisionsMap.getValues().iterator();
        while (it.hasNext()) {
            CollisionPair pair = (CollisionPair)it.next();
            if (!this.isCollidable((Entity)pair.getA()) || !this.isCollidable((Entity)pair.getB())) {
                pair.collisionEnd();
                it.remove();
                Pools.free((Object)pair);
                continue;
            }
            pair.collision();
        }
    }

    public void addCollisionHandler(CollisionHandler handler) {
        this.collisionHandlers.put(handler.getA(), handler.getB(), (Object)handler);
    }

    public void removeCollisionHandler(CollisionHandler handler) {
        this.collisionHandlers.remove(handler.getA(), handler.getB());
    }

    public void setGravity(double x, double y) {
        this.jboxWorld.setGravity(this.toVector(new Point2D(x, y)));
    }

    private void createBody(Entity e) {
        PhysicsComponent physics = e.getComponent(PhysicsComponent.class);
        physics.setWorld(this);
        if (physics.bodyDef.getPosition().x == 0.0f && physics.bodyDef.getPosition().y == 0.0f) {
            physics.bodyDef.getPosition().set(this.toPoint(e.getCenter()));
        }
        if (physics.bodyDef.getAngle() == 0.0f) {
            physics.bodyDef.setAngle((float)(-Math.toRadians(e.getRotation())));
        }
        physics.body = this.jboxWorld.createBody(physics.bodyDef);
        this.createFixtures(e);
        this.createSensors(e);
        physics.body.setEntity(e);
        physics.onInitPhysics();
    }

    private void createFixtures(Entity e) {
        BoundingBoxComponent bbox = e.getBoundingBoxComponent();
        PhysicsComponent physics = e.getComponent(PhysicsComponent.class);
        FixtureDef fd = physics.fixtureDef;
        for (HitBox box : bbox.hitBoxesProperty()) {
            Shape b2Shape = this.createShape(box, e);
            fd.setShape(b2Shape);
            Fixture fixture = physics.body.createFixture(fd);
            fixture.setHitBox(box);
        }
    }

    private void createSensors(Entity e) {
        PhysicsComponent physics = e.getComponent(PhysicsComponent.class);
        if (physics.getSensorHandlers().isEmpty()) {
            return;
        }
        physics.getSensorHandlers().keySet().forEach(box -> {
            box.bindXY(e.getTransformComponent());
            Shape polygonShape = this.createShape((HitBox)box, e);
            FixtureDef fd = new FixtureDef().sensor(true).shape(polygonShape);
            Fixture f = physics.body.createFixture(fd);
            f.setHitBox((HitBox)box);
        });
    }

    private Shape createShape(HitBox box, Entity e) {
        if (e.getComponent(PhysicsComponent.class).body.getType() != BodyType.STATIC && box.getShape() instanceof ChainShapeData) {
            throw new IllegalArgumentException("BoundingShape.chain() can only be used with BodyType.STATIC");
        }
        return box.toBox2DShape(e.getBoundingBoxComponent(), this);
    }

    void destroyFixture(Body body, HitBox box) {
        body.getFixtures().stream().filter(f -> f.getHitBox() == box).findAny().ifPresent(body::destroyFixture);
    }

    private void destroyBody(Entity e) {
        this.jboxWorld.destroyBody(e.getComponent(PhysicsComponent.class).body);
    }

    public RaycastResult raycast(Point2D start, Point2D end) {
        this.raycastCallback.reset();
        this.jboxWorld.raycast(this.raycastCallback, this.toPoint(start), this.toPoint(end));
        Entity entity = null;
        Point2D point = null;
        if (this.raycastCallback.getFixture() != null) {
            entity = this.raycastCallback.getFixture().getBody().getEntity();
        }
        if (this.raycastCallback.getPoint() != null) {
            point = this.toPoint(this.raycastCallback.getPoint());
        }
        if (entity == null && point == null) {
            return RaycastResult.NONE;
        }
        return new RaycastResult(entity, point);
    }

    public RevoluteJoint addRevoluteJoint(Entity e1, Entity e2, Point2D localAnchor1, Point2D localAnchor2) {
        this.checkJointRequirements(e1, e2);
        PhysicsComponent p1 = e1.getComponent(PhysicsComponent.class);
        PhysicsComponent p2 = e2.getComponent(PhysicsComponent.class);
        RevoluteJointDef def = new RevoluteJointDef();
        def.localAnchorA = this.toPoint(e1.getAnchoredPosition().add(localAnchor1)).subLocal(p1.getBody().getWorldCenter());
        def.localAnchorB = this.toPoint(e2.getAnchoredPosition().add(localAnchor2)).subLocal(p2.getBody().getWorldCenter());
        return this.addJoint(e1, e2, def);
    }

    public RopeJoint addRopeJoint(Entity e1, Entity e2) {
        Point2D c1 = e1.getBoundingBoxComponent().getCenterLocal();
        Point2D c2 = e2.getBoundingBoxComponent().getCenterLocal();
        return this.addRopeJoint(e1, e2, c1, c2, e1.getCenter().distance(e2.getCenter()));
    }

    public RopeJoint addRopeJoint(Entity e1, Entity e2, Point2D localAnchor1, Point2D localAnchor2, double length) {
        this.checkJointRequirements(e1, e2);
        PhysicsComponent p1 = e1.getComponent(PhysicsComponent.class);
        PhysicsComponent p2 = e2.getComponent(PhysicsComponent.class);
        RopeJointDef def = new RopeJointDef();
        def.localAnchorA.set(this.toPoint(e1.getAnchoredPosition().add(localAnchor1)).subLocal(p1.getBody().getWorldCenter()));
        def.localAnchorB.set(this.toPoint(e2.getAnchoredPosition().add(localAnchor2)).subLocal(p2.getBody().getWorldCenter()));
        def.maxLength = this.toMetersF(length);
        return this.addJoint(e1, e2, def);
    }

    public PrismaticJoint addPrismaticJoint(Entity e1, Entity e2, Point2D axis, double limit) {
        this.checkJointRequirements(e1, e2);
        PhysicsComponent p1 = e1.getComponent(PhysicsComponent.class);
        PhysicsComponent p2 = e2.getComponent(PhysicsComponent.class);
        PrismaticJointDef def = new PrismaticJointDef();
        def.initialize(p1.getBody(), p2.getBody(), p2.getBody().getWorldCenter(), this.toVector(axis));
        def.enableLimit = true;
        def.upperTranslation = this.toMetersF(limit);
        return this.addJoint(e1, e2, def);
    }

    public <T extends Joint> T addJoint(Entity e1, Entity e2, JointDef<T> def) {
        this.checkJointRequirements(e1, e2);
        PhysicsComponent p1 = e1.getComponent(PhysicsComponent.class);
        PhysicsComponent p2 = e2.getComponent(PhysicsComponent.class);
        def.setBodyA(p1.body);
        def.setBodyB(p2.body);
        return this.jboxWorld.createJoint(def);
    }

    private void checkJointRequirements(Entity e1, Entity e2) {
        if (!e1.hasComponent(PhysicsComponent.class) || !e2.hasComponent(PhysicsComponent.class)) {
            throw new IllegalArgumentException("Cannot create a joint: both entities must have PhysicsComponent");
        }
    }

    public void removeJoint(Joint joint) {
        this.jboxWorld.destroyJoint(joint);
    }

    @Override
    public double toMeters(double pixels) {
        return pixels * this.METERS_PER_PIXELS;
    }

    @Override
    public double toPixels(double meters) {
        return meters * this.PIXELS_PER_METER;
    }

    @Override
    public Vec2 toPoint(Point2D p) {
        return new Vec2(this.toMetersF(p.getX()), this.toMetersF((double)this.appHeight - p.getY()));
    }

    @Override
    public Point2D toPoint(Vec2 p) {
        return new Point2D(this.toPixels(p.x), this.toPixels(this.toMeters(this.appHeight) - (double)p.y));
    }

    private class CollisionFilterCallback
    extends ContactFilter {
        private CollisionFilterCallback() {
        }

        @Override
        public boolean shouldCollide(Fixture fixtureA, Fixture fixtureB) {
            Entity e2;
            Entity e1 = fixtureA.getBody().getEntity();
            if (PhysicsWorld.this.areCollidable(e1, e2 = fixtureB.getBody().getEntity()) && PhysicsWorld.this.isIgnored(e1, e2)) {
                return false;
            }
            return super.shouldCollide(fixtureA, fixtureB);
        }
    }
}

