/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.level.tiled;

import com.almasb.fxgl.entity.level.tiled.Layer;
import com.almasb.fxgl.entity.level.tiled.Tile;
import com.almasb.fxgl.entity.level.tiled.TiledMap;
import com.almasb.fxgl.entity.level.tiled.Tileset;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.texture.ImagesKt;
import com.almasb.fxgl.texture.Texture;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\u0000J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0002J(\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\tJ\u000e\u0010!\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\tJ\u000e\u0010\"\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\tR*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/almasb/fxgl/entity/level/tiled/TilesetLoader;", "", "map", "Lcom/almasb/fxgl/entity/level/tiled/TiledMap;", "mapURL", "Ljava/net/URL;", "(Lcom/almasb/fxgl/entity/level/tiled/TiledMap;Ljava/net/URL;)V", "imageCache", "Ljava/util/HashMap;", "", "Ljavafx/scene/image/Image;", "Lkotlin/collections/HashMap;", "log", "Lcom/almasb/fxgl/logging/Logger;", "copy", "findTileset", "Lcom/almasb/fxgl/entity/level/tiled/Tileset;", "gid", "", "tilesets", "", "loadImage", "tilesetImageName", "transparentcolor", "w", "h", "loadView", "Ljavafx/scene/Node;", "gidArg", "isFlippedHorizontal", "", "isFlippedVertical", "layerName", "loadViewHex", "loadViewIsometric", "fxgl-entity"})
@SourceDebugExtension(value={"SMAP\nTilesetLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TilesetLoader.kt\ncom/almasb/fxgl/entity/level/tiled/TilesetLoader\n+ 2 Logger.kt\ncom/almasb/fxgl/logging/Logger$Companion\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,457:1\n157#2:458\n1#3:459\n1855#4,2:460\n1855#4,2:462\n*S KotlinDebug\n*F\n+ 1 TilesetLoader.kt\ncom/almasb/fxgl/entity/level/tiled/TilesetLoader\n*L\n30#1:458\n274#1:460,2\n307#1:462,2\n*E\n"})
public final class TilesetLoader {
    @NotNull
    private final TiledMap map;
    @NotNull
    private final URL mapURL;
    @NotNull
    private final Logger log;
    @NotNull
    private final HashMap<String, Image> imageCache;

    public TilesetLoader(@NotNull TiledMap map, @NotNull URL mapURL) {
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)mapURL, (String)"mapURL");
        this.map = map;
        this.mapURL = mapURL;
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$get = false;
        this.log = this_$iv.get(TilesetLoader.class);
        this.imageCache = new HashMap();
    }

    @NotNull
    public final Node loadView(int gidArg, boolean isFlippedHorizontal, boolean isFlippedVertical) {
        ImageView imageView;
        int gid = 0;
        gid = gidArg;
        Tileset tileset = this.findTileset(gid, this.map.getTilesets());
        gid -= tileset.getFirstgid();
        int w = tileset.getTilewidth();
        int h = tileset.getTileheight();
        WritableImage buffer = new WritableImage(w, h);
        Image sourceImage = null;
        int srcx = 0;
        int srcy = 0;
        if (tileset.isSpriteSheet()) {
            int tilex = gid % tileset.getColumns();
            int tiley = gid / tileset.getColumns();
            sourceImage = this.loadImage(tileset.getImage(), tileset.getTransparentcolor(), tileset.getImagewidth(), tileset.getImageheight());
            srcx = tilex * w + tileset.getMargin() + tilex * tileset.getSpacing();
            srcy = tiley * h + tileset.getMargin() + tiley * tileset.getSpacing();
        } else {
            Object v0;
            block4: {
                Iterable iterable = tileset.getTiles();
                for (Object t : iterable) {
                    Tile it = (Tile)t;
                    boolean bl = false;
                    if (!(it.getId() == gid)) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            Tile tile = v0;
            if (tile == null) {
                throw new IllegalArgumentException("Tile with id=" + gid + " not found");
            }
            Tile tile2 = tile;
            sourceImage = this.loadImage(tile2.getImage(), tile2.getTransparentcolor(), tile2.getImagewidth(), tile2.getImageheight());
            srcx = 0;
            srcy = 0;
        }
        buffer.getPixelWriter().setPixels(0, 0, w, h, sourceImage.getPixelReader(), srcx, srcy);
        ImageView it = imageView = new ImageView((Image)buffer);
        boolean bl = false;
        it.setScaleX(isFlippedHorizontal ? -1.0 : 1.0);
        it.setScaleY(isFlippedVertical ? -1.0 : 1.0);
        return (Node)imageView;
    }

    @NotNull
    public final Node loadView(@NotNull String layerName) {
        Intrinsics.checkNotNullParameter((Object)layerName, (String)"layerName");
        this.log.debug("Loading view for layer " + layerName);
        Layer layer = this.map.getLayerByName(layerName);
        WritableImage buffer = new WritableImage(layer.getWidth() * this.map.getTilewidth(), layer.getHeight() * this.map.getTileheight());
        this.log.debug("Created buffer with size " + buffer.getWidth() + "x" + buffer.getHeight());
        int n = layer.getData().size();
        for (int i = 0; i < n; ++i) {
            long tempGid = ((Number)layer.getData().get(i)).longValue();
            long FLIPPED_HORIZONTALLY_FLAG = 0x80000000L;
            long FLIPPED_VERTICALLY_FLAG = 0x40000000L;
            long FLIPPED_DIAGONALLY_FLAG = 0x20000000L;
            boolean isFlippedHorizontal = (tempGid & FLIPPED_HORIZONTALLY_FLAG) != 0L;
            boolean isFlippedVertical = (tempGid & FLIPPED_VERTICALLY_FLAG) != 0L;
            boolean isFlippedDiagonal = (tempGid & FLIPPED_DIAGONALLY_FLAG) != 0L;
            int gid = 0;
            gid = (int)(tempGid & ((FLIPPED_HORIZONTALLY_FLAG | FLIPPED_VERTICALLY_FLAG | FLIPPED_DIAGONALLY_FLAG) ^ 0xFFFFFFFFFFFFFFFFL));
            if (gid == 0) continue;
            Tileset tileset = this.findTileset(gid, this.map.getTilesets());
            gid -= tileset.getFirstgid();
            int x = i % layer.getWidth();
            int y = i / layer.getWidth();
            int w = tileset.getTilewidth();
            int h = tileset.getTileheight();
            Image sourceImage = null;
            int srcx = 0;
            int srcy = 0;
            if (tileset.isSpriteSheet()) {
                sourceImage = this.loadImage(tileset.getImage(), tileset.getTransparentcolor(), tileset.getImagewidth(), tileset.getImageheight());
                int tilex = gid % tileset.getColumns();
                int tiley = gid / tileset.getColumns();
                srcx = tilex * w + tileset.getMargin() + tilex * tileset.getSpacing();
                srcy = tiley * h + tileset.getMargin() + tiley * tileset.getSpacing();
                if (isFlippedHorizontal | isFlippedVertical | isFlippedDiagonal) {
                    Image image = new Texture(sourceImage).subTexture(new Rectangle2D((double)srcx, (double)srcy, (double)w, (double)h)).getImage();
                    Intrinsics.checkNotNullExpressionValue((Object)image, (String)"Texture(sourceImage).sub\u2026e(), h.toDouble())).image");
                    sourceImage = image;
                    srcx = 0;
                    srcy = 0;
                }
            } else {
                Tile tile;
                Object v1;
                block9: {
                    Iterable iterable = tileset.getTiles();
                    for (Object t : iterable) {
                        Tile it = (Tile)t;
                        boolean bl = false;
                        if (!(it.getId() == gid)) continue;
                        v1 = t;
                        break block9;
                    }
                    v1 = null;
                }
                if ((Tile)v1 == null) {
                    throw new IllegalArgumentException("Tile with id=" + gid + " not found");
                }
                sourceImage = this.loadImage(tile.getImage(), tile.getTransparentcolor(), tile.getImagewidth(), tile.getImageheight());
                srcx = 0;
                srcy = 0;
            }
            if (isFlippedHorizontal) {
                sourceImage = ImagesKt.flipHorizontally((Image)sourceImage);
            }
            if (isFlippedVertical) {
                sourceImage = ImagesKt.flipVertically((Image)sourceImage);
            }
            if (isFlippedDiagonal) {
                this.log.warning("Diagonally flipped tiles are not currently supported");
            }
            buffer.getPixelWriter().setPixels(x * this.map.getTilewidth(), y * this.map.getTileheight(), w, h, sourceImage.getPixelReader(), srcx, srcy);
        }
        return (Node)new ImageView((Image)buffer);
    }

    @NotNull
    public final Node loadViewHex(@NotNull String layerName) {
        Intrinsics.checkNotNullParameter((Object)layerName, (String)"layerName");
        this.log.debug("Loading view for layer " + layerName);
        Layer layer = this.map.getLayerByName(layerName);
        WritableImage bufferBottom = new WritableImage(layer.getWidth() * this.map.getTilewidth() + this.map.getTilewidth(), layer.getHeight() * this.map.getTileheight() + this.map.getTileheight());
        this.log.debug("Created buffer with size " + bufferBottom.getWidth() + "x" + bufferBottom.getHeight());
        ArrayList delayedDrawings = new ArrayList();
        int oldY = 0;
        int n = layer.getData().size();
        for (int i = 0; i < n; ++i) {
            Object it;
            int gid = 0;
            gid = (int)((Number)layer.getData().get(i)).longValue();
            if (gid == 0) continue;
            Tileset tileset = this.findTileset(gid, this.map.getTilesets());
            gid -= tileset.getFirstgid();
            int x = i % layer.getWidth();
            int y = i / layer.getWidth();
            boolean isColumnEven = x % 2 == 0;
            boolean isRowEven = y % 2 == 0;
            int w = tileset.getTilewidth();
            int h = tileset.getTileheight();
            Image sourceImage = null;
            int srcx = 0;
            int srcy = 0;
            if (tileset.isSpriteSheet()) {
                sourceImage = this.loadImage(tileset.getImage(), tileset.getTransparentcolor(), tileset.getImagewidth(), tileset.getImageheight());
                int tilex = gid % tileset.getColumns();
                int tiley = gid / tileset.getColumns();
                srcx = tilex * w + tileset.getMargin() + tilex * tileset.getSpacing();
                srcy = tiley * h + tileset.getMargin() + tiley * tileset.getSpacing();
            } else {
                Tile tile;
                Object v0;
                block19: {
                    Iterable iterable = tileset.getTiles();
                    for (Object t : iterable) {
                        it = (Tile)t;
                        boolean bl = false;
                        if (!(((Tile)it).getId() == gid)) continue;
                        v0 = t;
                        break block19;
                    }
                    v0 = null;
                }
                if ((Tile)v0 == null) {
                    throw new IllegalArgumentException("Tile with id=" + gid + " not found");
                }
                sourceImage = this.loadImage(tile.getImage(), tile.getTransparentcolor(), tile.getImagewidth(), tile.getImageheight());
                srcx = 0;
                srcy = 0;
            }
            Ref.IntRef offsetX = new Ref.IntRef();
            offsetX.element = Intrinsics.areEqual((Object)this.map.getStaggeraxis(), (Object)"x") && x > 0 ? (int)((double)this.map.getTilewidth() * 0.25) * -x : 0;
            Ref.IntRef offsetY = new Ref.IntRef();
            int n2 = offsetY.element = Intrinsics.areEqual((Object)this.map.getStaggeraxis(), (Object)"y") && y > 0 ? (int)((double)this.map.getTileheight() * 0.25) * -y : 0;
            if (Intrinsics.areEqual((Object)this.map.getStaggeraxis(), (Object)"y")) {
                if (Intrinsics.areEqual((Object)this.map.getStaggerindex(), (Object)"odd")) {
                    if (!isRowEven) {
                        offsetX.element = this.map.getTilewidth() / 2;
                    }
                } else if (isRowEven) {
                    offsetX.element = this.map.getTilewidth() / 2;
                }
            } else if (Intrinsics.areEqual((Object)this.map.getStaggerindex(), (Object)"odd")) {
                if (!isColumnEven) {
                    offsetY.element += this.map.getTileheight() / 2;
                }
            } else if (isColumnEven) {
                offsetY.element += this.map.getTileheight() / 2;
            }
            if (y > oldY) {
                Iterable $this$forEach$iv = delayedDrawings;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Runnable)element$iv;
                    boolean bl = false;
                    it.run();
                }
                delayedDrawings.clear();
                oldY = y;
            }
            Runnable drawToBuffer = () -> TilesetLoader.loadViewHex$lambda$5(h, w, sourceImage, srcx, srcy, bufferBottom, x, this, offsetX, y, offsetY);
            if (Intrinsics.areEqual((Object)this.map.getStaggerindex(), (Object)"odd") && isColumnEven || Intrinsics.areEqual((Object)this.map.getStaggerindex(), (Object)"even") && !isColumnEven) {
                drawToBuffer.run();
                continue;
            }
            ((Collection)delayedDrawings).add(drawToBuffer);
        }
        Iterable $this$forEach$iv = delayedDrawings;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Runnable it = (Runnable)element$iv;
            boolean bl = false;
            it.run();
        }
        delayedDrawings.clear();
        return (Node)new ImageView((Image)bufferBottom);
    }

    @NotNull
    public final Node loadViewIsometric(@NotNull String layerName) {
        Intrinsics.checkNotNullParameter((Object)layerName, (String)"layerName");
        this.log.debug("Loading isometric view for layer " + layerName);
        Layer layer = this.map.getLayerByName(layerName);
        WritableImage buffer = new WritableImage((layer.getWidth() + layer.getHeight()) * (this.map.getTilewidth() / 2 + 1), (layer.getWidth() + layer.getHeight()) * (this.map.getTileheight() / 2 + 1));
        this.log.debug("Created buffer with size " + buffer.getWidth() + "x" + buffer.getHeight());
        int n = layer.getData().size();
        for (int i = 0; i < n; ++i) {
            int gid = 0;
            gid = (int)((Number)layer.getData().get(i)).longValue();
            if (gid == 0) continue;
            Tileset tileset = this.findTileset(gid, this.map.getTilesets());
            gid -= tileset.getFirstgid();
            int x = i % layer.getWidth();
            int y = i / layer.getWidth();
            int w = tileset.getTilewidth();
            int h = tileset.getTileheight();
            Image sourceImage = null;
            int srcx = 0;
            int srcy = 0;
            if (tileset.isSpriteSheet()) {
                sourceImage = this.loadImage(tileset.getImage(), tileset.getTransparentcolor(), tileset.getImagewidth(), tileset.getImageheight());
                int tilex = gid % tileset.getColumns();
                int tiley = gid / tileset.getColumns();
                srcx = tilex * w + tileset.getMargin() + tilex * tileset.getSpacing();
                srcy = tiley * h + tileset.getMargin() + tiley * tileset.getSpacing();
            } else {
                Tile tile;
                Object v0;
                block7: {
                    Iterable iterable = tileset.getTiles();
                    for (Object t : iterable) {
                        Tile it = (Tile)t;
                        boolean bl = false;
                        if (!(it.getId() == gid)) continue;
                        v0 = t;
                        break block7;
                    }
                    v0 = null;
                }
                if ((Tile)v0 == null) {
                    throw new IllegalArgumentException("Tile with id=" + gid + " not found");
                }
                sourceImage = this.loadImage(tile.getImage(), tile.getTransparentcolor(), tile.getImagewidth(), tile.getImageheight());
                srcx = 0;
                srcy = 0;
            }
            int bufferX = (x + this.map.getHeight() - 1 - y) * this.map.getTilewidth() / 2;
            int bufferY = (x + y) * this.map.getTileheight() / 2;
            for (int dy = 0; dy < h; ++dy) {
                for (int dx = 0; dx < w; ++dx) {
                    Color c = sourceImage.getPixelReader().getColor(srcx + dx, srcy + dy);
                    if (Intrinsics.areEqual((Object)c, (Object)Color.TRANSPARENT)) continue;
                    buffer.getPixelWriter().setColor(bufferX + dx, bufferY + dy, c);
                }
            }
        }
        return (Node)new ImageView((Image)buffer);
    }

    private final Tileset findTileset(int gid, List<Tileset> tilesets) {
        for (Tileset tileset : tilesets) {
            if (gid < tileset.getFirstgid() || gid >= tileset.getFirstgid() + tileset.getTilecount()) continue;
            return tileset;
        }
        throw new IllegalArgumentException("Tileset for gid=" + gid + " not found");
    }

    private final Image loadImage(String tilesetImageName, String transparentcolor, int w, int h) {
        Image image;
        if (((Map)this.imageCache).containsKey(tilesetImageName)) {
            Image image2 = this.imageCache.get(tilesetImageName);
            Intrinsics.checkNotNull((Object)image2);
            return image2;
        }
        try {
            Image image3;
            String string = this.mapURL.toExternalForm();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mapURL.toExternalForm()");
            String ext = StringsKt.substringBeforeLast$default((String)string, (String)"/", null, (int)2, null) + "/";
            InputStream stream = URI.create(ext + tilesetImageName).toURL().openStream();
            if (((CharSequence)transparentcolor).length() == 0) {
                image3 = new Image(stream);
            } else {
                Texture texture = new Texture(new Image(stream));
                Color color = Color.web((String)transparentcolor);
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"web(transparentcolor)");
                image3 = texture.transparentColor(color).getImage();
            }
            Image img = image3;
            stream.close();
            if (img.isError()) {
                this.log.warning(ext + tilesetImageName + " cannot be loaded");
                img = ImagesKt.resize((Image)ImagesKt.getDummyImage(), (int)w, (int)h);
            }
            image = img;
        }
        catch (Exception e) {
            this.log.warning(tilesetImageName + " cannot be loaded using mapURL=" + this.mapURL, (Throwable)e);
            image = ImagesKt.resize((Image)ImagesKt.getDummyImage(), (int)w, (int)h);
        }
        Image image4 = image;
        Map map = this.imageCache;
        Intrinsics.checkNotNullExpressionValue((Object)image4, (String)"image");
        map.put(tilesetImageName, image4);
        return image4;
    }

    @NotNull
    public final TilesetLoader copy() {
        return new TilesetLoader(this.map, this.mapURL);
    }

    private static final void loadViewHex$lambda$5(int $h, int $w, Image $sourceImage, int $srcx, int $srcy, WritableImage $bufferBottom, int $x, TilesetLoader this$0, Ref.IntRef $offsetX, int $y, Ref.IntRef $offsetY) {
        Intrinsics.checkNotNullParameter((Object)$sourceImage, (String)"$sourceImage");
        Intrinsics.checkNotNullParameter((Object)$bufferBottom, (String)"$bufferBottom");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$offsetX, (String)"$offsetX");
        Intrinsics.checkNotNullParameter((Object)$offsetY, (String)"$offsetY");
        for (int dy = 0; dy < $h; ++dy) {
            for (int dx = 0; dx < $w; ++dx) {
                Color c = $sourceImage.getPixelReader().getColor($srcx + dx, $srcy + dy);
                if (Intrinsics.areEqual((Object)c, (Object)Color.TRANSPARENT)) continue;
                $bufferBottom.getPixelWriter().setColor($x * this$0.map.getTilewidth() + $offsetX.element + dx, $y * this$0.map.getTileheight() + $offsetY.element + dy, c);
            }
        }
    }
}

