/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.pathfinding.astar;

import com.almasb.fxgl.core.collection.grid.CellGenerator;
import com.almasb.fxgl.core.collection.grid.Grid;
import com.almasb.fxgl.pathfinding.astar.AStarCell;
import java.util.List;
import java.util.stream.Collectors;

public abstract class TraversableGrid<T extends AStarCell>
extends Grid<T> {
    public TraversableGrid(Class<T> type, int width, int height) {
        super(type, width, height);
    }

    public TraversableGrid(Class<T> type, int width, int height, CellGenerator<T> populateFunction) {
        super(type, width, height, populateFunction);
    }

    public TraversableGrid(Class<T> type, int width, int height, int cellWidth, int cellHeight, CellGenerator<T> populateFunction) {
        super(type, width, height, cellWidth, cellHeight, populateFunction);
    }

    public List<T> getWalkableCells() {
        return this.getCells().stream().filter(c -> c.getState().isWalkable()).collect(Collectors.toList());
    }

    public boolean isTraversableInSingleMove(T source, T target) {
        return ((AStarCell)((Object)target)).isWalkable();
    }
}

