/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.pathfinding.heuristic;

import com.almasb.fxgl.core.collection.grid.Cell;
import com.almasb.fxgl.pathfinding.heuristic.DiagonalHeuristic;

public final class OctileDistance<T extends Cell>
extends DiagonalHeuristic<T> {
    private final int diagonalFactor;

    public OctileDistance() {
        this(10);
    }

    public OctileDistance(int weight) {
        super(weight, (int)(Math.sqrt(2.0) * (double)weight));
        this.diagonalFactor = this.getDiagonalWeight() - weight;
    }

    @Override
    public int getCost(int startX, int startY, int targetX, int targetY) {
        int dx = Math.abs(startX - targetX);
        int dy = Math.abs(startY - targetY);
        return this.getWeight() * Math.max(dx, dy) + this.diagonalFactor * Math.min(dx, dy);
    }
}

