/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.pathfinding.maze;

import com.almasb.fxgl.pathfinding.astar.TraversableGrid;
import com.almasb.fxgl.pathfinding.maze.MazeCell;
import java.util.Arrays;
import java.util.Collections;

public class MazeGrid
extends TraversableGrid<MazeCell> {
    public MazeGrid(int width, int height) {
        super(MazeCell.class, width, height);
        int[][] maze = new int[width][height];
        this.generateMaze(maze, 0, 0);
        this.populate((x, y) -> {
            MazeCell cell = new MazeCell((int)x, (int)y);
            if ((maze[x][y] & 1) == 0) {
                cell.setTopWall(true);
            }
            if ((maze[x][y] & 8) == 0) {
                cell.setLeftWall(true);
            }
            return cell;
        });
    }

    @Override
    public boolean isTraversableInSingleMove(MazeCell source, MazeCell target) {
        boolean isTraversable = super.isTraversableInSingleMove(source, target);
        if (!isTraversable) {
            return false;
        }
        if (source.getX() == target.getX()) {
            if (source.getY() < target.getY()) {
                return !target.hasTopWall();
            }
            if (source.getY() > target.getY()) {
                return !source.hasTopWall();
            }
        }
        if (source.getY() == target.getY()) {
            if (source.getX() < target.getX()) {
                return !target.hasLeftWall();
            }
            if (source.getX() > target.getX()) {
                return !source.hasLeftWall();
            }
        }
        return true;
    }

    private void generateMaze(int[][] maze, int cx, int cy) {
        DIR[] dirs = DIR.values();
        Collections.shuffle(Arrays.asList(dirs));
        for (DIR dir : dirs) {
            int nx = cx + dir.dx;
            int ny = cy + dir.dy;
            if (!MazeGrid.between(nx, this.getWidth()) || !MazeGrid.between(ny, this.getHeight()) || maze[nx][ny] != 0) continue;
            int[] nArray = maze[cx];
            int n = cy;
            nArray[n] = nArray[n] | dir.bit;
            int[] nArray2 = maze[nx];
            int n2 = ny;
            nArray2[n2] = nArray2[n2] | dir.opposite.bit;
            this.generateMaze(maze, nx, ny);
        }
    }

    private static boolean between(int v, int upper) {
        return v >= 0 && v < upper;
    }

    private static enum DIR {
        N(1, 0, -1),
        S(2, 0, 1),
        E(4, 1, 0),
        W(8, -1, 0);

        private final int bit;
        private final int dx;
        private final int dy;
        private DIR opposite;

        private DIR(int bit, int dx, int dy) {
            this.bit = bit;
            this.dx = dx;
            this.dy = dy;
        }

        static {
            DIR.N.opposite = S;
            DIR.S.opposite = N;
            DIR.E.opposite = W;
            DIR.W.opposite = E;
        }
    }
}

