/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.entity.components.BoundingBoxComponent;
import com.almasb.fxgl.entity.components.TransformComponent;
import com.almasb.fxgl.physics.BoundingShape;
import com.almasb.fxgl.physics.HitBox;
import com.almasb.fxgl.physics.PhysicsUnitConverter;
import com.almasb.fxgl.physics.box2d.collision.shapes.PolygonShape;
import com.almasb.fxgl.physics.box2d.collision.shapes.Shape;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/almasb/fxgl/physics/PolygonShapeData;", "Lcom/almasb/fxgl/physics/BoundingShape;", "size", "Ljavafx/geometry/Dimension2D;", "points", "", "Ljavafx/geometry/Point2D;", "(Ljavafx/geometry/Dimension2D;[Ljavafx/geometry/Point2D;)V", "getPoints", "()[Ljavafx/geometry/Point2D;", "[Ljavafx/geometry/Point2D;", "toBox2DShape", "Lcom/almasb/fxgl/physics/box2d/collision/shapes/Shape;", "box", "Lcom/almasb/fxgl/physics/HitBox;", "bboxComp", "Lcom/almasb/fxgl/entity/components/BoundingBoxComponent;", "conv", "Lcom/almasb/fxgl/physics/PhysicsUnitConverter;", "fxgl-entity"})
public final class PolygonShapeData
extends BoundingShape {
    @NotNull
    private final Point2D[] points;

    public PolygonShapeData(@NotNull Dimension2D size, @NotNull Point2D[] points) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        super(size, null);
        this.points = points;
    }

    @NotNull
    public final Point2D[] getPoints() {
        return this.points;
    }

    @Override
    @NotNull
    public Shape toBox2DShape(@NotNull HitBox box, @NotNull BoundingBoxComponent bboxComp, @NotNull PhysicsUnitConverter conv) {
        Intrinsics.checkNotNullParameter((Object)box, (String)"box");
        Intrinsics.checkNotNullParameter((Object)bboxComp, (String)"bboxComp");
        Intrinsics.checkNotNullParameter((Object)conv, (String)"conv");
        Point2D boundsCenterLocal = box.getCenterWorld().subtract(bboxComp.getCenterWorld());
        Point2D bboxCenterLocal = bboxComp.getCenterLocal();
        TransformComponent t = bboxComp.getTransform();
        Vec2[] vertices = new Vec2[this.points.length];
        Point2D bboxCenterLocalNew = new Point2D(bboxCenterLocal.getX() * t.getScaleX() + (1.0 - t.getScaleX()) * t.getScaleOrigin().getX(), bboxCenterLocal.getY() * t.getScaleY() + (1.0 - t.getScaleY()) * t.getScaleOrigin().getY());
        Point2D boundsCenterLocalNew = new Point2D(boundsCenterLocal.getX() * t.getScaleX() + (1.0 - t.getScaleX()) * t.getScaleOrigin().getX(), boundsCenterLocal.getY() * t.getScaleY() + (1.0 - t.getScaleY()) * t.getScaleOrigin().getY());
        int n = vertices.length;
        for (int i = 0; i < n; ++i) {
            Point2D p = new Point2D((this.points[i].getX() + box.getMinX()) * t.getScaleX() + (1.0 - t.getScaleX()) * t.getScaleOrigin().getX(), (this.points[i].getY() + box.getMinY()) * t.getScaleY() + (1.0 - t.getScaleY()) * t.getScaleOrigin().getY());
            vertices[i] = conv.toVector(p.subtract(boundsCenterLocalNew)).subLocal(conv.toVector(bboxCenterLocalNew)).addLocal(conv.toVector(boundsCenterLocalNew)).subLocal(conv.toMeters(bboxComp.getMinXLocal()), -conv.toMeters(bboxComp.getMinYLocal()));
        }
        PolygonShape shape = new PolygonShape();
        shape.set(vertices);
        return shape;
    }
}

