/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.collision;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.physics.box2d.collision.Distance;
import com.almasb.fxgl.physics.box2d.collision.DistanceProxy;
import com.almasb.fxgl.physics.box2d.common.Rotation;
import com.almasb.fxgl.physics.box2d.common.Sweep;
import com.almasb.fxgl.physics.box2d.common.Transform;

class SeparationFunction {
    private DistanceProxy m_proxyA;
    private DistanceProxy m_proxyB;
    private Type m_type;
    private final Vec2 m_localPoint = new Vec2();
    private final Vec2 m_axis = new Vec2();
    private Sweep m_sweepA;
    private Sweep m_sweepB;
    private final Vec2 localPointA = new Vec2();
    private final Vec2 localPointB = new Vec2();
    private final Vec2 pointA = new Vec2();
    private final Vec2 pointB = new Vec2();
    private final Vec2 localPointA1 = new Vec2();
    private final Vec2 localPointA2 = new Vec2();
    private final Vec2 normal = new Vec2();
    private final Vec2 localPointB1 = new Vec2();
    private final Vec2 localPointB2 = new Vec2();
    private final Vec2 temp = new Vec2();
    private final Transform xfa = new Transform();
    private final Transform xfb = new Transform();
    private final Vec2 axisA = new Vec2();
    private final Vec2 axisB = new Vec2();

    SeparationFunction() {
    }

    void initialize(Distance.SimplexCache cache, DistanceProxy proxyA, Sweep sweepA, DistanceProxy proxyB, Sweep sweepB, float t1) {
        this.m_proxyA = proxyA;
        this.m_proxyB = proxyB;
        int count = cache.count;
        assert (0 < count && count < 3);
        this.m_sweepA = sweepA;
        this.m_sweepB = sweepB;
        this.m_sweepA.getTransform(this.xfa, t1);
        this.m_sweepB.getTransform(this.xfb, t1);
        if (count == 1) {
            this.m_type = Type.POINTS;
            this.localPointA.set(this.m_proxyA.getVertex(cache.indexA[0]));
            this.localPointB.set(this.m_proxyB.getVertex(cache.indexB[0]));
            Transform.mulToOutUnsafe(this.xfa, this.localPointA, this.pointA);
            Transform.mulToOutUnsafe(this.xfb, this.localPointB, this.pointB);
            this.m_axis.set(this.pointB).subLocal(this.pointA);
            this.m_axis.getLengthAndNormalize();
        } else if (cache.indexA[0] == cache.indexA[1]) {
            this.m_type = Type.FACE_B;
            this.localPointB1.set(this.m_proxyB.getVertex(cache.indexB[0]));
            this.localPointB2.set(this.m_proxyB.getVertex(cache.indexB[1]));
            this.temp.set(this.localPointB2).subLocal(this.localPointB1);
            Vec2.crossToOutUnsafe((Vec2)this.temp, (float)1.0f, (Vec2)this.m_axis);
            this.m_axis.getLengthAndNormalize();
            Rotation.mulToOutUnsafe(this.xfb.q, this.m_axis, this.normal);
            this.m_localPoint.set(this.localPointB1).addLocal(this.localPointB2).mulLocal(0.5);
            Transform.mulToOutUnsafe(this.xfb, this.m_localPoint, this.pointB);
            this.localPointA.set(proxyA.getVertex(cache.indexA[0]));
            Transform.mulToOutUnsafe(this.xfa, this.localPointA, this.pointA);
            this.temp.set(this.pointA).subLocal(this.pointB);
            float s = Vec2.dot((Vec2)this.temp, (Vec2)this.normal);
            if (s < 0.0f) {
                this.m_axis.negateLocal();
            }
        } else {
            this.m_type = Type.FACE_A;
            this.localPointA1.set(this.m_proxyA.getVertex(cache.indexA[0]));
            this.localPointA2.set(this.m_proxyA.getVertex(cache.indexA[1]));
            this.temp.set(this.localPointA2).subLocal(this.localPointA1);
            Vec2.crossToOutUnsafe((Vec2)this.temp, (float)1.0f, (Vec2)this.m_axis);
            this.m_axis.getLengthAndNormalize();
            Rotation.mulToOutUnsafe(this.xfa.q, this.m_axis, this.normal);
            this.m_localPoint.set(this.localPointA1).addLocal(this.localPointA2).mulLocal(0.5);
            Transform.mulToOutUnsafe(this.xfa, this.m_localPoint, this.pointA);
            this.localPointB.set(this.m_proxyB.getVertex(cache.indexB[0]));
            Transform.mulToOutUnsafe(this.xfb, this.localPointB, this.pointB);
            this.temp.set(this.pointB).subLocal(this.pointA);
            float s = Vec2.dot((Vec2)this.temp, (Vec2)this.normal);
            if (s < 0.0f) {
                this.m_axis.negateLocal();
            }
        }
    }

    float findMinSeparation(int[] indexes, float t) {
        this.m_sweepA.getTransform(this.xfa, t);
        this.m_sweepB.getTransform(this.xfb, t);
        switch (this.m_type.ordinal()) {
            case 0: {
                Rotation.mulTransUnsafe(this.xfa.q, this.m_axis, this.axisA);
                Rotation.mulTransUnsafe(this.xfb.q, this.m_axis.negateLocal(), this.axisB);
                this.m_axis.negateLocal();
                indexes[0] = this.m_proxyA.getSupport(this.axisA);
                indexes[1] = this.m_proxyB.getSupport(this.axisB);
                this.localPointA.set(this.m_proxyA.getVertex(indexes[0]));
                this.localPointB.set(this.m_proxyB.getVertex(indexes[1]));
                Transform.mulToOutUnsafe(this.xfa, this.localPointA, this.pointA);
                Transform.mulToOutUnsafe(this.xfb, this.localPointB, this.pointB);
                return Vec2.dot((Vec2)this.pointB.subLocal(this.pointA), (Vec2)this.m_axis);
            }
            case 1: {
                Rotation.mulToOutUnsafe(this.xfa.q, this.m_axis, this.normal);
                Transform.mulToOutUnsafe(this.xfa, this.m_localPoint, this.pointA);
                Rotation.mulTransUnsafe(this.xfb.q, this.normal.negateLocal(), this.axisB);
                this.normal.negateLocal();
                indexes[0] = -1;
                indexes[1] = this.m_proxyB.getSupport(this.axisB);
                this.localPointB.set(this.m_proxyB.getVertex(indexes[1]));
                Transform.mulToOutUnsafe(this.xfb, this.localPointB, this.pointB);
                return Vec2.dot((Vec2)this.pointB.subLocal(this.pointA), (Vec2)this.normal);
            }
            case 2: {
                Rotation.mulToOutUnsafe(this.xfb.q, this.m_axis, this.normal);
                Transform.mulToOutUnsafe(this.xfb, this.m_localPoint, this.pointB);
                Rotation.mulTransUnsafe(this.xfa.q, this.normal.negateLocal(), this.axisA);
                this.normal.negateLocal();
                indexes[1] = -1;
                indexes[0] = this.m_proxyA.getSupport(this.axisA);
                this.localPointA.set(this.m_proxyA.getVertex(indexes[0]));
                Transform.mulToOutUnsafe(this.xfa, this.localPointA, this.pointA);
                return Vec2.dot((Vec2)this.pointA.subLocal(this.pointB), (Vec2)this.normal);
            }
        }
        assert (false);
        indexes[0] = -1;
        indexes[1] = -1;
        return 0.0f;
    }

    float evaluate(int indexA, int indexB, float t) {
        this.m_sweepA.getTransform(this.xfa, t);
        this.m_sweepB.getTransform(this.xfb, t);
        switch (this.m_type.ordinal()) {
            case 0: {
                Rotation.mulTransUnsafe(this.xfa.q, this.m_axis, this.axisA);
                Rotation.mulTransUnsafe(this.xfb.q, this.m_axis.negateLocal(), this.axisB);
                this.m_axis.negateLocal();
                this.localPointA.set(this.m_proxyA.getVertex(indexA));
                this.localPointB.set(this.m_proxyB.getVertex(indexB));
                Transform.mulToOutUnsafe(this.xfa, this.localPointA, this.pointA);
                Transform.mulToOutUnsafe(this.xfb, this.localPointB, this.pointB);
                return Vec2.dot((Vec2)this.pointB.subLocal(this.pointA), (Vec2)this.m_axis);
            }
            case 1: {
                Rotation.mulToOutUnsafe(this.xfa.q, this.m_axis, this.normal);
                Transform.mulToOutUnsafe(this.xfa, this.m_localPoint, this.pointA);
                Rotation.mulTransUnsafe(this.xfb.q, this.normal.negateLocal(), this.axisB);
                this.normal.negateLocal();
                this.localPointB.set(this.m_proxyB.getVertex(indexB));
                Transform.mulToOutUnsafe(this.xfb, this.localPointB, this.pointB);
                return Vec2.dot((Vec2)this.pointB.subLocal(this.pointA), (Vec2)this.normal);
            }
            case 2: {
                Rotation.mulToOutUnsafe(this.xfb.q, this.m_axis, this.normal);
                Transform.mulToOutUnsafe(this.xfb, this.m_localPoint, this.pointB);
                Rotation.mulTransUnsafe(this.xfa.q, this.normal.negateLocal(), this.axisA);
                this.normal.negateLocal();
                this.localPointA.set(this.m_proxyA.getVertex(indexA));
                Transform.mulToOutUnsafe(this.xfa, this.localPointA, this.pointA);
                return Vec2.dot((Vec2)this.pointA.subLocal(this.pointB), (Vec2)this.normal);
            }
        }
        assert (false);
        return 0.0f;
    }

    private static enum Type {
        POINTS,
        FACE_A,
        FACE_B;

    }
}

