/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.inventory;

import com.almasb.fxgl.inventory.EmptyView;
import com.almasb.fxgl.inventory.ItemData;
import com.almasb.fxgl.logging.Logger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J=\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00028\u00002\b\b\u0002\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020#2\b\b\u0002\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010(J\u001f\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\b2\u0006\u0010!\u001a\u00028\u0000\u00a2\u0006\u0002\u0010*J\u0013\u0010+\u001a\u00020\u00042\u0006\u0010!\u001a\u00028\u0000\u00a2\u0006\u0002\u0010,J\u0006\u0010-\u001a\u00020\u0004J\u001b\u0010.\u001a\u00020\u00102\u0006\u0010!\u001a\u00028\u00002\u0006\u0010/\u001a\u00020\u0004\u00a2\u0006\u0002\u00100J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\bJ\u0013\u00101\u001a\u0002022\u0006\u0010!\u001a\u00028\u0000\u00a2\u0006\u0002\u00103J\u0016\u00104\u001a\u0002022\f\u00105\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0002J\u000e\u00106\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u0004R)\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0005R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0011\"\u0004\b\u0013\u0010\u0014R2\u0010\u0015\u001a&\u0012\f\u0012\n \u0016*\u0004\u0018\u00018\u00008\u0000 \u0016*\u0012\u0012\f\u0012\n \u0016*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0017\u001a6\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\b0\u0018j\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\b`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u001a\u001a&\u0012\f\u0012\n \u0016*\u0004\u0018\u00018\u00008\u0000 \u0016*\u0012\u0012\f\u0012\n \u0016*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\rR\u000e\u0010\u001f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/almasb/fxgl/inventory/Inventory;", "T", "", "capacity", "", "(I)V", "allData", "", "Ljavafx/collections/ObservableList;", "Lcom/almasb/fxgl/inventory/ItemData;", "getAllData", "()Ljava/util/Map;", "getCapacity", "()I", "setCapacity", "isFull", "", "()Z", "isRemoveItemsIfQty0", "setRemoveItemsIfQty0", "(Z)V", "items", "kotlin.jvm.PlatformType", "itemsData", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "itemsProperty", "log", "Lcom/almasb/fxgl/logging/Logger;", "size", "getSize", "stackMax", "add", "item", "name", "", "description", "view", "Ljavafx/scene/Node;", "quantity", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljavafx/scene/Node;I)Z", "getData", "(Ljava/lang/Object;)Ljavafx/collections/ObservableList;", "getItemQuantity", "(Ljava/lang/Object;)I", "getStackMax", "incrementQuantity", "amount", "(Ljava/lang/Object;I)Z", "remove", "", "(Ljava/lang/Object;)V", "removeStack", "itemData", "setStackMax", "newStackMax", "fxgl-gameplay"})
public final class Inventory<T> {
    private int capacity;
    @NotNull
    private final Logger log;
    private final ObservableList<T> items;
    private final ObservableList<T> itemsProperty;
    @NotNull
    private final HashMap<T, ObservableList<ItemData<T>>> itemsData;
    private int stackMax;
    private boolean isRemoveItemsIfQty0;

    public Inventory(int capacity) {
        this.capacity = capacity;
        this.log = Logger.Companion.get(this.getClass());
        this.items = FXCollections.observableArrayList();
        this.itemsProperty = FXCollections.unmodifiableObservableList(this.items);
        boolean bl = false;
        this.itemsData = new HashMap();
        this.stackMax = Integer.MAX_VALUE;
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final void setCapacity(int n) {
        this.capacity = n;
    }

    public final int getSize() {
        int totalSize = 0;
        for (Object item : this.items) {
            ObservableList<ItemData<T>> observableList = this.itemsData.get(item);
            Integer n = observableList == null ? null : Integer.valueOf(observableList.size());
            Intrinsics.checkNotNull((Object)n);
            totalSize += n.intValue();
        }
        return totalSize;
    }

    @NotNull
    public final Map<T, ObservableList<ItemData<T>>> getAllData() {
        return MapsKt.toMap((Map)this.itemsData);
    }

    public final boolean isFull() {
        return this.getSize() == this.capacity;
    }

    public final boolean isRemoveItemsIfQty0() {
        return this.isRemoveItemsIfQty0;
    }

    public final void setRemoveItemsIfQty0(boolean bl) {
        this.isRemoveItemsIfQty0 = bl;
    }

    public final int getStackMax() {
        return this.stackMax;
    }

    public final boolean setStackMax(int newStackMax) {
        if (newStackMax >= this.stackMax) {
            this.stackMax = newStackMax;
            return true;
        }
        for (ObservableList<ItemData<T>> item : this.getAllData().values()) {
            for (ItemData stack : item) {
                if (stack.getQuantity() <= newStackMax) continue;
                return false;
            }
        }
        this.stackMax = newStackMax;
        return true;
    }

    @NotNull
    public final ObservableList<T> itemsProperty() {
        ObservableList<T> observableList = this.itemsProperty;
        Intrinsics.checkNotNullExpressionValue(observableList, (String)"itemsProperty");
        return observableList;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final boolean add(T item, @NotNull String name, @NotNull String description, @NotNull Node view, int quantity) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (this.items.contains(item)) {
            return this.incrementQuantity(item, quantity);
        }
        if (this.isFull()) {
            return false;
        }
        Object object = (ObservableList<ItemData<T>>)this.itemsData;
        Object object2 = FXCollections.observableArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"observableArrayList()");
        boolean bl = false;
        object.put(item, object2);
        object = this.itemsData.get(item);
        if (object != null) {
            void it;
            object2 = new ItemData<T>(item);
            bl = false;
            boolean bl2 = false;
            Object object3 = object2;
            ObservableList<ItemData<T>> observableList = object;
            boolean bl3 = false;
            it.setName(name);
            it.setDescription(description);
            it.setView(view);
            Unit unit = Unit.INSTANCE;
            observableList.add(object2);
        }
        object = this;
        object2 = ((Inventory)object).items;
        Intrinsics.checkNotNullExpressionValue(object2, (String)"items");
        object2 = (Collection)object2;
        bl = false;
        object2.add(item);
        if (quantity <= this.stackMax) {
            object2 = this.itemsData.get(item);
            Object object4 = object = object2 == null ? null : (ItemData)object2.get(0);
            if (object != null) {
                ((ItemData)object).setQuantity(quantity);
            }
            return true;
        }
        object2 = this.itemsData.get(item);
        Object object5 = object = object2 == null ? null : (ItemData)object2.get(0);
        if (object != null) {
            ((ItemData)object).setQuantity(this.stackMax);
        }
        if (this.incrementQuantity(item, quantity - this.stackMax)) {
            return true;
        }
        this.remove(item);
        return false;
    }

    public static /* synthetic */ boolean add$default(Inventory inventory, Object object, String string, String string2, Node node, int n, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            string = "";
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        if ((n2 & 8) != 0) {
            node = (Node)EmptyView.INSTANCE;
        }
        if ((n2 & 0x10) != 0) {
            n = 1;
        }
        return inventory.add(object, string, string2, node, n);
    }

    public final void remove(T item) {
        Inventory inventory = this;
        Object object = inventory.items;
        Intrinsics.checkNotNullExpressionValue(object, (String)"items");
        object = (Collection)object;
        boolean bl = false;
        object.remove(item);
        inventory = this;
        object = inventory.itemsData;
        bl = false;
        object.remove(item);
    }

    private final void removeStack(ItemData<T> itemData) {
        ObservableList<ItemData<T>> observableList;
        if (this.items.contains(itemData.getUserItem()) && (observableList = this.itemsData.get(itemData.getUserItem())) != null) {
            observableList.remove(itemData);
        }
    }

    @NotNull
    public final ObservableList<ItemData<T>> getData(T item) {
        if (!this.items.contains(item)) {
            ObservableList observableList = FXCollections.observableArrayList();
            Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"observableArrayList()");
            return observableList;
        }
        ObservableList<ItemData<T>> observableList = this.itemsData.get(item);
        Intrinsics.checkNotNull(observableList);
        ObservableList<ItemData<T>> observableList2 = observableList;
        return observableList2;
    }

    public final int getItemQuantity(T item) {
        if (!this.items.contains(item)) {
            return 0;
        }
        int totalItemSize = 0;
        for (ItemData stack : this.getData(item)) {
            totalItemSize += stack.getQuantity();
        }
        return totalItemSize;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean incrementQuantity(T item, int amount) {
        if (!this.items.contains(item)) {
            this.log.warning("Attempted to increment qty of item that is not in inventory. Ignoring");
            return false;
        }
        ObservableList<ItemData<T>> stacks = this.getData(item);
        ItemData itemTemplate = (ItemData)stacks.get(0);
        int freeSpace = this.capacity - this.getSize();
        int itemQuantity = this.getItemQuantity(item);
        int quantityCount = amount;
        for (ItemData stack : stacks) {
            quantityCount -= this.stackMax - stack.getQuantity();
        }
        if ((double)freeSpace < (double)quantityCount / (double)this.stackMax) {
            return false;
        }
        if (amount < 0 && itemQuantity + amount < 0) {
            return false;
        }
        quantityCount = amount;
        if (amount < 0) {
            for (ItemData stack : CollectionsKt.reversed((Iterable)((Iterable)stacks))) {
                if (quantityCount < 0) {
                    if (quantityCount >= -stack.getQuantity()) {
                        ItemData itemData = stack;
                        itemData.setQuantity(itemData.getQuantity() + quantityCount);
                        quantityCount = 0;
                    } else {
                        quantityCount += stack.getQuantity();
                        stack.setQuantity(0);
                    }
                    if (!this.isRemoveItemsIfQty0 || stack.getQuantity() != 0) continue;
                    Intrinsics.checkNotNullExpressionValue(stack, (String)"stack");
                    this.removeStack(stack);
                    if (this.getItemQuantity(item) != 0) continue;
                    this.remove(item);
                    continue;
                }
                break;
            }
        } else {
            ItemData itemData;
            for (ItemData stack : stacks) {
                if (quantityCount <= this.stackMax - stack.getQuantity()) {
                    itemData = stack;
                    itemData.setQuantity(itemData.getQuantity() + quantityCount);
                    quantityCount = 0;
                    break;
                }
                if (stack.getQuantity() >= this.stackMax) continue;
                quantityCount -= this.stackMax - stack.getQuantity();
                stack.setQuantity(this.stackMax);
            }
            while (quantityCount > 0) {
                void it;
                int newItemQty = 0;
                if (quantityCount < this.stackMax) {
                    newItemQty = quantityCount;
                    quantityCount = 0;
                } else {
                    newItemQty = this.stackMax;
                    quantityCount -= this.stackMax;
                }
                ObservableList<ItemData<T>> observableList = this.itemsData.get(item);
                if (observableList == null) continue;
                itemData = new ItemData(item);
                boolean bl = false;
                boolean bl2 = false;
                ItemData itemData2 = itemData;
                ObservableList<ItemData<T>> observableList2 = observableList;
                boolean bl3 = false;
                it.setName(itemTemplate.getName());
                it.setDescription(itemTemplate.getDescription());
                it.setView(itemTemplate.getView());
                it.setQuantity(newItemQty);
                Unit unit = Unit.INSTANCE;
                observableList2.add(itemData);
            }
        }
        return true;
    }

    @JvmOverloads
    public final boolean add(T item, @NotNull String name, @NotNull String description, @NotNull Node view) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        return Inventory.add$default(this, item, name, description, view, 0, 16, null);
    }

    @JvmOverloads
    public final boolean add(T item, @NotNull String name, @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return Inventory.add$default(this, item, name, description, null, 0, 24, null);
    }

    @JvmOverloads
    public final boolean add(T item, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return Inventory.add$default(this, item, name, null, null, 0, 28, null);
    }

    @JvmOverloads
    public final boolean add(T item) {
        return Inventory.add$default(this, item, null, null, null, 0, 30, null);
    }
}

