/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.cutscene;

import com.almasb.fxgl.animation.Animation;
import com.almasb.fxgl.animation.AnimationBuilder;
import com.almasb.fxgl.core.asset.AssetLoaderService;
import com.almasb.fxgl.core.asset.AssetType;
import com.almasb.fxgl.cutscene.Cutscene;
import com.almasb.fxgl.cutscene.Speaker;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.UserAction;
import com.almasb.fxgl.input.view.KeyView;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.scene.SceneService;
import com.almasb.fxgl.scene.SubScene;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\"H\u0002J\b\u0010$\u001a\u00020\"H\u0002J\b\u0010%\u001a\u00020\"H\u0016J\b\u0010&\u001a\u00020\"H\u0002J\u0010\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020)H\u0014J\u0010\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020,H\u0002J\u0016\u0010-\u001a\u00020\"2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018R\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\u001cj\b\u0012\u0004\u0012\u00020\u001d`\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/almasb/fxgl/cutscene/CutsceneScene;", "Lcom/almasb/fxgl/scene/SubScene;", "sceneService", "Lcom/almasb/fxgl/scene/SceneService;", "(Lcom/almasb/fxgl/scene/SceneService;)V", "animation", "Lcom/almasb/fxgl/animation/Animation;", "animation2", "assetLoader", "Lcom/almasb/fxgl/core/asset/AssetLoaderService;", "getAssetLoader$fxgl_gameplay", "()Lcom/almasb/fxgl/core/asset/AssetLoaderService;", "setAssetLoader$fxgl_gameplay", "(Lcom/almasb/fxgl/core/asset/AssetLoaderService;)V", "currentLine", "", "cutscene", "Lcom/almasb/fxgl/cutscene/Cutscene;", "log", "Lcom/almasb/fxgl/logging/Logger;", "message", "Ljava/util/ArrayDeque;", "", "onFinished", "Ljava/lang/Runnable;", "speakerImageView", "Ljavafx/scene/image/ImageView;", "speakers", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/cutscene/Speaker;", "Lkotlin/collections/ArrayList;", "textRPG", "Ljavafx/scene/text/Text;", "endCutscene", "", "nextLine", "onClose", "onCreate", "onOpen", "onUpdate", "tpf", "", "parseLine", "line", "", "start", "fxgl-gameplay"})
@SourceDebugExtension(value={"SMAP\nCutsceneScene.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CutsceneScene.kt\ncom/almasb/fxgl/cutscene/CutsceneScene\n+ 2 Logger.kt\ncom/almasb/fxgl/logging/Logger$Companion\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,251:1\n157#2:252\n1#3:253\n1174#4,2:254\n*S KotlinDebug\n*F\n+ 1 CutsceneScene.kt\ncom/almasb/fxgl/cutscene/CutsceneScene\n*L\n35#1:252\n197#1:254,2\n*E\n"})
public final class CutsceneScene
extends SubScene {
    @NotNull
    private final SceneService sceneService;
    @NotNull
    private final Logger log;
    @NotNull
    private final ArrayList<Speaker> speakers;
    @NotNull
    private final Animation<?> animation;
    @NotNull
    private final Animation<?> animation2;
    @NotNull
    private final ImageView speakerImageView;
    @NotNull
    private final Text textRPG;
    public AssetLoaderService assetLoader;
    private Cutscene cutscene;
    private Runnable onFinished;
    private int currentLine;
    @NotNull
    private final ArrayDeque<Character> message;

    public CutsceneScene(@NotNull SceneService sceneService) {
        Intrinsics.checkNotNullParameter((Object)sceneService, (String)"sceneService");
        this.sceneService = sceneService;
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$get = false;
        this.log = this_$iv.get(CutsceneScene.class);
        this.speakers = new ArrayList();
        this.speakerImageView = new ImageView();
        this.textRPG = new Text();
        Rectangle topLine = new Rectangle(this.sceneService.getPrefWidth(), 150.0);
        topLine.setTranslateY(-150.0);
        Rectangle botLine = new Rectangle(this.sceneService.getPrefWidth(), 220.0);
        botLine.setTranslateY(this.sceneService.getPrefHeight());
        AnimationBuilder animationBuilder = new AnimationBuilder(null, 1, null);
        Duration duration = Duration.seconds((double)0.5);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"seconds(0.5)");
        Node[] nodeArray = new Node[]{(Node)topLine};
        AnimationBuilder.TranslationAnimationBuilder translationAnimationBuilder = animationBuilder.duration(duration).translate(nodeArray).from(new Point2D(0.0, -150.0));
        Point2D point2D = Point2D.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"ZERO");
        this.animation = translationAnimationBuilder.to(point2D).build();
        AnimationBuilder animationBuilder2 = new AnimationBuilder(null, 1, null);
        Duration duration2 = Duration.seconds((double)0.5);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"seconds(0.5)");
        nodeArray = new Node[]{(Node)botLine};
        this.animation2 = animationBuilder2.duration(duration2).translate(nodeArray).from(new Point2D(0.0, this.sceneService.getPrefHeight())).to(new Point2D(0.0, this.sceneService.getPrefHeight() - 220.0)).build();
        this.speakerImageView.setTranslateX(25.0);
        this.speakerImageView.setTranslateY(this.sceneService.getPrefHeight() - 220.0 + (double)10);
        this.speakerImageView.setOpacity(0.0);
        this.textRPG.setFill((Paint)Color.WHITE);
        this.textRPG.setFont(Font.font((double)18.0));
        this.textRPG.setWrappingWidth(this.sceneService.getPrefWidth() - 155.0 - (double)200);
        this.textRPG.setTranslateX(250.0);
        this.textRPG.setTranslateY(this.sceneService.getPrefHeight() - 160.0);
        this.textRPG.setOpacity(0.0);
        Color color = Color.GREENYELLOW;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"GREENYELLOW");
        KeyView keyView = new KeyView(KeyCode.ENTER, color, 18.0);
        keyView.setTranslateX(this.sceneService.getPrefWidth() - 80.0);
        keyView.setTranslateY(this.sceneService.getPrefHeight() - 40.0);
        keyView.opacityProperty().bind((ObservableValue)this.textRPG.opacityProperty());
        Object[] objectArray = new Node[]{(Node)topLine, (Node)botLine, (Node)this.speakerImageView, (Node)this.textRPG, (Node)keyView};
        this.getContentRoot().getChildren().addAll(objectArray);
        Input.addAction$default((Input)this.getInput(), (UserAction)new UserAction(){

            protected void onActionBegin() {
                this.nextLine();
            }
        }, (KeyCode)KeyCode.ENTER, null, (int)4, null);
        this.message = new ArrayDeque();
    }

    @NotNull
    public final AssetLoaderService getAssetLoader$fxgl_gameplay() {
        AssetLoaderService assetLoaderService = this.assetLoader;
        if (assetLoaderService != null) {
            return assetLoaderService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"assetLoader");
        return null;
    }

    public final void setAssetLoader$fxgl_gameplay(@NotNull AssetLoaderService assetLoaderService) {
        Intrinsics.checkNotNullParameter((Object)assetLoaderService, (String)"<set-?>");
        this.assetLoader = assetLoaderService;
    }

    public void onCreate() {
        this.animation2.setOnFinished(() -> CutsceneScene.onCreate$lambda$0(this));
        this.animation.start();
        this.animation2.start();
    }

    protected void onUpdate(double tpf) {
        this.animation.onUpdate(tpf);
        this.animation2.onUpdate(tpf);
        if (!((Collection)this.message).isEmpty()) {
            Text text = this.textRPG;
            text.setText(text.getText() + this.message.poll());
        }
    }

    private final void endCutscene() {
        this.speakerImageView.setImage(null);
        this.speakerImageView.setOpacity(0.0);
        this.textRPG.setOpacity(0.0);
        this.animation2.setOnFinished(() -> CutsceneScene.endCutscene$lambda$1(this));
        this.animation.startReverse();
        this.animation2.startReverse();
    }

    public final void start(@NotNull Cutscene cutscene, @NotNull Runnable onFinished) {
        Intrinsics.checkNotNullParameter((Object)cutscene, (String)"cutscene");
        Intrinsics.checkNotNullParameter((Object)onFinished, (String)"onFinished");
        this.cutscene = cutscene;
        this.onFinished = onFinished;
        this.nextLine();
        this.sceneService.pushSubScene((SubScene)this);
    }

    private final void nextLine() {
        if (!((Collection)this.message).isEmpty()) {
            return;
        }
        Cutscene cutscene = this.cutscene;
        if (cutscene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cutscene");
            cutscene = null;
        }
        if (this.currentLine == cutscene.getLines().size()) {
            this.endCutscene();
            return;
        }
        Cutscene cutscene2 = this.cutscene;
        if (cutscene2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cutscene");
            cutscene2 = null;
        }
        String line = ((Object)StringsKt.trim((CharSequence)cutscene2.getLines().get(this.currentLine))).toString();
        int n = this.currentLine;
        this.currentLine = n + 1;
        try {
            this.parseLine(line);
        }
        catch (Exception e) {
            this.log.warning("Cannot parse, skipping: " + line, (Throwable)e);
            this.nextLine();
        }
    }

    private final void parseLine(String line) {
        if (StringsKt.startsWith$default((String)line, (String)"//", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"#", (boolean)false, (int)2, null) || ((CharSequence)line).length() == 0) {
            this.nextLine();
            return;
        }
        int n = line.length();
        for (int i = 0; i < n; ++i) {
            Speaker speaker;
            Object v8;
            String id;
            block14: {
                char c = line.charAt(i);
                if (c == '.') {
                    Speaker speaker2;
                    Object v1;
                    Object object2;
                    String id2;
                    block13: {
                        String string = line.substring(0, i);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        id2 = string;
                        Iterable iterable = this.speakers;
                        for (Object object2 : iterable) {
                            Speaker it = (Speaker)object2;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)id2)) continue;
                            v1 = object2;
                            break block13;
                        }
                        v1 = null;
                    }
                    if ((speaker2 = (Speaker)v1) == null) {
                        Speaker speaker3;
                        Speaker it = speaker3 = new Speaker(id2, null, null, 6, null);
                        boolean bl = false;
                        ((Collection)this.speakers).add(it);
                        speaker2 = speaker3;
                    }
                    Speaker speaker4 = speaker2;
                    String string = line.substring(i + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    String subLine = string;
                    int indexEquals = StringsKt.indexOf$default((CharSequence)subLine, (char)'=', (int)0, (boolean)false, (int)6, null);
                    String string2 = subLine.substring(0, indexEquals);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String varName = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                    String string3 = subLine.substring(indexEquals + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                    String varValue = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                    object2 = varName;
                    if (Intrinsics.areEqual(object2, (Object)"name")) {
                        speaker4.setName(varValue);
                    } else if (Intrinsics.areEqual(object2, (Object)"image")) {
                        speaker4.setImageName(varValue);
                    }
                    this.nextLine();
                    return;
                }
                if (c != ':') continue;
                String string = line.substring(0, i);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                id = string;
                String string4 = line.substring(i + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                String text = string4;
                CharSequence $this$forEach$iv = text;
                boolean $i$f$forEach = false;
                for (int j = 0; j < $this$forEach$iv.length(); ++j) {
                    char element$iv;
                    char it = element$iv = $this$forEach$iv.charAt(j);
                    boolean bl = false;
                    this.message.addLast(Character.valueOf(it));
                }
                Iterable element$iv = this.speakers;
                for (Object t : element$iv) {
                    Speaker it = (Speaker)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                    v8 = t;
                    break block14;
                }
                v8 = null;
            }
            if ((speaker = (Speaker)v8) == null) {
                Speaker speaker5;
                Speaker it = speaker5 = new Speaker(id, null, null, 6, null);
                boolean bl = false;
                ((Collection)this.speakers).add(it);
                speaker = speaker5;
            }
            Speaker speaker6 = speaker;
            this.textRPG.setText(speaker6.getName() + ": ");
            if (((CharSequence)speaker6.getImageName()).length() == 0) {
                this.speakerImageView.setImage(null);
            } else {
                Image image = (Image)this.getAssetLoader$fxgl_gameplay().load(AssetType.IMAGE, speaker6.getImageName());
                this.speakerImageView.setImage(image);
            }
            return;
        }
    }

    private final void onOpen() {
        this.speakerImageView.setOpacity(1.0);
        this.textRPG.setOpacity(1.0);
    }

    private final void onClose() {
        this.currentLine = 0;
        this.message.clear();
    }

    private static final void onCreate$lambda$0(CutsceneScene this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onOpen();
    }

    private static final void endCutscene$lambda$1(CutsceneScene this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.sceneService.popSubScene();
        this$0.onClose();
        Runnable runnable = this$0.onFinished;
        if (runnable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"onFinished");
            runnable = null;
        }
        runnable.run();
    }
}

