/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.cutscene.dialogue;

import com.almasb.fxgl.cutscene.dialogue.DialogueEdge;
import com.almasb.fxgl.cutscene.dialogue.DialogueNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0007J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\rJ\u001e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\rJ\u000e\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\rJ\u001e\u0010&\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u0000J\u000e\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020\rJ\u0006\u0010*\u001a\u00020\u0000J\u000e\u0010+\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\rJ\u000e\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020\u0003J\u0010\u0010.\u001a\u0004\u0018\u00010\r2\u0006\u0010%\u001a\u00020\rJ\u0018\u0010.\u001a\u0004\u0018\u00010\r2\u0006\u0010%\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u0003J\u001e\u0010/\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\rJ\u000e\u00100\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0007J\u0016\u00100\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\rJ\u000e\u00101\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\rR5\u0010\u0005\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nRQ\u0010\u000b\u001aB\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \b*\u0004\u0018\u00010\r0\r \b* \u0012\f\u0012\n \b*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \b*\u0004\u0018\u00010\r0\r\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0004R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0016\"\u0004\b\u001d\u0010\u0004\u00a8\u00062"}, d2={"Lcom/almasb/fxgl/cutscene/dialogue/DialogueGraph;", "", "uniqueID", "", "(I)V", "edges", "Ljavafx/collections/ObservableList;", "Lcom/almasb/fxgl/cutscene/dialogue/DialogueEdge;", "kotlin.jvm.PlatformType", "getEdges", "()Ljavafx/collections/ObservableList;", "nodes", "Ljavafx/collections/ObservableMap;", "Lcom/almasb/fxgl/cutscene/dialogue/DialogueNode;", "getNodes", "()Ljavafx/collections/ObservableMap;", "startNode", "getStartNode", "()Lcom/almasb/fxgl/cutscene/dialogue/DialogueNode;", "value", "startNodeID", "getStartNodeID", "()I", "setStartNodeID", "startNodeIDProperty", "Ljavafx/beans/property/IntegerProperty;", "getStartNodeIDProperty", "()Ljavafx/beans/property/IntegerProperty;", "getUniqueID$fxgl_gameplay", "setUniqueID$fxgl_gameplay", "addEdge", "", "edge", "source", "target", "optionID", "addNode", "node", "appendGraph", "graph", "containsNode", "", "copy", "findNodeID", "getNodeByID", "id", "nextNode", "removeChoiceEdge", "removeEdge", "removeNode", "fxgl-gameplay"})
@SourceDebugExtension(value={"SMAP\nDialogueGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DialogueGraph.kt\ncom/almasb/fxgl/cutscene/dialogue/DialogueGraph\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,343:1\n1#2:344\n*E\n"})
public final class DialogueGraph {
    private int uniqueID;
    private final ObservableMap<Integer, DialogueNode> nodes;
    private final ObservableList<DialogueEdge> edges;
    @NotNull
    private final IntegerProperty startNodeIDProperty;

    public DialogueGraph(int uniqueID) {
        this.uniqueID = uniqueID;
        this.nodes = FXCollections.observableMap((Map)new HashMap());
        this.edges = FXCollections.observableArrayList();
        this.startNodeIDProperty = (IntegerProperty)new SimpleIntegerProperty(0);
    }

    public /* synthetic */ DialogueGraph(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n);
    }

    public final int getUniqueID$fxgl_gameplay() {
        return this.uniqueID;
    }

    public final void setUniqueID$fxgl_gameplay(int n) {
        this.uniqueID = n;
    }

    public final ObservableMap<Integer, DialogueNode> getNodes() {
        return this.nodes;
    }

    public final ObservableList<DialogueEdge> getEdges() {
        return this.edges;
    }

    @NotNull
    public final IntegerProperty getStartNodeIDProperty() {
        return this.startNodeIDProperty;
    }

    public final int getStartNodeID() {
        Integer n = this.startNodeIDProperty.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"startNodeIDProperty.value");
        return ((Number)n).intValue();
    }

    public final void setStartNodeID(int value) {
        this.startNodeIDProperty.setValue((Number)value);
    }

    @NotNull
    public final DialogueNode getStartNode() {
        return this.getNodeByID(this.getStartNodeID());
    }

    public final void addNode(@NotNull DialogueNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ObservableMap<Integer, DialogueNode> observableMap = this.nodes;
        Intrinsics.checkNotNullExpressionValue(observableMap, (String)"nodes");
        Map map = (Map)observableMap;
        int n = this.uniqueID;
        this.uniqueID = n + 1;
        map.put(n, node);
    }

    public final void removeNode(@NotNull DialogueNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        int id = this.findNodeID(node);
        this.nodes.remove((Object)id);
        this.edges.removeIf(arg_0 -> DialogueGraph.removeNode$lambda$0((Function1)new Function1<DialogueEdge, Boolean>(node){
            final /* synthetic */ DialogueNode $node;
            {
                this.$node = $node;
                super(1);
            }

            @NotNull
            public final Boolean invoke(DialogueEdge it) {
                return it.getSource() == this.$node || it.getTarget() == this.$node;
            }
        }, arg_0));
    }

    public final void addEdge(@NotNull DialogueEdge edge) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        ObservableList<DialogueEdge> observableList = this.edges;
        Intrinsics.checkNotNullExpressionValue(observableList, (String)"edges");
        ((Collection)observableList).add(edge);
    }

    public final void removeEdge(@NotNull DialogueEdge edge) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        ObservableList<DialogueEdge> observableList = this.edges;
        Intrinsics.checkNotNullExpressionValue(observableList, (String)"edges");
        ((Collection)observableList).remove(edge);
    }

    public final void addEdge(@NotNull DialogueNode source, @NotNull DialogueNode target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ObservableList<DialogueEdge> observableList = this.edges;
        Intrinsics.checkNotNullExpressionValue(observableList, (String)"edges");
        Collection collection = (Collection)observableList;
        collection.add(new DialogueEdge(source, target));
    }

    public final void addEdge(@NotNull DialogueNode source, int optionID, @NotNull DialogueNode target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ObservableList<DialogueEdge> observableList = this.edges;
        Intrinsics.checkNotNullExpressionValue(observableList, (String)"edges");
        Collection collection = (Collection)observableList;
        collection.add(new DialogueEdge(source, optionID, target));
    }

    public final void removeEdge(@NotNull DialogueNode source, @NotNull DialogueNode target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.edges.removeIf(arg_0 -> DialogueGraph.removeEdge$lambda$1((Function1)new Function1<DialogueEdge, Boolean>(source, target){
            final /* synthetic */ DialogueNode $source;
            final /* synthetic */ DialogueNode $target;
            {
                this.$source = $source;
                this.$target = $target;
                super(1);
            }

            @NotNull
            public final Boolean invoke(DialogueEdge it) {
                return it.getSource() == this.$source && it.getTarget() == this.$target;
            }
        }, arg_0));
    }

    public final void removeChoiceEdge(@NotNull DialogueNode source, int optionID, @NotNull DialogueNode target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.edges.removeIf(arg_0 -> DialogueGraph.removeChoiceEdge$lambda$2((Function1)new Function1<DialogueEdge, Boolean>(source, optionID, target){
            final /* synthetic */ DialogueNode $source;
            final /* synthetic */ int $optionID;
            final /* synthetic */ DialogueNode $target;
            {
                this.$source = $source;
                this.$optionID = $optionID;
                this.$target = $target;
                super(1);
            }

            @NotNull
            public final Boolean invoke(DialogueEdge it) {
                return it.getSource() == this.$source && it.getOptionID() == this.$optionID && it.getTarget() == this.$target;
            }
        }, arg_0));
    }

    public final boolean containsNode(@NotNull DialogueNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.nodes.values().contains(node);
    }

    public final int findNodeID(@NotNull DialogueNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ObservableMap<Integer, DialogueNode> observableMap = this.nodes;
        Intrinsics.checkNotNullExpressionValue(observableMap, (String)"nodes");
        for (Map.Entry entry : ((Map)observableMap).entrySet()) {
            Integer id = (Integer)entry.getKey();
            DialogueNode n = (DialogueNode)entry.getValue();
            if (n != node) continue;
            Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
            return id;
        }
        return -1;
    }

    @NotNull
    public final DialogueNode getNodeByID(int id) {
        DialogueNode dialogueNode = (DialogueNode)this.nodes.get((Object)id);
        if (dialogueNode == null) {
            throw new IllegalArgumentException("Graph does not contain a node with id " + id);
        }
        return dialogueNode;
    }

    @Nullable
    public final DialogueNode nextNode(@NotNull DialogueNode node) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            ObservableList<DialogueEdge> observableList = this.edges;
            Intrinsics.checkNotNullExpressionValue(observableList, (String)"edges");
            Iterable iterable = (Iterable)observableList;
            for (Object t : iterable) {
                DialogueEdge it = (DialogueEdge)t;
                boolean bl = false;
                if (!(it.getSource() == node)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        DialogueEdge dialogueEdge = v1;
        return dialogueEdge != null ? dialogueEdge.getTarget() : null;
    }

    @Nullable
    public final DialogueNode nextNode(@NotNull DialogueNode node, int optionID) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            ObservableList<DialogueEdge> observableList = this.edges;
            Intrinsics.checkNotNullExpressionValue(observableList, (String)"edges");
            Iterable iterable = (Iterable)observableList;
            for (Object t : iterable) {
                DialogueEdge it = (DialogueEdge)t;
                boolean bl = false;
                if (!(it.getSource() == node && it.getOptionID() == optionID)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        DialogueEdge dialogueEdge = v1;
        return dialogueEdge != null ? dialogueEdge.getTarget() : null;
    }

    public final void appendGraph(@NotNull DialogueNode source, @NotNull DialogueNode target, @NotNull DialogueGraph graph) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
    }

    @NotNull
    public final DialogueGraph copy() {
        DialogueGraph copy = new DialogueGraph(this.uniqueID);
        copy.setStartNodeID(this.getStartNodeID());
        ObservableMap<Integer, DialogueNode> observableMap = copy.nodes;
        ObservableMap<Integer, DialogueNode> observableMap2 = this.nodes;
        Intrinsics.checkNotNullExpressionValue(observableMap2, (String)"nodes");
        observableMap.putAll((Map)observableMap2);
        ObservableList<DialogueEdge> observableList = copy.edges;
        ObservableList<DialogueEdge> observableList2 = this.edges;
        Intrinsics.checkNotNullExpressionValue(observableList2, (String)"edges");
        observableList.addAll((Collection)observableList2);
        return copy;
    }

    private static final boolean removeNode$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeEdge$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeChoiceEdge$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public DialogueGraph() {
        this(0, 1, null);
    }
}

