/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.inventory;

import com.almasb.fxgl.inventory.Inventory;
import com.almasb.fxgl.inventory.ItemData;
import com.almasb.fxgl.inventory.ItemStack;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/almasb/fxgl/inventory/InventoryListCell;", "T", "Ljavafx/scene/control/ListCell;", "Lcom/almasb/fxgl/inventory/ItemStack;", "inventory", "Lcom/almasb/fxgl/inventory/Inventory;", "(Lcom/almasb/fxgl/inventory/Inventory;)V", "updateItem", "", "item", "empty", "", "fxgl-gameplay"})
public final class InventoryListCell<T>
extends ListCell<ItemStack<T>> {
    @NotNull
    private final Inventory<T> inventory;

    public InventoryListCell(@NotNull Inventory<T> inventory) {
        Intrinsics.checkNotNullParameter(inventory, (String)"inventory");
        this.inventory = inventory;
    }

    protected void updateItem(@Nullable ItemStack<T> item, boolean empty) {
        super.updateItem(item, empty);
        if (empty || item == null) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            ItemData<T> itemData = this.inventory.getData(item.getUserItem()).get();
            Intrinsics.checkNotNullExpressionValue(itemData, (String)"inventory.getData(item.userItem).get()");
            ItemData<T> itemData2 = itemData;
            Observable[] observableArray = new Observable[]{(Observable)itemData2.nameProperty()};
            StringBinding nameBinding = Bindings.createStringBinding(() -> InventoryListCell.updateItem$lambda$0(itemData2), (Observable[])observableArray);
            Text label = new Text();
            label.textProperty().bind((ObservableValue)nameBinding.concat((Object)" x").concat((Object)itemData2.quantityProperty()));
            label.setFill((Paint)Color.WHITE);
            this.setText(null);
            this.setGraphic((Node)label);
        }
    }

    private static final String updateItem$lambda$0(ItemData $itemData) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$itemData, (String)"$itemData");
        int limit = 20;
        if ($itemData.getName().length() > limit) {
            String string = $itemData.getName().substring(0, limit);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            object = string + "...";
        } else {
            object = $itemData.getName();
        }
        return object;
    }
}

