/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.quest;

import com.almasb.fxgl.core.Updatable;
import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.quest.QuestState;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B!\b\u0005\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\r\u0010#\u001a\u00020$H \u00a2\u0006\u0002\b%J\b\u0010&\u001a\u00020$H\u0002J\u0006\u0010'\u001a\u00020$J\u0006\u0010(\u001a\u00020$J\u0010\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020\u001cH\u0016J\u0006\u0010+\u001a\u00020$J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000e0-J\u0006\u0010.\u001a\u00020/J\r\u00100\u001a\u00020$H\u0000\u00a2\u0006\u0002\b1R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u000e0\u000e0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u0082\u0001\u000223\u00a8\u00064"}, d2={"Lcom/almasb/fxgl/quest/QuestObjective;", "Lcom/almasb/fxgl/core/Updatable;", "description", "", "vars", "Lcom/almasb/fxgl/core/collection/PropertyMap;", "expireDuration", "Ljavafx/util/Duration;", "(Ljava/lang/String;Lcom/almasb/fxgl/core/collection/PropertyMap;Ljavafx/util/Duration;)V", "getDescription", "()Ljava/lang/String;", "getExpireDuration", "()Ljavafx/util/Duration;", "state", "Lcom/almasb/fxgl/quest/QuestState;", "getState", "()Lcom/almasb/fxgl/quest/QuestState;", "stateProp", "Ljavafx/beans/property/ReadOnlyObjectWrapper;", "kotlin.jvm.PlatformType", "successListener", "Ljavafx/beans/value/ChangeListener;", "", "successProp", "Ljavafx/beans/property/ReadOnlyBooleanWrapper;", "getSuccessProp", "()Ljavafx/beans/property/ReadOnlyBooleanWrapper;", "timeRemaining", "", "getTimeRemaining", "()D", "timeRemainingProp", "Ljavafx/beans/property/ReadOnlyDoubleWrapper;", "getVars", "()Lcom/almasb/fxgl/core/collection/PropertyMap;", "bindToVars", "", "bindToVars$fxgl_gameplay", "clean", "complete", "fail", "onUpdate", "tpf", "reactivate", "stateProperty", "Ljavafx/beans/property/ReadOnlyObjectProperty;", "timeRemainingProperty", "Ljavafx/beans/property/ReadOnlyDoubleProperty;", "unbindFromVars", "unbindFromVars$fxgl_gameplay", "Lcom/almasb/fxgl/quest/BooleanQuestObjective;", "Lcom/almasb/fxgl/quest/IntQuestObjective;", "fxgl-gameplay"})
public abstract class QuestObjective
implements Updatable {
    @NotNull
    private final String description;
    @NotNull
    private final PropertyMap vars;
    @NotNull
    private final Duration expireDuration;
    @NotNull
    private final ReadOnlyObjectWrapper<QuestState> stateProp;
    @NotNull
    private final ReadOnlyDoubleWrapper timeRemainingProp;
    @NotNull
    private final ReadOnlyBooleanWrapper successProp;
    @NotNull
    private final ChangeListener<Boolean> successListener;

    @JvmOverloads
    private QuestObjective(String description, PropertyMap vars, Duration expireDuration) {
        this.description = description;
        this.vars = vars;
        this.expireDuration = expireDuration;
        this.stateProp = new ReadOnlyObjectWrapper((Object)QuestState.ACTIVE);
        this.timeRemainingProp = new ReadOnlyDoubleWrapper(this.expireDuration.toSeconds());
        this.successProp = new ReadOnlyBooleanWrapper();
        this.successListener = (arg_0, arg_1, arg_2) -> QuestObjective.successListener$lambda$0(this, arg_0, arg_1, arg_2);
        this.successProp.addListener(this.successListener);
    }

    public /* synthetic */ QuestObjective(String string, PropertyMap propertyMap, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ZERO");
            duration = duration2;
        }
        this(string, propertyMap, duration, null);
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    protected final PropertyMap getVars() {
        return this.vars;
    }

    @NotNull
    public final Duration getExpireDuration() {
        return this.expireDuration;
    }

    @NotNull
    public final QuestState getState() {
        Object object = this.stateProp.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stateProp.get()");
        return (QuestState)((Object)object);
    }

    @NotNull
    public final ReadOnlyObjectProperty<QuestState> stateProperty() {
        ReadOnlyObjectProperty readOnlyObjectProperty = this.stateProp.getReadOnlyProperty();
        Intrinsics.checkNotNullExpressionValue((Object)readOnlyObjectProperty, (String)"stateProp.readOnlyProperty");
        return readOnlyObjectProperty;
    }

    public final double getTimeRemaining() {
        Double d = this.timeRemainingProp.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"timeRemainingProp.value");
        return ((Number)d).doubleValue();
    }

    @NotNull
    public final ReadOnlyDoubleProperty timeRemainingProperty() {
        ReadOnlyDoubleProperty readOnlyDoubleProperty = this.timeRemainingProp.getReadOnlyProperty();
        Intrinsics.checkNotNullExpressionValue((Object)readOnlyDoubleProperty, (String)"timeRemainingProp.readOnlyProperty");
        return readOnlyDoubleProperty;
    }

    @NotNull
    protected final ReadOnlyBooleanWrapper getSuccessProp() {
        return this.successProp;
    }

    public void onUpdate(double tpf) {
        if (this.getState() != QuestState.ACTIVE) {
            return;
        }
        if (this.expireDuration.lessThanOrEqualTo(Duration.ZERO)) {
            return;
        }
        double remaining = this.getTimeRemaining() - tpf;
        if (remaining <= 0.0) {
            this.timeRemainingProp.setValue((Number)0.0);
            this.fail();
        } else {
            this.timeRemainingProp.setValue((Number)remaining);
        }
    }

    public final void complete() {
        if (this.getState() != QuestState.ACTIVE) {
            return;
        }
        this.unbindFromVars$fxgl_gameplay();
        this.successProp.setValue(Boolean.valueOf(true));
    }

    public final void fail() {
        if (this.getState() != QuestState.ACTIVE) {
            return;
        }
        this.unbindFromVars$fxgl_gameplay();
        this.successProp.setValue(Boolean.valueOf(false));
        this.clean();
        this.stateProp.setValue((Object)QuestState.FAILED);
    }

    public final void reactivate() {
        if (this.getState() != QuestState.FAILED) {
            return;
        }
        this.stateProp.setValue((Object)QuestState.ACTIVE);
        this.timeRemainingProp.setValue((Number)this.expireDuration.toSeconds());
        this.successProp.addListener(this.successListener);
        this.bindToVars$fxgl_gameplay();
    }

    public abstract void bindToVars$fxgl_gameplay();

    public final void unbindFromVars$fxgl_gameplay() {
        this.successProp.unbind();
    }

    private final void clean() {
        this.successProp.removeListener(this.successListener);
    }

    @JvmOverloads
    private QuestObjective(String description, PropertyMap vars) {
        this(description, vars, null, 4, null);
    }

    private static final void successListener$lambda$0(QuestObjective this$0, ObservableValue observableValue, Boolean bl, Boolean isReached) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)isReached, (String)"isReached");
        if (isReached.booleanValue()) {
            this$0.clean();
            this$0.stateProp.setValue((Object)QuestState.COMPLETED);
        }
    }

    public /* synthetic */ QuestObjective(String description, PropertyMap vars, Duration expireDuration, DefaultConstructorMarker $constructor_marker) {
        this(description, vars, expireDuration);
    }

    public /* synthetic */ QuestObjective(String description, PropertyMap vars, DefaultConstructorMarker $constructor_marker) {
        this(description, vars);
    }
}

