/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.net;

import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.net.Client;
import com.almasb.fxgl.net.ClientConfig;
import com.almasb.fxgl.net.DownloadCallback;
import com.almasb.fxgl.net.Server;
import com.almasb.fxgl.net.ServerConfig;
import com.almasb.fxgl.net.UDPClientConfig;
import com.almasb.fxgl.net.UDPServerConfig;
import com.almasb.fxgl.net.tcp.TCPClient;
import com.almasb.fxgl.net.tcp.TCPServer;
import com.almasb.fxgl.net.udp.UDPClient;
import com.almasb.fxgl.net.udp.UDPServer;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javafx.application.Platform;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bJ$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J0\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00140\u000f\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\u0006\u0010\u0012\u001a\u00020\u0013J(\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0018\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0019J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J0\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00140\u000f\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u001bJ\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\u0006\u0010\u0012\u001a\u00020\u0013J(\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0018\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u001dJ\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00062\u0006\u0010\b\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/almasb/fxgl/net/NetService;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "downloadTask", "Lcom/almasb/fxgl/core/concurrent/IOTask;", "Ljava/nio/file/Path;", "url", "Ljava/net/URL;", "fileName", "", "callback", "Lcom/almasb/fxgl/net/DownloadCallback;", "newTCPClient", "Lcom/almasb/fxgl/net/Client;", "Lcom/almasb/fxgl/core/serialization/Bundle;", "ip", "port", "", "T", "config", "Lcom/almasb/fxgl/net/ClientConfig;", "newTCPServer", "Lcom/almasb/fxgl/net/Server;", "Lcom/almasb/fxgl/net/ServerConfig;", "newUDPClient", "Lcom/almasb/fxgl/net/UDPClientConfig;", "newUDPServer", "Lcom/almasb/fxgl/net/UDPServerConfig;", "openStreamTask", "Ljava/io/InputStream;", "DownloadTask", "fxgl-io"})
public final class NetService
extends EngineService {
    @NotNull
    private final Logger log = Logger.Companion.get(((Object)((Object)this)).getClass());

    @NotNull
    public final IOTask<InputStream> openStreamTask(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        IOTask iOTask = IOTask.of((String)("openStream(" + url + ")"), () -> NetService.openStreamTask$lambda$0(url));
        Intrinsics.checkNotNullExpressionValue((Object)iOTask, (String)"of(\"openStream($url)\") {\u2026L(url).openStream()\n    }");
        return iOTask;
    }

    @NotNull
    public final Server<Bundle> newTCPServer(int port) {
        return new TCPServer<Bundle>(port, Bundle.class);
    }

    @NotNull
    public final <T> Server<T> newTCPServer(int port, @NotNull ServerConfig<T> config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        return new TCPServer<T>(port, config.getMessageType());
    }

    @NotNull
    public final Client<Bundle> newTCPClient(@NotNull String ip, int port) {
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        return new TCPClient<Bundle>(ip, port, Bundle.class);
    }

    @NotNull
    public final <T> Client<T> newTCPClient(@NotNull String ip, int port, @NotNull ClientConfig<T> config) {
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        return new TCPClient<T>(ip, port, config.getMessageType());
    }

    @NotNull
    public final Server<Bundle> newUDPServer(int port) {
        return new UDPServer(port, new UDPServerConfig(Bundle.class, 0, 2, null));
    }

    @NotNull
    public final <T> Server<T> newUDPServer(int port, @NotNull UDPServerConfig<T> config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        return new UDPServer<T>(port, config);
    }

    @NotNull
    public final Client<Bundle> newUDPClient(@NotNull String ip, int port) {
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        return new UDPClient(ip, port, new UDPClientConfig(Bundle.class, 0, 2, null));
    }

    @NotNull
    public final <T> Client<T> newUDPClient(@NotNull String ip, int port, @NotNull UDPClientConfig<T> config) {
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        return new UDPClient<T>(ip, port, config);
    }

    @NotNull
    public final IOTask<Path> downloadTask(@NotNull String url, @NotNull String fileName, @NotNull DownloadCallback callback) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        return new DownloadTask(url, fileName, callback);
    }

    @NotNull
    public final IOTask<Path> downloadTask(@NotNull String url, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return new DownloadTask(url, fileName, null, 4, null);
    }

    @NotNull
    public final IOTask<Path> downloadTask(@NotNull URL url, @NotNull String fileName, @NotNull DownloadCallback callback) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String string = url.toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.toExternalForm()");
        return new DownloadTask(string, fileName, callback);
    }

    @NotNull
    public final IOTask<Path> downloadTask(@NotNull URL url, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String string = url.toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.toExternalForm()");
        return new DownloadTask(string, fileName, null, 4, null);
    }

    private static final InputStream openStreamTask$lambda$0(String $url) {
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        return new URL($url).openStream();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0002H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/almasb/fxgl/net/NetService$DownloadTask;", "Lcom/almasb/fxgl/core/concurrent/IOTask;", "Ljava/nio/file/Path;", "urlString", "", "fileName", "callback", "Lcom/almasb/fxgl/net/DownloadCallback;", "(Ljava/lang/String;Ljava/lang/String;Lcom/almasb/fxgl/net/DownloadCallback;)V", "onExecute", "fxgl-io"})
    @SourceDebugExtension(value={"SMAP\nNetService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetService.kt\ncom/almasb/fxgl/net/NetService$DownloadTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1#2:166\n*E\n"})
    private static final class DownloadTask
    extends IOTask<Path> {
        @NotNull
        private final String urlString;
        @NotNull
        private final String fileName;
        @NotNull
        private final DownloadCallback callback;

        public DownloadTask(@NotNull String urlString, @NotNull String fileName, @NotNull DownloadCallback callback) {
            Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            super("DownloadTask(" + urlString + ", " + fileName + ")");
            this.urlString = urlString;
            this.fileName = fileName;
            this.callback = callback;
        }

        public /* synthetic */ DownloadTask(String string, String string2, DownloadCallback downloadCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                downloadCallback = new DownloadCallback();
            }
            this(string, string2, downloadCallback);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        protected Path onExecute() {
            URL url = new URL(this.urlString);
            Path file = Paths.get(this.fileName, new String[0]);
            URLConnection connection = url.openConnection();
            long downloadSize = connection.getContentLengthLong();
            InputStream inputStream = connection.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"connection.getInputStream()");
            InputStream inStream = inputStream;
            OutputStream outputStream = Files.newOutputStream(file, new OpenOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(file)");
            OutputStream outStream = outputStream;
            Closeable closeable = outStream;
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = inStream;
                Throwable throwable2 = null;
                try {
                    InputStream it2 = (InputStream)closeable2;
                    boolean bl2 = false;
                    Ref.LongRef transferred = new Ref.LongRef();
                    byte[] buffer = new byte[8192];
                    int read = 0;
                    while (true) {
                        int n;
                        int it3 = n = inStream.read(buffer, 0, 8192);
                        boolean bl3 = false;
                        read = it3;
                        if (n < 0) break;
                        if (this.isCancelled()) {
                            this.throwCancelException();
                        }
                        outStream.write(buffer, 0, read);
                        transferred.element += (long)read;
                        Platform.runLater(() -> DownloadTask.onExecute$lambda$3$lambda$2$lambda$1(this, transferred, downloadSize));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
            return file;
        }

        private static final void onExecute$lambda$3$lambda$2$lambda$1(DownloadTask this$0, Ref.LongRef $transferred, long $downloadSize) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$transferred, (String)"$transferred");
            this$0.callback.getProgressProp$fxgl_io().setValue((Number)((double)$transferred.element / (double)$downloadSize));
        }
    }
}

