/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.net.udp;

import com.almasb.fxgl.net.Connection;
import com.almasb.fxgl.net.udp.UDPClientKt;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001c\u001a\u00020\u0011H\u0014J\u0015\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b J\u000e\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0013J\b\u0010\"\u001a\u00020\u001eH\u0014R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/almasb/fxgl/net/udp/UDPConnection;", "T", "Lcom/almasb/fxgl/net/Connection;", "socket", "Ljava/net/DatagramSocket;", "remoteIp", "", "remotePort", "", "bufferSize", "connectionNum", "(Ljava/net/DatagramSocket;Ljava/lang/String;III)V", "currentSize", "fullIP", "getFullIP", "()Ljava/lang/String;", "isClosed", "", "messageBuffer", "", "messageSize", "recvQueue", "Ljava/util/concurrent/ArrayBlockingQueue;", "getRecvQueue", "()Ljava/util/concurrent/ArrayBlockingQueue;", "getRemoteIp", "getRemotePort", "()I", "isClosedLocally", "receive", "", "data", "receive$fxgl_io", "sendUDP", "terminateImpl", "fxgl-io"})
public final class UDPConnection<T>
extends Connection<T> {
    @NotNull
    private final DatagramSocket socket;
    @NotNull
    private final String remoteIp;
    private final int remotePort;
    private final int bufferSize;
    private boolean isClosed;
    @NotNull
    private final ArrayBlockingQueue<byte[]> recvQueue;
    private int messageSize;
    @NotNull
    private byte[] messageBuffer;
    private int currentSize;

    public UDPConnection(@NotNull DatagramSocket socket, @NotNull String remoteIp, int remotePort, int bufferSize, int connectionNum) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter((Object)remoteIp, (String)"remoteIp");
        super(connectionNum);
        this.socket = socket;
        this.remoteIp = remoteIp;
        this.remotePort = remotePort;
        this.bufferSize = bufferSize;
        this.recvQueue = new ArrayBlockingQueue(30);
        this.messageSize = -1;
        this.messageBuffer = new byte[0];
    }

    @NotNull
    public final String getRemoteIp() {
        return this.remoteIp;
    }

    public final int getRemotePort() {
        return this.remotePort;
    }

    @NotNull
    public final String getFullIP() {
        return this.remoteIp + this.remotePort;
    }

    @NotNull
    public final ArrayBlockingQueue<byte[]> getRecvQueue() {
        return this.recvQueue;
    }

    @Override
    protected boolean isClosedLocally() {
        return this.isClosed;
    }

    @Override
    protected void terminateImpl() {
        this.isClosed = true;
        DatagramPacket packet = new DatagramPacket(UDPClientKt.getMESSAGE_CLOSE(), UDPClientKt.getMESSAGE_CLOSE().length);
        this.socket.send(packet);
    }

    public final void sendUDP(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte[] sizeAsByteArray = ByteBuffer.allocate(4).putInt(data.length).array();
        DatagramPacket packet = new DatagramPacket(sizeAsByteArray, 4, InetAddress.getByName(this.remoteIp), this.remotePort);
        this.socket.send(packet);
        if (data.length <= this.bufferSize) {
            this.socket.send(new DatagramPacket(data, data.length, InetAddress.getByName(this.remoteIp), this.remotePort));
        } else {
            int numChunks = data.length / this.bufferSize;
            boolean bl = false;
            int n = 0;
            n = 0;
            int n2 = numChunks;
            while (n < n2) {
                int index = n++;
                boolean bl2 = false;
                byte[] newData = Arrays.copyOfRange(data, index * this.bufferSize, index * this.bufferSize + this.bufferSize);
                this.socket.send(new DatagramPacket(newData, this.bufferSize, InetAddress.getByName(this.getRemoteIp()), this.getRemotePort()));
            }
            int remainderSize = data.length - numChunks * this.bufferSize;
            byte[] remainderData = Arrays.copyOfRange(data, data.length - remainderSize, data.length);
            this.socket.send(new DatagramPacket(remainderData, remainderSize, InetAddress.getByName(this.remoteIp), this.remotePort));
        }
    }

    public final void receive$fxgl_io(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (this.messageSize == -1) {
            this.messageSize = ByteBuffer.wrap(data).getInt();
            this.messageBuffer = new byte[this.messageSize];
            return;
        }
        int n = data.length;
        int n2 = this.messageSize - this.currentSize;
        boolean bl = false;
        int actualDataSize = Math.min(n, n2);
        System.arraycopy(data, 0, this.messageBuffer, this.currentSize, actualDataSize);
        UDPConnection uDPConnection = this;
        uDPConnection.currentSize += actualDataSize;
        if (this.currentSize == this.messageSize) {
            this.recvQueue.put(this.messageBuffer);
            this.currentSize = 0;
            this.messageSize = -1;
        }
    }
}

