/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.net;

import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.net.MessageHandler;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;

public abstract class Connection<T> {
    protected static final Logger log = Logger.get(Connection.class);
    private ReadOnlyBooleanWrapper isConnectedProperty = new ReadOnlyBooleanWrapper(true);
    private int connectionNum;
    private PropertyMap localSessionData = new PropertyMap();
    protected final List<MessageHandler<T>> messageHandlers = new CopyOnWriteArrayList<MessageHandler<T>>();
    protected final List<MessageHandler<T>> messageHandlersFX = new CopyOnWriteArrayList<MessageHandler<T>>();
    protected BlockingQueue<T> messageQueue = new ArrayBlockingQueue<T>(100);
    private boolean isJavaFXExceptionLogged = false;

    public Connection(int connectionNum) {
        this.connectionNum = connectionNum;
    }

    public final PropertyMap getLocalSessionData() {
        return this.localSessionData;
    }

    public final int getConnectionNum() {
        return this.connectionNum;
    }

    public final ReadOnlyBooleanProperty connectedProperty() {
        return this.isConnectedProperty.getReadOnlyProperty();
    }

    public final boolean isConnected() {
        return this.isConnectedProperty.getValue();
    }

    public final void addMessageHandler(MessageHandler<T> handler) {
        this.messageHandlers.add(handler);
    }

    public final void removeMessageHandler(MessageHandler<T> handler) {
        this.messageHandlers.remove(handler);
    }

    public final void addMessageHandlerFX(MessageHandler<T> handler) {
        this.messageHandlersFX.add(handler);
    }

    public final void removeMessageHandlerFX(MessageHandler<T> handler) {
        this.messageHandlersFX.remove(handler);
    }

    public final void send(T message) {
        if (!this.isConnected()) {
            log.warning("Attempted to send but connection is not connected");
            return;
        }
        try {
            this.messageQueue.put(message);
        }
        catch (InterruptedException e) {
            log.warning("send() was interrupted while waiting for messageQueue to clear some space", (Throwable)e);
        }
    }

    void notifyMessageReceived(T message) {
        try {
            this.messageHandlers.forEach(h -> h.onReceive(this, message));
            try {
                Platform.runLater(() -> this.messageHandlersFX.forEach(h -> h.onReceive(this, message)));
            }
            catch (IllegalStateException e) {
                if (!this.isJavaFXExceptionLogged) {
                    log.warning("JavaFX is not initialized to handle messages on FX thread", (Throwable)e);
                    this.isJavaFXExceptionLogged = true;
                }
            }
        }
        catch (Exception e) {
            log.warning("Exception during MessageHandler.onReceive()", (Throwable)e);
        }
    }

    public final void terminate() {
        if (!this.isConnected()) {
            log.warning("Attempted to close connection " + this.connectionNum + " but it is already closed.");
            return;
        }
        log.debug("Closing connection " + this.connectionNum);
        try {
            this.terminateImpl();
            log.debug("Connection " + this.connectionNum + " was correctly closed from local endpoint.");
        }
        catch (Exception e) {
            log.warning("Error during terminateImpl()", (Throwable)e);
        }
        this.isConnectedProperty.set(false);
    }

    protected abstract boolean isClosedLocally();

    protected abstract void terminateImpl() throws Exception;
}

