/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.net.tcp;

import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.net.Client;
import com.almasb.fxgl.net.Connection;
import java.net.Socket;

public class TCPClient<T>
extends Client<T> {
    private static final Logger log = Logger.get(TCPClient.class);
    private String ip;
    private int port;
    private Class<T> messageType;

    public TCPClient(String ip, int port, Class<T> messageType) {
        this.ip = ip;
        this.port = port;
        this.messageType = messageType;
    }

    @Override
    public void connect() {
        Socket socket;
        log.debug("Connecting to " + this.ip + ":" + this.port + " type: " + String.valueOf(this.messageType));
        try {
            socket = new Socket(this.ip, this.port);
            log.debug("Created socket to " + this.ip + ":" + this.port);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create a socket to address " + this.ip + " : " + this.port + " Error: " + String.valueOf(e), e);
        }
        try {
            this.openTCPConnection(socket, 1, this.messageType);
        }
        catch (Exception e) {
            this.disconnect();
            throw new RuntimeException("Failed to open TCP connection to " + this.ip + ":" + this.port + " Error: " + String.valueOf(e), e);
        }
    }

    @Override
    public void disconnect() {
        this.getConnections().forEach(Connection::terminate);
    }
}

