/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.net.udp;

import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.net.Connection;
import com.almasb.fxgl.net.Server;
import com.almasb.fxgl.net.UDPServerConfig;
import com.almasb.fxgl.net.udp.UDPClientKt;
import com.almasb.fxgl.net.udp.UDPConnection;
import java.io.Closeable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0011H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/almasb/fxgl/net/udp/UDPServer;", "T", "Lcom/almasb/fxgl/net/Server;", "port", "", "config", "Lcom/almasb/fxgl/net/UDPServerConfig;", "(ILcom/almasb/fxgl/net/UDPServerConfig;)V", "isStopped", "", "log", "Lcom/almasb/fxgl/logging/Logger;", "getPort", "()I", "serverSocket", "Ljava/net/DatagramSocket;", "start", "", "stop", "fxgl-io"})
@SourceDebugExtension(value={"SMAP\nUDPServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UDPServer.kt\ncom/almasb/fxgl/net/udp/UDPServer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1549#2:110\n1620#2,3:111\n1855#2,2:115\n1#3:114\n*S KotlinDebug\n*F\n+ 1 UDPServer.kt\ncom/almasb/fxgl/net/udp/UDPServer\n*L\n55#1:110\n55#1:111,3\n99#1:115,2\n*E\n"})
public final class UDPServer<T>
extends Server<T> {
    private final int port;
    @NotNull
    private final UDPServerConfig<T> config;
    @NotNull
    private final Logger log;
    private boolean isStopped;
    @Nullable
    private DatagramSocket serverSocket;

    public UDPServer(int port, @NotNull UDPServerConfig<T> config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        this.port = port;
        this.config = config;
        this.log = Logger.Companion.get(this.getClass());
    }

    public final int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void start() {
        block13: {
            this.log.debug("Starting to listen at: " + this.port + " type: " + this.config.getMessageType());
            try {
                Closeable closeable = new DatagramSocket(this.port);
                Throwable throwable = null;
                try {
                    DatagramSocket it = (DatagramSocket)closeable;
                    boolean bl = false;
                    this.serverSocket = it;
                    this.onStartedListening();
                    int connectionNum = 1;
                    byte[] buffer = new byte[this.config.getBufferSize()];
                    while (!this.isStopped) {
                        boolean isClosingPacket;
                        Object v1;
                        int remotePort;
                        String remoteIP;
                        DatagramPacket packet;
                        block12: {
                            void $this$mapTo$iv$iv;
                            Arrays.fill(buffer, (byte)0);
                            packet = new DatagramPacket(buffer, buffer.length);
                            it.receive(packet);
                            remoteIP = packet.getAddress().getHostAddress();
                            remotePort = packet.getPort();
                            String fullIP = remoteIP + remotePort;
                            List list = this.getConnections();
                            Intrinsics.checkNotNullExpressionValue(list, (String)"connections");
                            Iterable $this$map$iv = list;
                            boolean $i$f$map22 = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                void it2;
                                Connection connection = (Connection)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl2 = false;
                                Intrinsics.checkNotNull((Object)it2, (String)"null cannot be cast to non-null type com.almasb.fxgl.net.udp.UDPConnection<@[FlexibleNullability] T of com.almasb.fxgl.net.udp.UDPServer.start$lambda$2$lambda$0?>");
                                collection.add((UDPConnection)it2);
                            }
                            Iterable $i$f$map22 = (List)destination$iv$iv;
                            for (Object e : $i$f$map22) {
                                UDPConnection it3 = (UDPConnection)e;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual((Object)it3.getFullIP(), (Object)fullIP)) continue;
                                v1 = e;
                                break block12;
                            }
                            v1 = null;
                        }
                        UDPConnection connection = v1;
                        boolean isOpeningPacket = Arrays.equals(Arrays.copyOfRange(packet.getData(), 0, UDPClientKt.getMESSAGE_OPEN().length), UDPClientKt.getMESSAGE_OPEN());
                        if (connection == null || isOpeningPacket) {
                            Intrinsics.checkNotNullExpressionValue((Object)remoteIP, (String)"remoteIP");
                            connection = new UDPConnection(it, remoteIP, remotePort, this.config.getBufferSize(), connectionNum++);
                            this.openUDPConnection(connection, this.config.getMessageType());
                        }
                        if (isClosingPacket = Arrays.equals(Arrays.copyOfRange(packet.getData(), 0, UDPClientKt.getMESSAGE_CLOSE().length), UDPClientKt.getMESSAGE_CLOSE())) {
                            this.onConnectionClosed(connection);
                        }
                        if (isOpeningPacket || isClosingPacket) continue;
                        byte[] byArray = packet.getData();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"packet.data");
                        connection.receive$fxgl_io(byArray);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                if (this.isStopped) break block13;
                throw new RuntimeException("Failed to start: " + e.getMessage(), e);
            }
        }
        this.onStoppedListening();
    }

    @Override
    public void stop() {
        if (this.isStopped) {
            this.log.warning("Attempted to stop a server that is already stopped");
            return;
        }
        this.isStopped = true;
        List list = this.getConnections();
        Intrinsics.checkNotNullExpressionValue(list, (String)"connections");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Connection it = (Connection)element$iv;
            boolean bl = false;
            it.terminate();
        }
        try {
            DatagramSocket datagramSocket = this.serverSocket;
            if (datagramSocket != null) {
                datagramSocket.close();
            }
        }
        catch (Exception e) {
            this.log.warning("Exception when closing server socket: " + e.getMessage(), (Throwable)e);
        }
    }
}

