/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.notification.impl;

import com.almasb.fxgl.core.Inject;
import com.almasb.fxgl.core.reflect.ReflectionUtils;
import com.almasb.fxgl.notification.Notification;
import com.almasb.fxgl.notification.NotificationService;
import com.almasb.fxgl.notification.view.NotificationView;
import com.almasb.fxgl.scene.SceneService;
import com.almasb.fxgl.time.Timer;
import java.util.ArrayDeque;
import java.util.Collection;
import javafx.scene.Group;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020\u001bH\u0002J\b\u0010+\u001a\u00020(H\u0002J\u0010\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020(2\u0006\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020(H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR#\u0010\r\u001a\n \u0005*\u0004\u0018\u00010\u000e0\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u00148\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\n\"\u0004\b\"\u0010\fR\u0014\u0010#\u001a\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u00063"}, d2={"Lcom/almasb/fxgl/notification/impl/NotificationServiceProvider;", "Lcom/almasb/fxgl/notification/NotificationService;", "()V", "ANIMATION_DURATION", "Ljavafx/util/Duration;", "kotlin.jvm.PlatformType", "NOTIFICATION_DURATION", "backgroundColor", "Ljavafx/scene/paint/Color;", "getBackgroundColor", "()Ljavafx/scene/paint/Color;", "setBackgroundColor", "(Ljavafx/scene/paint/Color;)V", "notificationView", "Lcom/almasb/fxgl/notification/view/NotificationView;", "getNotificationView", "()Lcom/almasb/fxgl/notification/view/NotificationView;", "notificationView$delegate", "Lkotlin/Lazy;", "notificationViewClass", "Ljava/lang/Class;", "overlayRoot", "Ljavafx/scene/Group;", "getOverlayRoot", "()Ljavafx/scene/Group;", "queue", "Ljava/util/ArrayDeque;", "Lcom/almasb/fxgl/notification/Notification;", "sceneService", "Lcom/almasb/fxgl/scene/SceneService;", "showing", "", "textColor", "getTextColor", "setTextColor", "timer", "Lcom/almasb/fxgl/time/Timer;", "getTimer", "()Lcom/almasb/fxgl/time/Timer;", "checkLastPop", "", "fireAndScheduleNextNotification", "notification", "nextNotification", "onUpdate", "tpf", "", "pushNotification", "message", "", "showFirstNotification", "fxgl-scene"})
public final class NotificationServiceProvider
extends NotificationService {
    private final Duration ANIMATION_DURATION = Duration.seconds((double)1.0);
    private final Duration NOTIFICATION_DURATION = Duration.seconds((double)3.0);
    @NotNull
    private Color backgroundColor;
    @NotNull
    private Color textColor;
    @NotNull
    private final ArrayDeque<Notification> queue;
    private boolean showing;
    private SceneService sceneService;
    @Inject(value="notificationViewClass")
    private Class<? extends NotificationView> notificationViewClass;
    @NotNull
    private final Lazy notificationView$delegate;

    public NotificationServiceProvider() {
        Color color = Color.BLACK;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"BLACK");
        this.backgroundColor = color;
        color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"WHITE");
        this.textColor = color;
        this.queue = new ArrayDeque();
        this.notificationView$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NotificationView>(this){
            final /* synthetic */ NotificationServiceProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final NotificationView invoke() {
                Object object = NotificationServiceProvider.access$getNotificationViewClass$p(this.this$0);
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"notificationViewClass");
                    throw null;
                }
                object = ReflectionUtils.newInstance((Class)object);
                NotificationServiceProvider notificationServiceProvider = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                NotificationView it = (NotificationView)((Object)object);
                boolean bl3 = false;
                SceneService sceneService = NotificationServiceProvider.access$getSceneService$p(notificationServiceProvider);
                if (sceneService == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"sceneService");
                    throw null;
                }
                it.setAppWidth((int)sceneService.getPrefWidth());
                sceneService = NotificationServiceProvider.access$getSceneService$p(notificationServiceProvider);
                if (sceneService == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"sceneService");
                    throw null;
                }
                it.setAppHeight((int)sceneService.getPrefHeight());
                return (NotificationView)((Object)object);
            }
        }));
    }

    @Override
    @NotNull
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public void setBackgroundColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.backgroundColor = color;
    }

    @Override
    @NotNull
    public Color getTextColor() {
        return this.textColor;
    }

    @Override
    public void setTextColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.textColor = color;
    }

    private final Group getOverlayRoot() {
        SceneService sceneService = this.sceneService;
        if (sceneService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sceneService");
            throw null;
        }
        return sceneService.getOverlayRoot();
    }

    private final Timer getTimer() {
        SceneService sceneService = this.sceneService;
        if (sceneService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sceneService");
            throw null;
        }
        return sceneService.getTimer();
    }

    private final NotificationView getNotificationView() {
        Lazy lazy = this.notificationView$delegate;
        boolean bl = false;
        return (NotificationView)((Object)lazy.getValue());
    }

    @Override
    public void pushNotification(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Notification notification = new Notification(message);
        this.queue.add(notification);
        if (!this.showing) {
            this.showFirstNotification();
        }
    }

    private final void nextNotification() {
        Collection collection = this.queue;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Notification n = this.queue.poll();
            NotificationView notificationView2 = this.getNotificationView();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"n");
            notificationView2.push(n);
            this.fireAndScheduleNextNotification(n);
        } else {
            this.getNotificationView().playOutAnimation();
            Timer timer = this.getTimer();
            Function0 function0 = (Function0)new Function0<Unit>(this){

                public final void invoke() {
                    NotificationServiceProvider.access$checkLastPop((NotificationServiceProvider)((Object)this.receiver));
                }
            };
            collection = this.ANIMATION_DURATION;
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"ANIMATION_DURATION");
            timer.runOnceAfter(function0, (Duration)collection);
        }
    }

    private final void checkLastPop() {
        if (this.queue.isEmpty()) {
            Group group = this.getOverlayRoot();
            Object object = group.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"overlayRoot.children");
            object = (Collection)object;
            NotificationView notificationView2 = this.getNotificationView();
            boolean bl = false;
            object.remove((Object)notificationView2);
            this.showing = false;
        } else {
            this.getNotificationView().playInAnimation();
            Timer timer = this.getTimer();
            Function0 function0 = (Function0)new Function0<Unit>(this){

                public final void invoke() {
                    NotificationServiceProvider.access$nextNotification((NotificationServiceProvider)((Object)this.receiver));
                }
            };
            Duration duration = this.ANIMATION_DURATION;
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ANIMATION_DURATION");
            timer.runOnceAfter(function0, duration);
        }
    }

    private final void showFirstNotification() {
        this.showing = true;
        Group group = this.getOverlayRoot();
        Object object = group.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"overlayRoot.children");
        object = (Collection)object;
        NotificationView notificationView2 = this.getNotificationView();
        boolean bl = false;
        object.add(notificationView2);
        this.getNotificationView().playInAnimation();
        Timer timer = this.getTimer();
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                NotificationServiceProvider.access$nextNotification((NotificationServiceProvider)((Object)this.receiver));
            }
        };
        group = this.ANIMATION_DURATION;
        Intrinsics.checkNotNullExpressionValue((Object)group, (String)"ANIMATION_DURATION");
        timer.runOnceAfter(function0, (Duration)group);
    }

    private final void fireAndScheduleNextNotification(Notification notification) {
        Timer timer = this.getTimer();
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                NotificationServiceProvider.access$nextNotification((NotificationServiceProvider)((Object)this.receiver));
            }
        };
        Duration duration = this.NOTIFICATION_DURATION;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"NOTIFICATION_DURATION");
        timer.runOnceAfter(function0, duration);
    }

    public void onUpdate(double tpf) {
        this.getNotificationView().onUpdate(tpf);
    }

    public static final /* synthetic */ void access$checkLastPop(NotificationServiceProvider $this) {
        $this.checkLastPop();
    }

    public static final /* synthetic */ void access$nextNotification(NotificationServiceProvider $this) {
        $this.nextNotification();
    }

    public static final /* synthetic */ Class access$getNotificationViewClass$p(NotificationServiceProvider $this) {
        return $this.notificationViewClass;
    }

    public static final /* synthetic */ SceneService access$getSceneService$p(NotificationServiceProvider $this) {
        return $this.sceneService;
    }
}

