/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ui;

import com.almasb.fxgl.core.Inject;
import com.almasb.fxgl.core.util.EmptyRunnable;
import com.almasb.fxgl.localization.LocalizationService;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.ui.DialogFactoryService;
import com.almasb.fxgl.ui.UIFactoryService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JI\u0010\t\u001a\u00020\n\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00102\u0006\u0010\u0011\u001a\u0002H\u000b2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u000b0\u0013\"\u0002H\u000bH\u0016\u00a2\u0006\u0002\u0010\u0014J6\u0010\t\u001a\u00020\n\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00152\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0010H\u0016J\u001e\u0010\u0016\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0010H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000eH\u0002J9\u0010\u001b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u0013\"\u00020 H\u0016\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u000eH\u0016J\u0018\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u001eH\u0016J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010\"\u001a\u00020\n2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u001eH\u0016J\u001e\u0010&\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0016J,\u0010&\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000e0(2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0016J,\u0010)\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000e0(2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000eH\u0002J\u0010\u0010-\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010-\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u001eH\u0016J \u0010.\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010/\u001a\u0002002\u0006\u0010\u0017\u001a\u00020\u001eH\u0016J\u0018\u00101\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u001eH\u0016J\u0010\u00102\u001a\u00020\n2\u0006\u00103\u001a\u00020\u001dH\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/almasb/fxgl/ui/FXGLDialogFactoryServiceProvider;", "Lcom/almasb/fxgl/ui/DialogFactoryService;", "()V", "fontSizeScaleUI", "", "local", "Lcom/almasb/fxgl/localization/LocalizationService;", "uiFactory", "Lcom/almasb/fxgl/ui/UIFactoryService;", "choiceDialog", "Ljavafx/scene/layout/Pane;", "T", "", "message", "", "resultCallback", "Ljava/util/function/Consumer;", "firstOption", "options", "", "(Ljava/lang/String;Ljava/util/function/Consumer;Ljava/lang/Object;[Ljava/lang/Object;)Ljavafx/scene/layout/Pane;", "", "confirmationDialog", "callback", "", "createMessage", "Ljavafx/scene/text/Text;", "customDialog", "content", "Ljavafx/scene/Node;", "Ljava/lang/Runnable;", "buttons", "Ljavafx/scene/control/Button;", "(Ljava/lang/String;Ljavafx/scene/Node;Ljava/lang/Runnable;[Ljavafx/scene/control/Button;)Ljavafx/scene/layout/Pane;", "errorDialog", "errorMessage", "error", "", "inputDialog", "filter", "Ljava/util/function/Predicate;", "inputDialogWithCancel", "localizedStringProperty", "Ljavafx/beans/binding/StringBinding;", "key", "messageDialog", "progressDialog", "observable", "Ljavafx/beans/property/ReadOnlyDoubleProperty;", "progressDialogIndeterminate", "wrap", "n", "fxgl-scene"})
@SourceDebugExtension(value={"SMAP\nFXGLDialogFactoryServiceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FXGLDialogFactoryServiceProvider.kt\ncom/almasb/fxgl/ui/FXGLDialogFactoryServiceProvider\n+ 2 Logger.kt\ncom/almasb/fxgl/logging/Logger$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,311:1\n157#2:312\n1855#3,2:313\n*S KotlinDebug\n*F\n+ 1 FXGLDialogFactoryServiceProvider.kt\ncom/almasb/fxgl/ui/FXGLDialogFactoryServiceProvider\n*L\n124#1:312\n131#1:313,2\n*E\n"})
public final class FXGLDialogFactoryServiceProvider
extends DialogFactoryService {
    @Inject(value="fontSizeScaleUI")
    private double fontSizeScaleUI = 1.0;
    private UIFactoryService uiFactory;
    private LocalizationService local;

    private final Pane wrap(Node n) {
        Node[] nodeArray = new Node[]{n};
        StackPane wrapper = new StackPane(nodeArray);
        wrapper.setMinWidth(600.0);
        wrapper.setPadding(new Insets(20.0));
        wrapper.getStyleClass().add((Object)"dialog-border");
        return (Pane)wrapper;
    }

    @Override
    @NotNull
    public Pane messageDialog(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.messageDialog(message, (Runnable)EmptyRunnable.INSTANCE);
    }

    @Override
    @NotNull
    public Pane messageDialog(@NotNull String message, @NotNull Runnable callback) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Text text = this.createMessage(message);
        UIFactoryService uIFactoryService = this.uiFactory;
        if (uIFactoryService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uiFactory");
            uIFactoryService = null;
        }
        Button btnOK = uIFactoryService.newButton(this.localizedStringProperty("dialog.ok"));
        btnOK.setOnAction(arg_0 -> FXGLDialogFactoryServiceProvider.messageDialog$lambda$0(callback, arg_0));
        Node[] nodeArray = new Node[]{(Node)text, (Node)btnOK};
        VBox vbox = new VBox(50.0, nodeArray);
        vbox.setAlignment(Pos.CENTER);
        return this.wrap((Node)vbox);
    }

    @Override
    @NotNull
    public Pane confirmationDialog(@NotNull String message, @NotNull Consumer<Boolean> callback) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Text text = this.createMessage(message);
        UIFactoryService uIFactoryService = this.uiFactory;
        if (uIFactoryService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uiFactory");
            uIFactoryService = null;
        }
        Button btnYes = uIFactoryService.newButton(this.localizedStringProperty("dialog.yes"));
        btnYes.setOnAction(arg_0 -> FXGLDialogFactoryServiceProvider.confirmationDialog$lambda$1(callback, arg_0));
        UIFactoryService uIFactoryService2 = this.uiFactory;
        if (uIFactoryService2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uiFactory");
            uIFactoryService2 = null;
        }
        Button btnNo = uIFactoryService2.newButton(this.localizedStringProperty("dialog.no"));
        btnNo.setOnAction(arg_0 -> FXGLDialogFactoryServiceProvider.confirmationDialog$lambda$2(callback, arg_0));
        Node[] nodeArray = new Node[]{(Node)btnYes, (Node)btnNo};
        HBox hbox = new HBox(nodeArray);
        hbox.setAlignment(Pos.CENTER);
        Node[] nodeArray2 = new Node[]{(Node)text, (Node)hbox};
        VBox vbox = new VBox(50.0, nodeArray2);
        vbox.setAlignment(Pos.CENTER);
        return this.wrap((Node)vbox);
    }

    @Override
    @NotNull
    public <T> Pane choiceDialog(@NotNull String message, @NotNull Consumer<T> resultCallback, @NotNull T firstOption, T ... options) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(resultCallback, (String)"resultCallback");
        Intrinsics.checkNotNullParameter(firstOption, (String)"firstOption");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        List choices = ArraysKt.toMutableList((Object[])options);
        choices.add(0, firstOption);
        return this.choiceDialog(message, choices, resultCallback);
    }

    @NotNull
    public <T> Pane choiceDialog(@NotNull String message, @NotNull List<? extends T> options, @NotNull Consumer<T> resultCallback) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter(resultCallback, (String)"resultCallback");
        Text text = this.createMessage(message);
        HBox hbox = new HBox();
        if (options.size() > 3) {
            UIFactoryService uIFactoryService = this.uiFactory;
            if (uIFactoryService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"uiFactory");
                uIFactoryService = null;
            }
            ChoiceBox choiceBox = uIFactoryService.newChoiceBox(FXCollections.observableArrayList((Collection)options));
            choiceBox.getSelectionModel().selectFirst();
            UIFactoryService uIFactoryService2 = this.uiFactory;
            if (uIFactoryService2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"uiFactory");
                uIFactoryService2 = null;
            }
            Button btn = uIFactoryService2.newButton("Select");
            btn.setOnAction(arg_0 -> FXGLDialogFactoryServiceProvider.choiceDialog$lambda$3(resultCallback, choiceBox, arg_0));
            ObservableList observableList = hbox.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"hbox.children");
            ((Collection)observableList).add(choiceBox);
            ObservableList observableList2 = hbox.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)observableList2, (String)"hbox.children");
            ((Collection)observableList2).add(btn);
        } else if (options.size() == 0) {
            Logger.Companion this_$iv = Logger.Companion;
            boolean $i$f$get = false;
            this_$iv.get(FXGLDialogFactoryServiceProvider.class).warning("choiceDialog() called with an empty options list");
            UIFactoryService uIFactoryService = this.uiFactory;
            if (uIFactoryService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"uiFactory");
                uIFactoryService = null;
            }
            Button btn = uIFactoryService.newButton("No options provided");
            ObservableList observableList = hbox.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"hbox.children");
            ((Collection)observableList).add(btn);
        } else {
            Iterable $this$forEach$iv = options;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object option = element$iv = iterator.next();
                boolean bl = false;
                UIFactoryService uIFactoryService = this.uiFactory;
                if (uIFactoryService == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"uiFactory");
                    uIFactoryService = null;
                }
                Button btn = uIFactoryService.newButton(option.toString());
                btn.setOnAction(arg_0 -> FXGLDialogFactoryServiceProvider.choiceDialog$lambda$5$lambda$4(resultCallback, option, arg_0));
                ObservableList observableList = hbox.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"hbox.children");
                ((Collection)observableList).add(btn);
            }
        }
        hbox.setAlignment(Pos.CENTER);
        Node[] nodeArray = new Node[]{(Node)text, (Node)hbox};
        VBox vbox = new VBox(50.0, nodeArray);
        vbox.setAlignment(Pos.CENTER);
        return this.wrap((Node)vbox);
    }

    @Override
    @NotNull
    public Pane inputDialog(@NotNull String message, @NotNull Consumer<String> callback) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        return this.inputDialog(message, FXGLDialogFactoryServiceProvider::inputDialog$lambda$6, callback);
    }

    @Override
    @NotNull
    public Pane inputDialog(@NotNull String message, @NotNull Predicate<String> filter, @NotNull Consumer<String> callback) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Text text = this.createMessage(message);
        TextField field = new TextField();
        field.setMaxWidth(Math.max(text.getLayoutBounds().getWidth(), 200.0));
        UIFactoryService uIFactoryService = this.uiFactory;
        if (uIFactoryService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uiFactory");
            uIFactoryService = null;
        }
        field.setFont(uIFactoryService.newFont(18.0));
        field.focusedProperty().addListener((arg_0, arg_1, arg_2) -> FXGLDialogFactoryServiceProvider.inputDialog$lambda$7((Function3)new Function3<ObservableValue<? extends Boolean>, Boolean, Boolean, Unit>(field){
            final /* synthetic */ TextField $field;
            {
                this.$field = $field;
                super(3);
            }

            public final void invoke(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean isFocused) {
                if (!isFocused.booleanValue() && this.$field.getScene() != null) {
                    this.$field.requestFocus();
                }
            }
        }, arg_0, arg_1, arg_2));
        field.sceneProperty().addListener((arg_0, arg_1, arg_2) -> FXGLDialogFactoryServiceProvider.inputDialog$lambda$8((Function3)new Function3<ObservableValue<? extends Scene>, Scene, Scene, Unit>(field){
            final /* synthetic */ TextField $field;
            {
                this.$field = $field;
                super(3);
            }

            public final void invoke(ObservableValue<? extends Scene> observableValue, Scene scene, Scene scene2) {
                if (scene2 != null) {
                    this.$field.requestFocus();
                }
            }
        }, arg_0, arg_1, arg_2));
        field.setOnAction(arg_0 -> FXGLDialogFactoryServiceProvider.inputDialog$lambda$9(field, filter, callback, arg_0));
        UIFactoryService uIFactoryService2 = this.uiFactory;
        if (uIFactoryService2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uiFactory");
            uIFactoryService2 = null;
        }
        Button btnOK = uIFactoryService2.newButton(this.localizedStringProperty("dialog.ok"));
        field.textProperty().addListener((arg_0, arg_1, arg_2) -> FXGLDialogFactoryServiceProvider.inputDialog$lambda$10((Function3)new Function3<ObservableValue<? extends String>, String, String, Unit>(btnOK, filter){
            final /* synthetic */ Button $btnOK;
            final /* synthetic */ Predicate<String> $filter;
            {
                this.$btnOK = $btnOK;
                this.$filter = $filter;
                super(3);
            }

            public final void invoke(ObservableValue<? extends String> observableValue, String string, String newInput) {
                Intrinsics.checkNotNullExpressionValue((Object)newInput, (String)"newInput");
                this.$btnOK.setDisable(((CharSequence)newInput).length() == 0 || !this.$filter.test(newInput));
            }
        }, arg_0, arg_1, arg_2));
        btnOK.setDisable(true);
        btnOK.setOnAction(arg_0 -> FXGLDialogFactoryServiceProvider.inputDialog$lambda$11(callback, field, arg_0));
        Node[] nodeArray = new Node[]{(Node)text, (Node)field, (Node)btnOK};
        VBox vbox = new VBox(50.0, nodeArray);
        vbox.setAlignment(Pos.CENTER);
        return this.wrap((Node)vbox);
    }

    @Override
    @NotNull
    public Pane inputDialogWithCancel(@NotNull String message, @NotNull Predicate<String> filter, @NotNull Consumer<String> callback) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Text text = this.createMessage(message);
        TextField field = new TextField();
        field.setMaxWidth(Math.max(text.getLayoutBounds().getWidth(), 200.0));
        UIFactoryService uIFactoryService = this.uiFactory;
        if (uIFactoryService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uiFactory");
            uIFactoryService = null;
        }
        field.setFont(uIFactoryService.newFont(18.0));
        UIFactoryService uIFactoryService2 = this.uiFactory;
        if (uIFactoryService2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uiFactory");
            uIFactoryService2 = null;
        }
        Button btnOK = uIFactoryService2.newButton(this.localizedStringProperty("dialog.ok"));
        field.textProperty().addListener((arg_0, arg_1, arg_2) -> FXGLDialogFactoryServiceProvider.inputDialogWithCancel$lambda$12((Function3)new Function3<ObservableValue<? extends String>, String, String, Unit>(btnOK, filter){
            final /* synthetic */ Button $btnOK;
            final /* synthetic */ Predicate<String> $filter;
            {
                this.$btnOK = $btnOK;
                this.$filter = $filter;
                super(3);
            }

            public final void invoke(ObservableValue<? extends String> observableValue, String string, String newInput) {
                Intrinsics.checkNotNullExpressionValue((Object)newInput, (String)"newInput");
                this.$btnOK.setDisable(((CharSequence)newInput).length() == 0 || !this.$filter.test(newInput));
            }
        }, arg_0, arg_1, arg_2));
        btnOK.setDisable(true);
        btnOK.setOnAction(arg_0 -> FXGLDialogFactoryServiceProvider.inputDialogWithCancel$lambda$13(callback, field, arg_0));
        UIFactoryService uIFactoryService3 = this.uiFactory;
        if (uIFactoryService3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uiFactory");
            uIFactoryService3 = null;
        }
        Button btnCancel = uIFactoryService3.newButton(this.localizedStringProperty("dialog.cancel"));
        btnCancel.setOnAction(arg_0 -> FXGLDialogFactoryServiceProvider.inputDialogWithCancel$lambda$14(callback, arg_0));
        Node[] nodeArray = new Node[]{(Node)btnOK, (Node)btnCancel};
        HBox hBox = new HBox(nodeArray);
        hBox.setAlignment(Pos.CENTER);
        Node[] nodeArray2 = new Node[]{(Node)text, (Node)field, (Node)hBox};
        VBox vbox = new VBox(50.0, nodeArray2);
        vbox.setAlignment(Pos.CENTER);
        return this.wrap((Node)vbox);
    }

    @Override
    @NotNull
    public Pane errorDialog(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        return this.errorDialog(error, (Runnable)EmptyRunnable.INSTANCE);
    }

    @Override
    @NotNull
    public Pane errorDialog(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        return this.errorDialog(errorMessage, (Runnable)EmptyRunnable.INSTANCE);
    }

    @Override
    @NotNull
    public Pane errorDialog(@NotNull String errorMessage, @NotNull Runnable callback) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        return this.errorDialog(new RuntimeException(errorMessage), callback);
    }

    @Override
    @NotNull
    public Pane errorDialog(@NotNull Throwable error, @NotNull Runnable callback) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        return this.messageDialog(error.toString(), callback);
    }

    @Override
    @NotNull
    public Pane progressDialog(@NotNull String message, @NotNull ReadOnlyDoubleProperty observable, @NotNull Runnable callback) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)observable, (String)"observable");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        ProgressBar progress = new ProgressBar();
        progress.setPrefSize(200.0, 50.0);
        progress.progressProperty().bind((ObservableValue)observable);
        Ref.ObjectRef listener = new Ref.ObjectRef();
        listener.element = (arg_0, arg_1, arg_2) -> FXGLDialogFactoryServiceProvider.progressDialog$lambda$15(progress, listener, callback, arg_0, arg_1, arg_2);
        progress.progressProperty().addListener((ChangeListener)listener.element);
        Text text = this.createMessage(message);
        Node[] nodeArray = new Node[]{(Node)text, (Node)progress};
        VBox vbox = new VBox(50.0, nodeArray);
        vbox.setAlignment(Pos.CENTER);
        return this.wrap((Node)vbox);
    }

    @Override
    @NotNull
    public Pane progressDialogIndeterminate(@NotNull String message, @NotNull Runnable callback) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        ProgressIndicator progress = new ProgressIndicator();
        progress.setPrefSize(200.0, 200.0);
        Button btn = new Button();
        btn.setVisible(false);
        Button[] buttonArray = new Button[]{btn};
        return this.customDialog(message, (Node)progress, callback, buttonArray);
    }

    @Override
    @NotNull
    public Pane customDialog(@NotNull String message, @NotNull Node content, @NotNull Runnable callback, Button ... buttons) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)buttons, (String)"buttons");
        int n = buttons.length;
        for (int i = 0; i < n; ++i) {
            Button btn = buttons[i];
            EventHandler handler = btn.getOnAction();
            btn.setOnAction(arg_0 -> FXGLDialogFactoryServiceProvider.customDialog$lambda$16(callback, handler, arg_0));
        }
        Text text = this.createMessage(message);
        HBox hbox = new HBox((Node[])Arrays.copyOf(buttons, buttons.length));
        hbox.setAlignment(Pos.CENTER);
        Node[] nodeArray = new Node[]{(Node)text, content, (Node)hbox};
        VBox vbox = new VBox(50.0, nodeArray);
        vbox.setAlignment(Pos.CENTER);
        return this.wrap((Node)vbox);
    }

    private final Text createMessage(String message) {
        UIFactoryService uIFactoryService = this.uiFactory;
        if (uIFactoryService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uiFactory");
            uIFactoryService = null;
        }
        Text text = uIFactoryService.newText(message, this.fontSizeScaleUI * 18.0);
        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"uiFactory.newText(message, fontSizeScaleUI * 18.0)");
        return text;
    }

    private final StringBinding localizedStringProperty(String key) {
        LocalizationService localizationService = this.local;
        if (localizationService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"local");
            localizationService = null;
        }
        return localizationService.localizedStringProperty(key);
    }

    private static final void messageDialog$lambda$0(Runnable $callback, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        $callback.run();
    }

    private static final void confirmationDialog$lambda$1(Consumer $callback, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        $callback.accept(true);
    }

    private static final void confirmationDialog$lambda$2(Consumer $callback, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        $callback.accept(false);
    }

    private static final void choiceDialog$lambda$3(Consumer $resultCallback, ChoiceBox $choiceBox, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$resultCallback, (String)"$resultCallback");
        $resultCallback.accept($choiceBox.getValue());
    }

    private static final void choiceDialog$lambda$5$lambda$4(Consumer $resultCallback, Object $option, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$resultCallback, (String)"$resultCallback");
        Intrinsics.checkNotNullParameter((Object)$option, (String)"$option");
        $resultCallback.accept($option);
    }

    private static final boolean inputDialog$lambda$6(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final void inputDialog$lambda$7(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void inputDialog$lambda$8(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void inputDialog$lambda$9(TextField $field, Predicate $filter, Consumer $callback, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$field, (String)"$field");
        Intrinsics.checkNotNullParameter((Object)$filter, (String)"$filter");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        String newInput = $field.getText();
        Intrinsics.checkNotNullExpressionValue((Object)newInput, (String)"newInput");
        if (((CharSequence)newInput).length() == 0 || !$filter.test(newInput)) {
            return;
        }
        $callback.accept(newInput);
    }

    private static final void inputDialog$lambda$10(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void inputDialog$lambda$11(Consumer $callback, TextField $field, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        Intrinsics.checkNotNullParameter((Object)$field, (String)"$field");
        $callback.accept($field.getText());
    }

    private static final void inputDialogWithCancel$lambda$12(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void inputDialogWithCancel$lambda$13(Consumer $callback, TextField $field, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        Intrinsics.checkNotNullParameter((Object)$field, (String)"$field");
        $callback.accept($field.getText());
    }

    private static final void inputDialogWithCancel$lambda$14(Consumer $callback, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        $callback.accept("");
    }

    private static final void progressDialog$lambda$15(ProgressBar $progress, Ref.ObjectRef $listener, Runnable $callback, ObservableValue observableValue, Number number, Number value) {
        Intrinsics.checkNotNullParameter((Object)$progress, (String)"$progress");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        if (value.doubleValue() >= 1.0) {
            $progress.progressProperty().unbind();
            $progress.progressProperty().removeListener((ChangeListener)$listener.element);
            $listener.element = null;
            $callback.run();
        }
    }

    private static final void customDialog$lambda$16(Runnable $callback, EventHandler $handler, ActionEvent e) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
            $callback.run();
            EventHandler eventHandler = $handler;
            if (eventHandler == null) break block0;
            eventHandler.handle((Event)e);
        }
    }
}

