/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ui.property;

import com.almasb.fxgl.core.collection.UpdatableObjectProperty;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.ui.property.PropertyViewFactory;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;

public class Vec2PropertyViewFactory
implements PropertyViewFactory<Vec2, HBox> {
    private boolean ignoreChangeView = false;
    private boolean ignoreChangeProperty = false;

    @Override
    public HBox makeView(ObjectProperty<Vec2> value) {
        TextField fieldX = new TextField();
        TextField fieldY = new TextField();
        HBox view = new HBox(new Node[]{fieldX, fieldY});
        value.addListener((obs, o, newValue) -> {
            if (this.ignoreChangeProperty) {
                return;
            }
            this.onPropertyChanged(value, view);
        });
        fieldX.textProperty().addListener((obs, o, x) -> {
            if (this.ignoreChangeView) {
                return;
            }
            this.onViewChanged(value, view);
        });
        fieldY.textProperty().addListener((obs, o, y) -> {
            if (this.ignoreChangeView) {
                return;
            }
            this.onViewChanged(value, view);
        });
        this.onPropertyChanged(value, view);
        return view;
    }

    @Override
    public void onPropertyChanged(ObjectProperty<Vec2> value, HBox view) {
        TextField fieldX = (TextField)view.getChildren().get(0);
        TextField fieldY = (TextField)view.getChildren().get(1);
        this.ignoreChangeView = true;
        fieldX.setText(Float.toString(((Vec2)value.getValue()).x));
        fieldY.setText(Float.toString(((Vec2)value.getValue()).y));
        this.ignoreChangeView = false;
    }

    @Override
    public void onViewChanged(ObjectProperty<Vec2> value, HBox view) {
        TextField fieldX = (TextField)view.getChildren().get(0);
        TextField fieldY = (TextField)view.getChildren().get(1);
        this.ignoreChangeProperty = true;
        ((Vec2)value.getValue()).x = Float.parseFloat(fieldX.getText());
        ((Vec2)value.getValue()).y = Float.parseFloat(fieldY.getText());
        ((UpdatableObjectProperty)value).forceUpdateListeners((Object)((Vec2)value.getValue()), (Object)((Vec2)value.getValue()));
        this.ignoreChangeProperty = false;
    }
}

