/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ui;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000bH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0002J\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/almasb/fxgl/ui/ErrorDialog;", "", "error", "", "(Ljava/lang/Throwable;)V", "dialog", "Ljavafx/scene/control/Dialog;", "Ljavafx/scene/control/ButtonType;", "getError", "()Ljava/lang/Throwable;", "makeErrorMessage", "", "makeErrorMessageArea", "Ljavafx/scene/control/TextArea;", "makeStackTrace", "makeStackTraceArea", "showAndWait", "", "fxgl-ui"})
public final class ErrorDialog {
    private final Dialog<ButtonType> dialog;
    @NotNull
    private final Throwable error;

    public final void showAndWait() {
        this.dialog.showAndWait();
    }

    private final TextArea makeErrorMessageArea() {
        TextArea textArea;
        TextArea $receiver = textArea = new TextArea(this.makeErrorMessage());
        boolean bl = false;
        $receiver.setEditable(false);
        return textArea;
    }

    private final String makeErrorMessage() {
        String name = null;
        String line = null;
        StackTraceElement[] stackTraceElementArray = this.error.getStackTrace();
        Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElementArray, (String)"error.stackTrace");
        StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
        if (stackTraceElementArray2.length == 0) {
            name = "Empty stack trace";
            line = "Empty stack trace";
        } else {
            Object[] objectArray = this.error.getStackTrace();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"error.stackTrace");
            StackTraceElement trace = (StackTraceElement)ArraysKt.first((Object[])objectArray);
            StringBuilder stringBuilder = new StringBuilder();
            StackTraceElement stackTraceElement = trace;
            Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement, (String)"trace");
            String string = stackTraceElement.getClassName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"trace.className");
            name = stringBuilder.append(StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null)).append(".").append(trace.getMethodName()).append("()").toString();
            String string2 = trace.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"trace.toString()");
            line = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)string2, (char)'(', null, (int)2, null), (char)')', null, (int)2, null);
        }
        return "Message:  " + this.error.getMessage() + '\n' + "Type:  " + this.error.getClass().getSimpleName() + '\n' + "Method:  " + name + '\n' + "Line:  " + line;
    }

    private final TextArea makeStackTraceArea() {
        Object v1;
        CharSequence $receiver$iv;
        TextArea textArea;
        TextArea $receiver = textArea = new TextArea(this.makeStackTrace());
        boolean bl = false;
        $receiver.setEditable(false);
        $receiver.setWrapText(true);
        String string = $receiver.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
        Iterable iterable = StringsKt.split$default((CharSequence)string, (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null);
        TextArea textArea2 = $receiver;
        Iterator iterator$iv = $receiver$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            String it = (String)maxElem$iv;
            boolean bl2 = false;
            int maxValue$iv = it.length();
            while (iterator$iv.hasNext()) {
                Object e$iv = iterator$iv.next();
                String it2 = (String)e$iv;
                $i$a$-maxBy-ErrorDialog$makeStackTraceArea$1$1 = false;
                int v$iv = it2.length();
                if (maxValue$iv >= v$iv) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            }
            v1 = maxElem$iv;
        }
        Object var12_16 = v1;
        String string2 = var12_16;
        double d = (double)(string2 != null ? string2.length() : 60) * 6.5;
        String string3 = $receiver.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"text");
        $receiver$iv = string3;
        double d2 = d;
        int count$iv = 0;
        CharSequence charSequence = $receiver$iv;
        for (int i = 0; i < charSequence.length(); ++i) {
            char element$iv;
            char it = element$iv = charSequence.charAt(i);
            boolean bl3 = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        int n = count$iv;
        textArea2.setPrefSize(d2, (double)(n + 1) * 20.0);
        GridPane.setVgrow((Node)((Node)$receiver), (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)((Node)$receiver), (Priority)Priority.ALWAYS);
        return textArea;
    }

    private final String makeStackTrace() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.error.printStackTrace(pw);
        pw.close();
        String string = sw.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sw.toString()");
        return string;
    }

    @NotNull
    public final Throwable getError() {
        return this.error;
    }

    public ErrorDialog(@NotNull Throwable error) {
        DialogPane dialogPane;
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        this.error = error;
        GridPane root = new GridPane();
        root.setVisible(false);
        root.add((Node)new Label("Exception stacktrace:"), 0, 0);
        root.add((Node)this.makeStackTraceArea(), 0, 1);
        this.dialog = new Dialog();
        this.dialog.setTitle("Error Reporter");
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        DialogPane dialogPane2 = dialogPane = this.dialog.getDialogPane();
        Intrinsics.checkExpressionValueIsNotNull((Object)dialogPane2, (String)"dialogPane");
        dialogPane2.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK});
        dialogPane.setContent((Node)this.makeErrorMessageArea());
        dialogPane.setExpandableContent((Node)root);
    }
}

