/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.notification.impl;

import com.almasb.fxgl.core.Inject;
import com.almasb.fxgl.core.reflect.ReflectionUtils;
import com.almasb.fxgl.notification.Notification;
import com.almasb.fxgl.notification.NotificationService;
import com.almasb.fxgl.notification.view.NotificationView;
import com.almasb.fxgl.scene.SceneService;
import com.almasb.fxgl.time.Timer;
import java.util.ArrayDeque;
import java.util.Collection;
import javafx.scene.Group;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020\u001bH\u0002J\b\u0010+\u001a\u00020(H\u0002J\u0010\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020(2\u0006\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020(H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR#\u0010\r\u001a\n \u0005*\u0004\u0018\u00010\u000e0\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u00148\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\n\"\u0004\b\"\u0010\fR\u0014\u0010#\u001a\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u00063"}, d2={"Lcom/almasb/fxgl/notification/impl/NotificationServiceProvider;", "Lcom/almasb/fxgl/notification/NotificationService;", "()V", "ANIMATION_DURATION", "Ljavafx/util/Duration;", "kotlin.jvm.PlatformType", "NOTIFICATION_DURATION", "backgroundColor", "Ljavafx/scene/paint/Color;", "getBackgroundColor", "()Ljavafx/scene/paint/Color;", "setBackgroundColor", "(Ljavafx/scene/paint/Color;)V", "notificationView", "Lcom/almasb/fxgl/notification/view/NotificationView;", "getNotificationView", "()Lcom/almasb/fxgl/notification/view/NotificationView;", "notificationView$delegate", "Lkotlin/Lazy;", "notificationViewClass", "Ljava/lang/Class;", "overlayRoot", "Ljavafx/scene/Group;", "getOverlayRoot", "()Ljavafx/scene/Group;", "queue", "Ljava/util/ArrayDeque;", "Lcom/almasb/fxgl/notification/Notification;", "sceneService", "Lcom/almasb/fxgl/scene/SceneService;", "showing", "", "textColor", "getTextColor", "setTextColor", "timer", "Lcom/almasb/fxgl/time/Timer;", "getTimer", "()Lcom/almasb/fxgl/time/Timer;", "checkLastPop", "", "fireAndScheduleNextNotification", "notification", "nextNotification", "onUpdate", "tpf", "", "pushNotification", "message", "", "showFirstNotification", "fxgl-ui"})
public final class NotificationServiceProvider
extends NotificationService {
    private final Duration ANIMATION_DURATION = Duration.seconds((double)1.0);
    private final Duration NOTIFICATION_DURATION = Duration.seconds((double)3.0);
    @NotNull
    private Color backgroundColor;
    @NotNull
    private Color textColor;
    private final ArrayDeque<Notification> queue;
    private boolean showing;
    private SceneService sceneService;
    @Inject(value="notificationViewClass")
    private Class<? extends NotificationView> notificationViewClass;
    private final Lazy notificationView$delegate;

    @Override
    @NotNull
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public void setBackgroundColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.backgroundColor = color;
    }

    @Override
    @NotNull
    public Color getTextColor() {
        return this.textColor;
    }

    @Override
    public void setTextColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.textColor = color;
    }

    private final Group getOverlayRoot() {
        SceneService sceneService = this.sceneService;
        if (sceneService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sceneService");
        }
        return sceneService.getOverlayRoot();
    }

    private final Timer getTimer() {
        SceneService sceneService = this.sceneService;
        if (sceneService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sceneService");
        }
        return sceneService.getTimer();
    }

    private final NotificationView getNotificationView() {
        Lazy lazy = this.notificationView$delegate;
        NotificationServiceProvider notificationServiceProvider = this;
        Object var3_3 = null;
        boolean bl = false;
        return (NotificationView)((Object)lazy.getValue());
    }

    @Override
    public void pushNotification(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Notification notification = new Notification(message);
        this.queue.add(notification);
        if (!this.showing) {
            this.showFirstNotification();
        }
    }

    private final void nextNotification() {
        Collection collection = this.queue;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Notification n = this.queue.poll();
            NotificationView notificationView2 = this.getNotificationView();
            Notification notification = n;
            Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"n");
            notificationView2.push(notification);
            this.fireAndScheduleNextNotification(n);
        } else {
            this.getNotificationView().playOutAnimation();
            Timer timer = this.getTimer();
            Function0 function0 = (Function0)new Function0<Unit>(this){

                public final void invoke() {
                    NotificationServiceProvider.access$checkLastPop((NotificationServiceProvider)((Object)this.receiver));
                }
            };
            Duration duration = this.ANIMATION_DURATION;
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ANIMATION_DURATION");
            timer.runOnceAfter(function0, duration);
        }
    }

    private final void checkLastPop() {
        if (this.queue.isEmpty()) {
            Collection collection = (Collection)this.getOverlayRoot().getChildren();
            NotificationView notificationView2 = this.getNotificationView();
            boolean bl = false;
            collection.remove((Object)notificationView2);
            this.showing = false;
        } else {
            this.getNotificationView().playInAnimation();
            Timer timer = this.getTimer();
            Function0 function0 = (Function0)new Function0<Unit>(this){

                public final void invoke() {
                    NotificationServiceProvider.access$nextNotification((NotificationServiceProvider)((Object)this.receiver));
                }
            };
            Duration duration = this.ANIMATION_DURATION;
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ANIMATION_DURATION");
            timer.runOnceAfter(function0, duration);
        }
    }

    private final void showFirstNotification() {
        this.showing = true;
        Collection collection = (Collection)this.getOverlayRoot().getChildren();
        NotificationView notificationView2 = this.getNotificationView();
        boolean bl = false;
        collection.add(notificationView2);
        this.getNotificationView().playInAnimation();
        Timer timer = this.getTimer();
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                NotificationServiceProvider.access$nextNotification((NotificationServiceProvider)((Object)this.receiver));
            }
        };
        Duration duration = this.ANIMATION_DURATION;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ANIMATION_DURATION");
        timer.runOnceAfter(function0, duration);
    }

    private final void fireAndScheduleNextNotification(Notification notification) {
        Timer timer = this.getTimer();
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                NotificationServiceProvider.access$nextNotification((NotificationServiceProvider)((Object)this.receiver));
            }
        };
        Duration duration = this.NOTIFICATION_DURATION;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"NOTIFICATION_DURATION");
        timer.runOnceAfter(function0, duration);
    }

    public void onUpdate(double tpf) {
        this.getNotificationView().onUpdate(tpf);
    }

    public NotificationServiceProvider() {
        Color color = Color.BLACK;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"Color.BLACK");
        this.backgroundColor = color;
        Color color2 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"Color.WHITE");
        this.textColor = color2;
        this.queue = new ArrayDeque();
        this.notificationView$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NotificationView>(this){
            final /* synthetic */ NotificationServiceProvider this$0;

            public final NotificationView invoke() {
                Object object = ReflectionUtils.newInstance((Class)NotificationServiceProvider.access$getNotificationViewClass$p(this.this$0));
                boolean bl = false;
                boolean bl2 = false;
                NotificationView it = (NotificationView)((Object)object);
                boolean bl3 = false;
                it.setAppWidth((int)NotificationServiceProvider.access$getSceneService$p(this.this$0).getPrefWidth());
                it.setAppHeight((int)NotificationServiceProvider.access$getSceneService$p(this.this$0).getPrefHeight());
                return (NotificationView)((Object)object);
            }
            {
                this.this$0 = notificationServiceProvider;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ void access$checkLastPop(NotificationServiceProvider $this) {
        $this.checkLastPop();
    }

    public static final /* synthetic */ void access$nextNotification(NotificationServiceProvider $this) {
        $this.nextNotification();
    }

    public static final /* synthetic */ Class access$getNotificationViewClass$p(NotificationServiceProvider $this) {
        Class<? extends NotificationView> clazz = $this.notificationViewClass;
        if (clazz == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"notificationViewClass");
        }
        return clazz;
    }

    public static final /* synthetic */ void access$setNotificationViewClass$p(NotificationServiceProvider $this, Class clazz) {
        $this.notificationViewClass = clazz;
    }

    public static final /* synthetic */ SceneService access$getSceneService$p(NotificationServiceProvider $this) {
        SceneService sceneService = $this.sceneService;
        if (sceneService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sceneService");
        }
        return sceneService;
    }

    public static final /* synthetic */ void access$setSceneService$p(NotificationServiceProvider $this, SceneService sceneService) {
        $this.sceneService = sceneService;
    }
}

