/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ui;

import com.almasb.fxgl.core.util.EmptyRunnable;
import com.almasb.fxgl.localization.LocalizationService;
import com.almasb.fxgl.ui.DialogFactoryService;
import com.almasb.fxgl.ui.FXGLDialogFactoryServiceProvider;
import com.almasb.fxgl.ui.UIFactoryService;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J9\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00132\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\"\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\nH\u0016J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\u0013H\u0016J\u001e\u0010\u001c\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0016J,\u0010\u001c\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0016J,\u0010\u001f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\nH\u0002J\u0010\u0010#\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010#\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0013H\u0016J \u0010$\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\u0013H\u0016J\u0018\u0010'\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0013H\u0016J\u0010\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/almasb/fxgl/ui/FXGLDialogFactoryServiceProvider;", "Lcom/almasb/fxgl/ui/DialogFactoryService;", "()V", "local", "Lcom/almasb/fxgl/localization/LocalizationService;", "uiFactory", "Lcom/almasb/fxgl/ui/UIFactoryService;", "confirmationDialog", "Ljavafx/scene/layout/Pane;", "message", "", "callback", "Ljava/util/function/Consumer;", "", "createMessage", "Ljavafx/scene/text/Text;", "customDialog", "content", "Ljavafx/scene/Node;", "Ljava/lang/Runnable;", "buttons", "", "Ljavafx/scene/control/Button;", "(Ljava/lang/String;Ljavafx/scene/Node;Ljava/lang/Runnable;[Ljavafx/scene/control/Button;)Ljavafx/scene/layout/Pane;", "errorDialog", "errorMessage", "error", "", "inputDialog", "filter", "Ljava/util/function/Predicate;", "inputDialogWithCancel", "localizedStringProperty", "Ljavafx/beans/binding/StringBinding;", "key", "messageDialog", "progressDialog", "observable", "Ljavafx/beans/property/DoubleProperty;", "progressDialogIndeterminate", "wrap", "n", "fxgl-ui"})
public final class FXGLDialogFactoryServiceProvider
extends DialogFactoryService {
    private UIFactoryService uiFactory;
    private LocalizationService local;

    private final Pane wrap(Node n) {
        StackPane wrapper = new StackPane(new Node[]{n});
        wrapper.setMinWidth(600.0);
        wrapper.setPadding(new Insets(20.0));
        wrapper.getStyleClass().add((Object)"dialog-border");
        return (Pane)wrapper;
    }

    @Override
    @NotNull
    public Pane messageDialog(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.messageDialog(message, (Runnable)EmptyRunnable.INSTANCE);
    }

    @Override
    @NotNull
    public Pane messageDialog(@NotNull String message, @NotNull Runnable callback) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Text text = this.createMessage(message);
        UIFactoryService uIFactoryService = this.uiFactory;
        if (uIFactoryService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uiFactory");
        }
        Button btnOK = uIFactoryService.newButton(this.localizedStringProperty("dialog.ok"));
        btnOK.setOnAction((EventHandler)new EventHandler<ActionEvent>(callback){
            final /* synthetic */ Runnable $callback;

            public final void handle(ActionEvent it) {
                this.$callback.run();
            }
            {
                this.$callback = runnable;
            }
        });
        VBox vbox = new VBox(50.0, new Node[]{(Node)text, (Node)btnOK});
        vbox.setAlignment(Pos.CENTER);
        return this.wrap((Node)vbox);
    }

    @Override
    @NotNull
    public Pane confirmationDialog(@NotNull String message, @NotNull Consumer<Boolean> callback) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Text text = this.createMessage(message);
        UIFactoryService uIFactoryService = this.uiFactory;
        if (uIFactoryService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uiFactory");
        }
        Button btnYes = uIFactoryService.newButton(this.localizedStringProperty("dialog.yes"));
        btnYes.setOnAction((EventHandler)new EventHandler<ActionEvent>(callback){
            final /* synthetic */ Consumer $callback;

            public final void handle(ActionEvent it) {
                this.$callback.accept(true);
            }
            {
                this.$callback = consumer;
            }
        });
        UIFactoryService uIFactoryService2 = this.uiFactory;
        if (uIFactoryService2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uiFactory");
        }
        Button btnNo = uIFactoryService2.newButton(this.localizedStringProperty("dialog.no"));
        btnNo.setOnAction((EventHandler)new EventHandler<ActionEvent>(callback){
            final /* synthetic */ Consumer $callback;

            public final void handle(ActionEvent it) {
                this.$callback.accept(false);
            }
            {
                this.$callback = consumer;
            }
        });
        HBox hbox = new HBox(new Node[]{(Node)btnYes, (Node)btnNo});
        hbox.setAlignment(Pos.CENTER);
        VBox vbox = new VBox(50.0, new Node[]{(Node)text, (Node)hbox});
        vbox.setAlignment(Pos.CENTER);
        return this.wrap((Node)vbox);
    }

    @Override
    @NotNull
    public Pane inputDialog(@NotNull String message, @NotNull Consumer<String> callback) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        return this.inputDialog(message, inputDialog.1.INSTANCE, callback);
    }

    @Override
    @NotNull
    public Pane inputDialog(@NotNull String message, @NotNull Predicate<String> filter, @NotNull Consumer<String> callback) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Text text = this.createMessage(message);
        TextField field = new TextField();
        Bounds bounds = text.getLayoutBounds();
        Intrinsics.checkNotNullExpressionValue((Object)bounds, (String)"text.layoutBounds");
        field.setMaxWidth(Math.max(bounds.getWidth(), 200.0));
        UIFactoryService uIFactoryService = this.uiFactory;
        if (uIFactoryService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uiFactory");
        }
        field.setFont(uIFactoryService.newFont(18.0));
        field.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(field){
            final /* synthetic */ TextField $field;

            public final void changed(ObservableValue<? extends Boolean> $noName_0, Boolean $noName_1, Boolean isFocused) {
                if (!isFocused.booleanValue() && this.$field.getScene() != null) {
                    this.$field.requestFocus();
                }
            }
            {
                this.$field = textField;
            }
        });
        field.sceneProperty().addListener((ChangeListener)new ChangeListener<Scene>(field){
            final /* synthetic */ TextField $field;

            public final void changed(ObservableValue<? extends Scene> $noName_0, Scene $noName_1, Scene scene) {
                if (scene != null) {
                    this.$field.requestFocus();
                }
            }
            {
                this.$field = textField;
            }
        });
        field.setOnAction((EventHandler)new EventHandler<ActionEvent>(field, filter, callback){
            final /* synthetic */ TextField $field;
            final /* synthetic */ Predicate $filter;
            final /* synthetic */ Consumer $callback;

            public final void handle(ActionEvent it) {
                String newInput;
                String string = newInput = this.$field.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newInput");
                CharSequence charSequence = string;
                boolean bl = false;
                if (charSequence.length() == 0 || !this.$filter.test(newInput)) {
                    return;
                }
                this.$callback.accept(newInput);
            }
            {
                this.$field = textField;
                this.$filter = predicate;
                this.$callback = consumer;
            }
        });
        UIFactoryService uIFactoryService2 = this.uiFactory;
        if (uIFactoryService2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uiFactory");
        }
        Button btnOK = uIFactoryService2.newButton(this.localizedStringProperty("dialog.ok"));
        field.textProperty().addListener((ChangeListener)new ChangeListener<String>(btnOK, filter){
            final /* synthetic */ Button $btnOK;
            final /* synthetic */ Predicate $filter;

            public final void changed(ObservableValue<? extends String> $noName_0, String $noName_1, String newInput) {
                Button button = this.$btnOK;
                Intrinsics.checkNotNullExpressionValue((Object)button, (String)"btnOK");
                String string = newInput;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newInput");
                CharSequence charSequence = string;
                boolean bl = false;
                button.setDisable(charSequence.length() == 0 || !this.$filter.test(newInput));
            }
            {
                this.$btnOK = button;
                this.$filter = predicate;
            }
        });
        Button button = btnOK;
        Intrinsics.checkNotNullExpressionValue((Object)button, (String)"btnOK");
        button.setDisable(true);
        btnOK.setOnAction((EventHandler)new EventHandler<ActionEvent>(callback, field){
            final /* synthetic */ Consumer $callback;
            final /* synthetic */ TextField $field;

            public final void handle(ActionEvent it) {
                this.$callback.accept(this.$field.getText());
            }
            {
                this.$callback = consumer;
                this.$field = textField;
            }
        });
        VBox vbox = new VBox(50.0, new Node[]{(Node)text, (Node)field, (Node)btnOK});
        vbox.setAlignment(Pos.CENTER);
        return this.wrap((Node)vbox);
    }

    @Override
    @NotNull
    public Pane inputDialogWithCancel(@NotNull String message, @NotNull Predicate<String> filter, @NotNull Consumer<String> callback) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Text text = this.createMessage(message);
        TextField field = new TextField();
        Bounds bounds = text.getLayoutBounds();
        Intrinsics.checkNotNullExpressionValue((Object)bounds, (String)"text.layoutBounds");
        field.setMaxWidth(Math.max(bounds.getWidth(), 200.0));
        UIFactoryService uIFactoryService = this.uiFactory;
        if (uIFactoryService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uiFactory");
        }
        field.setFont(uIFactoryService.newFont(18.0));
        UIFactoryService uIFactoryService2 = this.uiFactory;
        if (uIFactoryService2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uiFactory");
        }
        Button btnOK = uIFactoryService2.newButton(this.localizedStringProperty("dialog.ok"));
        field.textProperty().addListener((ChangeListener)new ChangeListener<String>(btnOK, filter){
            final /* synthetic */ Button $btnOK;
            final /* synthetic */ Predicate $filter;

            public final void changed(ObservableValue<? extends String> $noName_0, String $noName_1, String newInput) {
                Button button = this.$btnOK;
                Intrinsics.checkNotNullExpressionValue((Object)button, (String)"btnOK");
                String string = newInput;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newInput");
                CharSequence charSequence = string;
                boolean bl = false;
                button.setDisable(charSequence.length() == 0 || !this.$filter.test(newInput));
            }
            {
                this.$btnOK = button;
                this.$filter = predicate;
            }
        });
        Button button = btnOK;
        Intrinsics.checkNotNullExpressionValue((Object)button, (String)"btnOK");
        button.setDisable(true);
        btnOK.setOnAction((EventHandler)new EventHandler<ActionEvent>(callback, field){
            final /* synthetic */ Consumer $callback;
            final /* synthetic */ TextField $field;

            public final void handle(ActionEvent it) {
                this.$callback.accept(this.$field.getText());
            }
            {
                this.$callback = consumer;
                this.$field = textField;
            }
        });
        UIFactoryService uIFactoryService3 = this.uiFactory;
        if (uIFactoryService3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uiFactory");
        }
        Button btnCancel = uIFactoryService3.newButton(this.localizedStringProperty("dialog.cancel"));
        btnCancel.setOnAction((EventHandler)new EventHandler<ActionEvent>(callback){
            final /* synthetic */ Consumer $callback;

            public final void handle(ActionEvent it) {
                this.$callback.accept("");
            }
            {
                this.$callback = consumer;
            }
        });
        HBox hBox = new HBox(new Node[]{(Node)btnOK, (Node)btnCancel});
        hBox.setAlignment(Pos.CENTER);
        VBox vbox = new VBox(50.0, new Node[]{(Node)text, (Node)field, (Node)hBox});
        vbox.setAlignment(Pos.CENTER);
        return this.wrap((Node)vbox);
    }

    @Override
    @NotNull
    public Pane errorDialog(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        return this.errorDialog(error, (Runnable)EmptyRunnable.INSTANCE);
    }

    @Override
    @NotNull
    public Pane errorDialog(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        return this.errorDialog(errorMessage, (Runnable)EmptyRunnable.INSTANCE);
    }

    @Override
    @NotNull
    public Pane errorDialog(@NotNull String errorMessage, @NotNull Runnable callback) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        return this.messageDialog("Error occurred: " + errorMessage, callback);
    }

    @Override
    @NotNull
    public Pane errorDialog(@NotNull Throwable error, @NotNull Runnable callback) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Text text = this.createMessage(error.toString());
        UIFactoryService uIFactoryService = this.uiFactory;
        if (uIFactoryService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uiFactory");
        }
        Button btnOK = uIFactoryService.newButton(this.localizedStringProperty("dialog.ok"));
        btnOK.setOnAction((EventHandler)new EventHandler<ActionEvent>(callback){
            final /* synthetic */ Runnable $callback;

            public final void handle(ActionEvent it) {
                this.$callback.run();
            }
            {
                this.$callback = runnable;
            }
        });
        UIFactoryService uIFactoryService2 = this.uiFactory;
        if (uIFactoryService2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uiFactory");
        }
        Button btnLog = uIFactoryService2.newButton("LOG");
        btnLog.setOnAction((EventHandler)new EventHandler<ActionEvent>(callback){
            final /* synthetic */ Runnable $callback;

            public final void handle(ActionEvent it) {
                this.$callback.run();
            }
            {
                this.$callback = runnable;
            }
        });
        HBox hbox = new HBox(new Node[]{(Node)btnOK, (Node)btnLog});
        hbox.setAlignment(Pos.CENTER);
        VBox vbox = new VBox(50.0, new Node[]{(Node)text, (Node)hbox});
        vbox.setAlignment(Pos.CENTER);
        return this.wrap((Node)vbox);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Pane progressDialog(@NotNull String message, @NotNull DoubleProperty observable, @NotNull Runnable callback) {
        void listener;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)observable, (String)"observable");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        ProgressBar progress = new ProgressBar();
        progress.setPrefSize(200.0, 50.0);
        progress.progressProperty().bind((ObservableValue)observable);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        listener.element = (ChangeListener)new ChangeListener<Number>(progress, (Ref.ObjectRef)listener, callback){
            final /* synthetic */ ProgressBar $progress;
            final /* synthetic */ Ref.ObjectRef $listener;
            final /* synthetic */ Runnable $callback;

            public final void changed(ObservableValue<? extends Number> $noName_0, Number $noName_1, Number value) {
                if (value.doubleValue() >= 1.0) {
                    this.$progress.progressProperty().unbind();
                    this.$progress.progressProperty().removeListener((ChangeListener)this.$listener.element);
                    this.$listener.element = null;
                    this.$callback.run();
                }
            }
            {
                this.$progress = progressBar;
                this.$listener = objectRef;
                this.$callback = runnable;
            }
        };
        progress.progressProperty().addListener((ChangeListener)listener.element);
        Text text = this.createMessage(message);
        VBox vbox = new VBox(50.0, new Node[]{(Node)text, (Node)progress});
        vbox.setAlignment(Pos.CENTER);
        return this.wrap((Node)vbox);
    }

    @Override
    @NotNull
    public Pane progressDialogIndeterminate(@NotNull String message, @NotNull Runnable callback) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        ProgressIndicator progress = new ProgressIndicator();
        progress.setPrefSize(200.0, 200.0);
        Button btn = new Button();
        btn.setVisible(false);
        return this.customDialog(message, (Node)progress, callback, btn);
    }

    @Override
    @NotNull
    public Pane customDialog(@NotNull String message, @NotNull Node content, @NotNull Runnable callback, Button ... buttons) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)buttons, (String)"buttons");
        for (Button btn : buttons) {
            EventHandler handler = btn.getOnAction();
            btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(callback, handler){
                final /* synthetic */ Runnable $callback;
                final /* synthetic */ EventHandler $handler;

                public final void handle(ActionEvent e) {
                    block0: {
                        this.$callback.run();
                        EventHandler eventHandler = this.$handler;
                        if (eventHandler == null) break block0;
                        eventHandler.handle((Event)e);
                    }
                }
                {
                    this.$callback = runnable;
                    this.$handler = eventHandler;
                }
            });
        }
        Text text = this.createMessage(message);
        Node[] nodeArray = (Node[])buttons;
        HBox hbox = new HBox(Arrays.copyOf(nodeArray, nodeArray.length));
        hbox.setAlignment(Pos.CENTER);
        VBox vbox = new VBox(50.0, new Node[]{(Node)text, content, (Node)hbox});
        vbox.setAlignment(Pos.CENTER);
        return this.wrap((Node)vbox);
    }

    private final Text createMessage(String message) {
        UIFactoryService uIFactoryService = this.uiFactory;
        if (uIFactoryService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uiFactory");
        }
        Text text = uIFactoryService.newText(message);
        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"uiFactory.newText(message)");
        return text;
    }

    private final StringBinding localizedStringProperty(String key) {
        LocalizationService localizationService = this.local;
        if (localizationService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"local");
        }
        return localizationService.localizedStringProperty(key);
    }
}

