/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ui;

import com.almasb.fxgl.ui.FXGLTextFlow;
import com.almasb.fxgl.ui.FXGLUIConfig;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.transform.Transform;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001>B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010:\u001a\u00020\u0019H\u0002J\b\u0010;\u001a\u00020\u0019H\u0002J\b\u0010<\u001a\u00020=H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u000f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000eR\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\u001a@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\n #*\u0004\u0018\u00010\"0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\f\"\u0004\b%\u0010\u000eR\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00104\u001a\u0002032\u0006\u0010\t\u001a\u000203@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u000e\u00109\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/almasb/fxgl/ui/MDIWindow;", "Ljavafx/scene/layout/Region;", "()V", "RESIZE_BOTTOM", "", "RESIZE_LEFT", "RESIZE_RIGHT", "RESIZE_TOP", "animationFinished", "value", "canClose", "getCanClose", "()Z", "setCanClose", "(Z)V", "canMinimize", "getCanMinimize", "setCanMinimize", "canMove", "getCanMove", "setCanMove", "canResize", "getCanResize", "setCanResize", "closeButton", "Ljavafx/scene/Node;", "Ljavafx/scene/layout/Pane;", "contentPane", "getContentPane", "()Ljavafx/scene/layout/Pane;", "setContentPane", "(Ljavafx/scene/layout/Pane;)V", "dragging", "header", "Lcom/almasb/fxgl/ui/FXGLTextFlow;", "kotlin.jvm.PlatformType", "isMinimized", "setMinimized", "maxScale", "", "minScale", "minimizeButton", "mouseX", "mouseY", "nodeX", "nodeY", "prevHeight", "resizeMode", "Lcom/almasb/fxgl/ui/MDIWindow$ResizeMode;", "root", "scaleIncrement", "", "title", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "zoomable", "makeCloseButton", "makeMinimizeButton", "updateTitle", "", "ResizeMode", "fxgl-ui"})
public class MDIWindow
extends Region {
    private double mouseX;
    private double mouseY;
    private double nodeX;
    private double nodeY;
    private boolean dragging;
    private boolean zoomable = true;
    private double minScale = 0.1;
    private double maxScale = 10.0;
    private double scaleIncrement = 0.001;
    private ResizeMode resizeMode = ResizeMode.NONE;
    private boolean RESIZE_TOP;
    private boolean RESIZE_LEFT;
    private boolean RESIZE_BOTTOM;
    private boolean RESIZE_RIGHT;
    private double prevHeight;
    private final FXGLTextFlow header = FXGLUIConfig.getUIFactory().newTextFlow();
    private final Node minimizeButton = this.makeMinimizeButton();
    private final Node closeButton = this.makeCloseButton();
    private boolean animationFinished = true;
    private final Pane root = new Pane();
    @NotNull
    private Pane contentPane = (Pane)new StackPane();
    private boolean isMinimized;
    private boolean canResize = true;
    private boolean canMove = true;
    private boolean canMinimize = true;
    private boolean canClose = true;
    @NotNull
    private String title = "Title";

    private final Node makeMinimizeButton() {
        Pane pane = new Pane();
        pane.setTranslateY(1.0);
        double size = 20.0;
        double offset = 3.0;
        Line line1 = new Line(offset, size / (double)2 + 1.0, size, size / (double)2 + 1.0);
        Line line2 = new Line(size, offset, offset, size);
        line1.setStrokeWidth(2.0);
        line2.setStrokeWidth(2.0);
        ObjectBinding stroke = Bindings.when((ObservableBooleanValue)((ObservableBooleanValue)pane.hoverProperty())).then((Object)Color.BLUE).otherwise((Object)Color.WHITE);
        line1.strokeProperty().bind((ObservableValue)stroke);
        line2.strokeProperty().bind((ObservableValue)stroke);
        line2.setVisible(false);
        pane.getChildren().addAll((Object[])new Node[]{(Node)line1, (Node)line2});
        return (Node)pane;
    }

    private final Node makeCloseButton() {
        Pane pane = new Pane();
        pane.setTranslateY(1.0);
        double size = 22.0;
        double offset = 3.0;
        Line line1 = new Line(offset, offset, size, size);
        Line line2 = new Line(size, offset, offset, size);
        line1.setStrokeWidth(2.0);
        line2.setStrokeWidth(2.0);
        ObjectBinding stroke = Bindings.when((ObservableBooleanValue)((ObservableBooleanValue)pane.hoverProperty())).then((Object)Color.RED).otherwise((Object)Color.WHITE);
        line1.strokeProperty().bind((ObservableValue)stroke);
        line2.strokeProperty().bind((ObservableValue)stroke);
        pane.getChildren().addAll((Object[])new Node[]{(Node)line1, (Node)line2});
        return (Node)pane;
    }

    @NotNull
    public final Pane getContentPane() {
        return this.contentPane;
    }

    public final void setContentPane(@NotNull Pane value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.contentPane = value;
        this.root.getChildren().set(1, (Object)value);
        if (value.getWidth() < this.getWidth()) {
            this.setWidth(value.getWidth());
        }
    }

    public final boolean isMinimized() {
        return this.isMinimized;
    }

    public final void setMinimized(boolean bl) {
        this.isMinimized = bl;
    }

    public final boolean getCanResize() {
        return this.canResize;
    }

    public final void setCanResize(boolean bl) {
        this.canResize = bl;
    }

    public final boolean getCanMove() {
        return this.canMove;
    }

    public final void setCanMove(boolean bl) {
        this.canMove = bl;
    }

    public final boolean getCanMinimize() {
        return this.canMinimize;
    }

    public final void setCanMinimize(boolean value) {
        this.canMinimize = value;
        this.minimizeButton.setVisible(value);
    }

    public final boolean getCanClose() {
        return this.canClose;
    }

    public final void setCanClose(boolean value) {
        this.canClose = value;
        this.closeButton.setVisible(value);
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.title = value;
        this.updateTitle();
    }

    private final void updateTitle() {
        FXGLTextFlow fXGLTextFlow = this.header;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)fXGLTextFlow), (String)"header");
        fXGLTextFlow.getChildren().clear();
        Color color = Color.WHITE;
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"Color.WHITE");
        this.header.append(this.title, color);
    }

    public MDIWindow() {
        final MDIWindow control = this;
        if (this.canMove) {
            this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public final void handle(MouseEvent event) {
                    MDIWindow n = control;
                    double parentScaleX = ((Transform)n.getParent().localToSceneTransformProperty().getValue()).getMxx();
                    double parentScaleY = ((Transform)n.getParent().localToSceneTransformProperty().getValue()).getMyy();
                    MouseEvent mouseEvent = event;
                    Intrinsics.checkExpressionValueIsNotNull((Object)mouseEvent, (String)"event");
                    mouseX = mouseEvent.getSceneX();
                    mouseY = event.getSceneY();
                    nodeX = n.getLayoutX() * parentScaleX;
                    nodeY = n.getLayoutY() * parentScaleY;
                }
            });
            this.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

                public final void handle(MouseEvent event) {
                    MDIWindow n = control;
                    double parentScaleX = ((Transform)n.getParent().localToSceneTransformProperty().getValue()).getMxx();
                    double parentScaleY = ((Transform)n.getParent().localToSceneTransformProperty().getValue()).getMyy();
                    double scaleX = ((Transform)n.localToSceneTransformProperty().getValue()).getMxx();
                    double scaleY = ((Transform)n.localToSceneTransformProperty().getValue()).getMyy();
                    Bounds boundsInScene = control.localToScene(control.getBoundsInLocal());
                    double sceneX = boundsInScene.getMinX();
                    double sceneY = boundsInScene.getMinY();
                    MouseEvent mouseEvent = event;
                    Intrinsics.checkExpressionValueIsNotNull((Object)mouseEvent, (String)"event");
                    double offsetX = mouseEvent.getSceneX() - mouseX;
                    double offsetY = event.getSceneY() - mouseY;
                    if (resizeMode == ResizeMode.NONE && control.getCanMove()) {
                        MDIWindow mDIWindow = this;
                        mDIWindow.nodeX = mDIWindow.nodeX + offsetX;
                        MDIWindow mDIWindow2 = this;
                        mDIWindow2.nodeY = mDIWindow2.nodeY + offsetY;
                        double scaledX = nodeX * 1.0 / parentScaleX;
                        double scaledY = nodeY * 1.0 / parentScaleY;
                        double offsetForAllX = scaledX - n.getLayoutX();
                        double offsetForAllY = scaledY - n.getLayoutY();
                        n.setLayoutX(scaledX);
                        n.setLayoutY(scaledY);
                        dragging = true;
                    } else {
                        double newWidth;
                        double xDiff;
                        double newHeight;
                        double yDiff;
                        double insetOffset;
                        double width = n.getBoundsInLocal().getMaxX() - n.getBoundsInLocal().getMinX();
                        double height = n.getBoundsInLocal().getMaxY() - n.getBoundsInLocal().getMinY();
                        if (RESIZE_TOP) {
                            insetOffset = this.getInsets().getTop() / (double)2;
                            yDiff = sceneY / parentScaleY + insetOffset - event.getSceneY() / parentScaleY;
                            newHeight = control.getPrefHeight() + yDiff;
                            if (newHeight > control.minHeight(0.0)) {
                                control.setLayoutY(control.getLayoutY() - yDiff);
                                control.setPrefHeight(newHeight);
                            }
                        }
                        if (RESIZE_LEFT) {
                            insetOffset = this.getInsets().getLeft() / (double)2;
                            xDiff = sceneX / parentScaleX + insetOffset - event.getSceneX() / parentScaleX;
                            newWidth = control.getPrefWidth() + xDiff;
                            if (newWidth > Math.max(control.minWidth(0.0), control.getContentPane().minWidth(0.0))) {
                                control.setLayoutX(control.getLayoutX() - xDiff);
                                control.setPrefWidth(newWidth);
                            }
                        }
                        if (RESIZE_BOTTOM) {
                            insetOffset = this.getInsets().getBottom() / (double)2;
                            newHeight = yDiff = event.getSceneY() / parentScaleY - sceneY / parentScaleY - insetOffset;
                            if ((newHeight = Math.max(newHeight, control.minHeight(0.0))) < control.maxHeight(0.0)) {
                                control.setPrefHeight(newHeight);
                            }
                        }
                        if (RESIZE_RIGHT) {
                            insetOffset = this.getInsets().getRight() / (double)2;
                            newWidth = xDiff = event.getSceneX() / parentScaleX - sceneX / parentScaleY - insetOffset;
                            if ((newWidth = Math.max(newWidth, Math.max(control.getContentPane().minWidth(0.0), control.minWidth(0.0)))) < control.maxWidth(0.0)) {
                                control.setPrefWidth(newWidth);
                            }
                        }
                    }
                    mouseX = event.getSceneX();
                    mouseY = event.getSceneY();
                }
            });
            this.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                public final void handle(MouseEvent it) {
                    dragging = false;
                }
            });
            this.setOnMouseMoved((EventHandler)new EventHandler<MouseEvent>(){

                public final void handle(MouseEvent t) {
                    if (control.isMinimized() || !control.getCanResize()) {
                        RESIZE_TOP = false;
                        RESIZE_LEFT = false;
                        RESIZE_BOTTOM = false;
                        RESIZE_RIGHT = false;
                        resizeMode = ResizeMode.NONE;
                        return;
                    }
                    MDIWindow n = control;
                    double parentScaleX = ((Transform)n.getParent().localToSceneTransformProperty().getValue()).getMxx();
                    double parentScaleY = ((Transform)n.getParent().localToSceneTransformProperty().getValue()).getMyy();
                    double scaleX = ((Transform)n.localToSceneTransformProperty().getValue()).getMxx();
                    double scaleY = ((Transform)n.localToSceneTransformProperty().getValue()).getMyy();
                    double border = 5.0 * scaleX;
                    double d = n.getLayoutBounds().getMinX();
                    MouseEvent mouseEvent = t;
                    Intrinsics.checkExpressionValueIsNotNull((Object)mouseEvent, (String)"t");
                    double diffMinX = Math.abs(d - mouseEvent.getX() + this.getInsets().getLeft());
                    double diffMinY = Math.abs(n.getLayoutBounds().getMinY() - t.getY() + this.getInsets().getTop());
                    double diffMaxX = Math.abs(n.getLayoutBounds().getMaxX() - t.getX() - this.getInsets().getRight());
                    double diffMaxY = Math.abs(n.getLayoutBounds().getMaxY() - t.getY() - this.getInsets().getBottom());
                    boolean left = diffMinX * scaleX < Math.max(border, this.getInsets().getLeft() / (double)2 * scaleX);
                    boolean top = diffMinY * scaleY < Math.max(border, this.getInsets().getTop() / (double)2 * scaleY);
                    boolean right = diffMaxX * scaleX < Math.max(border, this.getInsets().getRight() / (double)2 * scaleX);
                    boolean bottom = diffMaxY * scaleY < Math.max(border, this.getInsets().getBottom() / (double)2 * scaleY);
                    RESIZE_TOP = false;
                    RESIZE_LEFT = false;
                    RESIZE_BOTTOM = false;
                    RESIZE_RIGHT = false;
                    if (left && !top && !bottom) {
                        n.setCursor(Cursor.W_RESIZE);
                        resizeMode = ResizeMode.LEFT;
                        RESIZE_LEFT = true;
                    } else if (left && top && !bottom) {
                        n.setCursor(Cursor.NW_RESIZE);
                        resizeMode = ResizeMode.TOP_LEFT;
                        RESIZE_LEFT = true;
                        RESIZE_TOP = true;
                    } else if (left && !top && bottom) {
                        n.setCursor(Cursor.SW_RESIZE);
                        resizeMode = ResizeMode.BOTTOM_LEFT;
                        RESIZE_LEFT = true;
                        RESIZE_BOTTOM = true;
                    } else if (right && !top && !bottom) {
                        n.setCursor(Cursor.E_RESIZE);
                        resizeMode = ResizeMode.RIGHT;
                        RESIZE_RIGHT = true;
                    } else if (right && top && !bottom) {
                        n.setCursor(Cursor.NE_RESIZE);
                        resizeMode = ResizeMode.TOP_RIGHT;
                        RESIZE_RIGHT = true;
                        RESIZE_TOP = true;
                    } else if (right && !top && bottom) {
                        n.setCursor(Cursor.SE_RESIZE);
                        resizeMode = ResizeMode.BOTTOM_RIGHT;
                        RESIZE_RIGHT = true;
                        RESIZE_BOTTOM = true;
                    } else if (top && !left && !right) {
                        n.setCursor(Cursor.N_RESIZE);
                        resizeMode = ResizeMode.TOP;
                        RESIZE_TOP = true;
                    } else if (bottom && !left && !right) {
                        n.setCursor(Cursor.S_RESIZE);
                        resizeMode = ResizeMode.BOTTOM;
                        RESIZE_BOTTOM = true;
                    } else {
                        n.setCursor(Cursor.DEFAULT);
                        resizeMode = ResizeMode.NONE;
                    }
                    control.autosize();
                }
            });
        }
        this.getChildren().add((Object)this.root);
        this.minimizeButton.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public final void handle(MouseEvent it) {
                if (!animationFinished) {
                    return;
                }
                this.setMinimized(!this.isMinimized());
                if (this.isMinimized()) {
                    this.getContentPane().setVisible(false);
                }
                if (control.getPrefHeight() > 0.0) {
                    prevHeight = control.getPrefHeight();
                }
                Timeline animation = new Timeline();
                animation.getKeyFrames().add((Object)new KeyFrame(Duration.seconds((double)0.25), new KeyValue[]{new KeyValue((WritableValue)control.prefHeightProperty(), (Object)(this.isMinimized() ? 0.0 : prevHeight))}));
                animation.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                    public final void handle(ActionEvent it) {
                        if (!this.isMinimized()) {
                            this.getContentPane().setVisible(true);
                        }
                        animationFinished = true;
                    }
                });
                animation.play();
                animationFinished = false;
            }
        });
        this.closeButton.setOnMouseClicked((EventHandler)6.INSTANCE);
        this.minimizeButton.setTranslateY(-20.0);
        this.closeButton.setTranslateY(-22.0);
        HBox box = new HBox(new Node[]{(Node)this.header});
        box.setTranslateY(-25.0);
        box.getStyleClass().add((Object)"window-titlebar");
        box.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.closeButton.translateXProperty().bind((ObservableValue)box.prefWidthProperty().subtract(27.0));
        this.minimizeButton.translateXProperty().bind((ObservableValue)box.prefWidthProperty().subtract(54.0));
        this.root.getChildren().add((Object)box);
        this.root.getChildren().add((Object)this.contentPane);
        this.root.getChildren().addAll((Object[])new Node[]{this.minimizeButton, this.closeButton});
        this.root.setLayoutY(25.0);
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLACK, null, null)}));
    }

    public static final /* synthetic */ boolean access$getDragging$p(MDIWindow $this) {
        return $this.dragging;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/almasb/fxgl/ui/MDIWindow$ResizeMode;", "", "(Ljava/lang/String;I)V", "NONE", "TOP", "LEFT", "BOTTOM", "RIGHT", "TOP_LEFT", "TOP_RIGHT", "BOTTOM_LEFT", "BOTTOM_RIGHT", "fxgl-ui"})
    public static final class ResizeMode
    extends Enum<ResizeMode> {
        public static final /* enum */ ResizeMode NONE;
        public static final /* enum */ ResizeMode TOP;
        public static final /* enum */ ResizeMode LEFT;
        public static final /* enum */ ResizeMode BOTTOM;
        public static final /* enum */ ResizeMode RIGHT;
        public static final /* enum */ ResizeMode TOP_LEFT;
        public static final /* enum */ ResizeMode TOP_RIGHT;
        public static final /* enum */ ResizeMode BOTTOM_LEFT;
        public static final /* enum */ ResizeMode BOTTOM_RIGHT;
        private static final /* synthetic */ ResizeMode[] $VALUES;

        static {
            ResizeMode[] resizeModeArray = new ResizeMode[9];
            ResizeMode[] resizeModeArray2 = resizeModeArray;
            resizeModeArray[0] = NONE = new ResizeMode();
            resizeModeArray[1] = TOP = new ResizeMode();
            resizeModeArray[2] = LEFT = new ResizeMode();
            resizeModeArray[3] = BOTTOM = new ResizeMode();
            resizeModeArray[4] = RIGHT = new ResizeMode();
            resizeModeArray[5] = TOP_LEFT = new ResizeMode();
            resizeModeArray[6] = TOP_RIGHT = new ResizeMode();
            resizeModeArray[7] = BOTTOM_LEFT = new ResizeMode();
            resizeModeArray[8] = BOTTOM_RIGHT = new ResizeMode();
            $VALUES = resizeModeArray;
        }

        public static ResizeMode[] values() {
            return (ResizeMode[])$VALUES.clone();
        }

        public static ResizeMode valueOf(String string) {
            return Enum.valueOf(ResizeMode.class, string);
        }
    }
}

