/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.algorithm;

import com.almasb.fxgl.algorithm.Grid;
import com.almasb.fxgl.algorithm.Tile;
import com.almasb.fxgl.algorithm.TileType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0018\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00070\u00120\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/almasb/fxgl/algorithm/MapGenerator;", "", "()V", "seed", "", "(J)V", "ATTRACT_RANGE", "", "rand", "Ljava/util/Random;", "getSeed", "()J", "create", "Lcom/almasb/fxgl/algorithm/Grid;", "width", "height", "pairs", "", "Lkotlin/Pair;", "Lcom/almasb/fxgl/algorithm/TileType;", "fxgl"})
public final class MapGenerator {
    private final Random rand;
    private final int ATTRACT_RANGE = 25;
    private final long seed;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Grid create(int width, int height, @NotNull List<? extends Pair<? extends TileType, Integer>> pairs) {
        void count;
        Iterable element$iv;
        Ref.IntRef $receiver$iv;
        Intrinsics.checkParameterIsNotNull(pairs, (String)"pairs");
        Grid grid = new Grid(width, height);
        Object[] objectArray = grid.getRows();
        for (int i = 0; i < ((void)$receiver$iv).length; ++i) {
            void $receiver$iv2;
            void element$iv2 = $receiver$iv[i];
            Grid.Row it = (Grid.Row)element$iv2;
            Object[] objectArray2 = it.getTiles();
            for (int j = 0; j < ((void)$receiver$iv2).length; ++j) {
                element$iv = $receiver$iv2[j];
                Tile it2 = (Tile)((Object)element$iv);
                it2.setType(TileType.WATER);
            }
        }
        $receiver$iv = new Ref.IntRef();
        $receiver$iv.element = ((Number)pairs.get(1).getSecond()).intValue();
        while (count.element > 0) {
            void $receiver$iv3;
            Collection destination$iv$iv;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv4;
            int x = this.rand.nextInt(width);
            int y = this.rand.nextInt(height);
            int startX = x - this.ATTRACT_RANGE;
            int startY = y - this.ATTRACT_RANGE;
            element$iv = (Iterable)RangesKt.until((int)startX, (int)(startX + 2 * this.ATTRACT_RANGE));
            void it2 = $receiver$iv4;
            Collection $i$a$1$forEach = new ArrayList();
            Iterator $i$f$forEach = $receiver$iv$iv.iterator();
            while ($i$f$forEach.hasNext()) {
                void destination$iv$iv2;
                void $receiver$iv$iv2;
                void $receiver$iv5;
                int element$iv$iv;
                int x1 = element$iv$iv = ((IntIterator)$i$f$forEach).nextInt();
                Iterable iterable = (Iterable)RangesKt.until((int)startY, (int)(startY + 2 * this.ATTRACT_RANGE));
                void var18_30 = $receiver$iv5;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv5, (int)10));
                Iterator iterator = $receiver$iv$iv2.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                    void var23_35 = destination$iv$iv2;
                    Pair pair = new Pair((Object)x1, (Object)((int)it));
                    var23_35.add(pair);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $receiver$iv4 = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv4;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Pair it = (Pair)element$iv$iv;
                int $receiver$iv5 = ((Number)it.getFirst()).intValue();
                if (!(0 <= $receiver$iv5 && $receiver$iv5 <= width - 1 && 0 <= ($receiver$iv5 = ((Number)it.getSecond()).intValue()) && $receiver$iv5 <= height - 1 && Intrinsics.areEqual((Object)((Object)grid.getTile(((Number)it.getFirst()).intValue(), ((Number)it.getSecond()).intValue()).getType()), (Object)((Object)TileType.EARTH)))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Pair point = (Pair)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (point != null) {
                x = ((Number)point.getFirst()).intValue() + this.rand.nextInt(3) - 1;
                y = ((Number)point.getSecond()).intValue() + this.rand.nextInt(3) - 1;
                while (!grid.isValid(x, y)) {
                    x = ((Number)point.getFirst()).intValue() + this.rand.nextInt(3) - 1;
                    y = ((Number)point.getSecond()).intValue() + this.rand.nextInt(3) - 1;
                }
            }
            Tile tile = grid.getTile(x, y);
            tile.setType(TileType.EARTH);
            $receiver$iv$iv = grid.getNeighbors(x, y);
            for (Object element$iv3 : $receiver$iv3) {
                Tile it = (Tile)element$iv3;
                it.setType(TileType.EARTH);
                int n = count.element;
                count.element = n + -1;
            }
            int n = count.element;
            count.element = n + -1;
        }
        return grid;
    }

    public final long getSeed() {
        return this.seed;
    }

    public MapGenerator(long seed) {
        this.seed = seed;
        this.rand = new Random(this.seed);
        this.ATTRACT_RANGE = 25;
    }

    public MapGenerator() {
        this(new Random().longs().findAny().getAsLong());
    }
}

