/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.devtools.controller.ColorAdjustController;
import com.almasb.fxgl.devtools.controller.DialogAddEntityController;
import com.almasb.fxgl.devtools.controller.DialogEditEntityController;
import com.almasb.fxgl.entity.component.MainViewComponent;
import com.almasb.fxgl.ui.InGameWindow;
import com.almasb.fxgl.ui.UI;
import com.almasb.fxgl.ui.UIController;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.layout.Pane;

public class DeveloperMenuBarController
implements UIController {
    private GameApplication app;
    @FXML
    private Menu menuCustom;
    private UI uiColorAdjust = null;

    public Menu getCustomMenu() {
        return this.menuCustom;
    }

    @Override
    public void init() {
        this.app = FXGL.getApp();
    }

    public void onPause() {
        this.app.pause();
    }

    public void onResume() {
        this.app.resume();
    }

    public void onExit() {
        this.app.getDisplay().showConfirmationBox("Exit?", yes -> {
            if (yes.booleanValue()) {
                this.app.exit();
            }
        });
    }

    public void openAddDialog() {
        UI ui = this.app.getAssetLoader().loadUI("dialog_add_entity.fxml", new DialogAddEntityController());
        InGameWindow window = new InGameWindow("Add Entity", InGameWindow.WindowDecor.ALL);
        window.setPrefSize(350.0, 300.0);
        window.setContentPane(new Pane(new Node[]{ui.getRoot()}));
        this.app.getGameScene().addUINode((Node)window);
    }

    public void openEditDialog() {
        UI ui = this.app.getAssetLoader().loadUI("dialog_edit_entity.fxml", new DialogEditEntityController());
        InGameWindow window = new InGameWindow("Edit Entity", InGameWindow.WindowDecor.ALL);
        window.setPrefSize(380.0, 450.0);
        window.setContentPane(new Pane(new Node[]{ui.getRoot()}));
        this.app.getGameScene().addUINode((Node)window);
    }

    public void openColorAdjustDialog() {
        if (this.uiColorAdjust == null) {
            this.uiColorAdjust = this.app.getAssetLoader().loadUI("dialog_color_adjust.fxml", new ColorAdjustController());
        }
        InGameWindow window = new InGameWindow("Color Adjust", InGameWindow.WindowDecor.ALL);
        window.setPrefSize(380.0, 450.0);
        window.setContentPane(new Pane(new Node[]{this.uiColorAdjust.getRoot()}));
        this.app.getGameScene().addUINode((Node)window);
    }

    public void onShowBBox(ActionEvent event) {
        CheckMenuItem item = (CheckMenuItem)event.getSource();
        FXGL.setProperty("dev.showbbox", item.isSelected());
        this.app.getGameWorld().getEntitiesByComponent(MainViewComponent.class).forEach(e -> ((MainViewComponent)e.getComponentUnsafe(MainViewComponent.class)).turnOnDebugBBox(item.isSelected()));
    }
}

