/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxeventbus.Subscriber;
import com.almasb.fxgl.app.ApplicationState;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.FXGLApplication;
import com.almasb.fxgl.app.InitAppTask;
import com.almasb.fxgl.app.InitEventHandlersTask;
import com.almasb.fxgl.app.InitProfilerTask;
import com.almasb.fxgl.app.InitScenesTask;
import com.almasb.fxgl.app.MenuEventHandler;
import com.almasb.fxgl.app.PreInitTask;
import com.almasb.fxgl.devtools.profiling.Profiler;
import com.almasb.fxgl.event.IntroFinishedEvent;
import com.almasb.fxgl.gameplay.GameWorld;
import com.almasb.fxgl.io.DataFile;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.logging.SystemLogger;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.scene.FXGLMenu;
import com.almasb.fxgl.scene.GameScene;
import com.almasb.fxgl.scene.IntroScene;
import com.almasb.fxgl.scene.LoadingScene;
import com.almasb.fxgl.scene.SceneFactory;
import com.almasb.fxgl.scene.menu.MenuEventListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.concurrent.Task;

public abstract class GameApplication
extends FXGLApplication {
    private Logger log = SystemLogger.INSTANCE;
    private ObjectProperty<ApplicationState> state = new SimpleObjectProperty((Object)ApplicationState.STARTUP);
    GameWorld gameWorld;
    PhysicsWorld physicsWorld;
    GameScene gameScene;
    IntroScene introScene;
    LoadingScene loadingScene;
    FXGLMenu mainMenuScene;
    FXGLMenu gameMenuScene;
    private MenuEventHandler menuHandler;
    Profiler profiler;
    private Subscriber introFinishedSubscriber;

    public GameApplication() {
        this.log.debug("Starting JavaFX");
    }

    public final ApplicationState getState() {
        return (ApplicationState)((Object)this.state.get());
    }

    void setState(ApplicationState appState) {
        this.log.debug("State: " + (Object)((Object)this.getState()) + " -> " + (Object)((Object)appState));
        this.state.set((Object)appState);
        switch (appState) {
            case INTRO: {
                this.getDisplay().setScene(this.introScene);
                this.introFinishedSubscriber = this.getEventBus().addEventHandler(IntroFinishedEvent.ANY, e -> this.onIntroFinished());
                this.introScene.startIntro();
                break;
            }
            case LOADING: {
                this.getDisplay().setScene(this.loadingScene);
                break;
            }
            case MAIN_MENU: {
                this.getDisplay().setScene(this.mainMenuScene);
                if (this.menuHandler.isProfileSelected()) break;
                this.menuHandler.showProfileDialog();
                break;
            }
            case GAME_MENU: {
                this.getDisplay().setScene(this.gameMenuScene);
                break;
            }
            case PLAYING: {
                this.getDisplay().setScene(this.getGameScene());
                break;
            }
            case PAUSED: {
                break;
            }
            default: {
                this.log.warning("Attempted to set illegal state: " + (Object)((Object)appState));
            }
        }
    }

    public final GameWorld getGameWorld() {
        return this.gameWorld;
    }

    public final PhysicsWorld getPhysicsWorld() {
        return this.physicsWorld;
    }

    public final GameScene getGameScene() {
        return this.gameScene;
    }

    protected SceneFactory initSceneFactory() {
        return new SceneFactory();
    }

    protected void initAchievements() {
    }

    protected abstract void initInput();

    protected void preInit() {
    }

    protected abstract void initAssets();

    protected DataFile saveState() {
        this.log.warning("Called saveState(), but it wasn't overridden!");
        throw new UnsupportedOperationException("Default implementation is not available");
    }

    protected void loadState(DataFile dataFile) {
        this.log.warning("Called loadState(), but it wasn't overridden!");
        throw new UnsupportedOperationException("Default implementation is not available");
    }

    protected abstract void initGame();

    protected abstract void initPhysics();

    protected abstract void initUI();

    protected abstract void onUpdate(double var1);

    protected void onPostUpdate(double tpf) {
    }

    public boolean isMenuOpen() {
        return this.getState() == ApplicationState.GAME_MENU || this.getState() == ApplicationState.MAIN_MENU;
    }

    public boolean isPaused() {
        return this.isMenuOpen() || this.getState() == ApplicationState.PAUSED;
    }

    private void onIntroFinished() {
        if (this.getSettings().isMenuEnabled()) {
            this.setState(ApplicationState.MAIN_MENU);
        } else {
            this.startNewGame();
        }
        if (this.introFinishedSubscriber != null) {
            this.introFinishedSubscriber.unsubscribe();
            this.introScene = null;
            this.introFinishedSubscriber = null;
        }
    }

    @Override
    void configureApp() {
        this.log = FXGL.getLogger(GameApplication.class);
        this.log.debug("Configuring GameApplication");
        long start2 = System.nanoTime();
        this.runTask(PreInitTask.class);
        this.runTask(InitScenesTask.class);
        this.runTask(InitEventHandlersTask.class);
        this.runTask(InitProfilerTask.class);
        if (this.getSettings().isIntroEnabled()) {
            this.setState(ApplicationState.INTRO);
        } else {
            this.onIntroFinished();
        }
        SystemLogger.INSTANCE.infof("Game configuration took:  %.3f sec", (double)(System.nanoTime() - start2) / 1.0E9);
    }

    private void initApp(Task<?> initTask) {
        this.log.debug("Initializing App");
        this.pause();
        this.reset();
        this.setState(ApplicationState.LOADING);
        this.loadingScene.bind(initTask);
        this.getExecutor().execute((Runnable)initTask);
    }

    protected void startNewGame() {
        this.log.debug("Starting new game");
        this.initApp(new InitAppTask(this));
    }

    protected void startLoadedGame(DataFile dataFile) {
        this.log.debug("Starting loaded game");
        this.initApp(new InitAppTask(this, dataFile));
    }

    public MenuEventListener getMenuListener() {
        if (!this.getSettings().isMenuEnabled()) {
            throw new IllegalStateException("Menus are not enabled");
        }
        if (this.menuHandler == null) {
            this.menuHandler = new MenuEventHandler(this);
        }
        return this.menuHandler;
    }
}

