/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.io.DataFile;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.logging.SystemLogger;
import javafx.concurrent.Task;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u000fH\u0014J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/almasb/fxgl/app/InitAppTask;", "Ljavafx/concurrent/Task;", "Ljava/lang/Void;", "app", "Lcom/almasb/fxgl/app/GameApplication;", "(Lcom/almasb/fxgl/app/GameApplication;)V", "dataFile", "Lcom/almasb/fxgl/io/DataFile;", "(Lcom/almasb/fxgl/app/GameApplication;Lcom/almasb/fxgl/io/DataFile;)V", "getApp", "()Lcom/almasb/fxgl/app/GameApplication;", "getDataFile", "()Lcom/almasb/fxgl/io/DataFile;", "call", "failed", "", "succeeded", "update", "message", "", "step", "", "Companion", "fxgl"})
public final class InitAppTask
extends Task<Void> {
    @NotNull
    private final GameApplication app;
    @NotNull
    private final DataFile dataFile;
    private static final Logger log;
    public static final Companion Companion;

    @Nullable
    protected Void call() {
        long start2 = System.nanoTime();
        this.update("Initializing Assets", 0);
        this.app.initAssets();
        this.update("Initializing Game", 1);
        if (this.dataFile == DataFile.Companion.getEMPTY()) {
            this.app.initGame();
        } else {
            this.app.loadState(this.dataFile);
        }
        this.update("Initializing Physics", 2);
        this.app.initPhysics();
        this.update("Initializing UI", 3);
        this.app.initUI();
        this.update("Initialization Complete", 4);
        SystemLogger.INSTANCE.infof("Game initialization took: %.3f sec", (double)(System.nanoTime() - start2) / 1.0E9);
        return null;
    }

    private final void update(String message, int step) {
        InitAppTask.Companion.getLog().debug(message);
        this.updateMessage(message);
        this.updateProgress(step, 4L);
    }

    protected void succeeded() {
        this.app.resume();
    }

    protected void failed() {
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread thread = Thread.currentThread();
        Throwable throwable = this.getException();
        if (throwable == null) {
            throwable = new RuntimeException("Initialization failed");
        }
        uncaughtExceptionHandler.uncaughtException(thread, throwable);
    }

    @NotNull
    public final GameApplication getApp() {
        return this.app;
    }

    @NotNull
    public final DataFile getDataFile() {
        return this.dataFile;
    }

    public InitAppTask(@NotNull GameApplication app, @NotNull DataFile dataFile) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)app), (String)"app");
        Intrinsics.checkParameterIsNotNull((Object)dataFile, (String)"dataFile");
        this.app = app;
        this.dataFile = dataFile;
    }

    public InitAppTask(@NotNull GameApplication app) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)app), (String)"app");
        this(app, DataFile.Companion.getEMPTY());
    }

    static {
        Companion = new Companion(null);
        log = FXGL.Companion.getLogger(InitAppTask.class);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/almasb/fxgl/app/InitAppTask$Companion;", "", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lcom/almasb/fxgl/logging/Logger;", "fxgl"})
    public static final class Companion {
        private final Logger getLog() {
            return log;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

