/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.ApplicationState;
import com.almasb.fxgl.app.FXGLListener;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.app.InitEventHandlersTask;
import com.almasb.fxgl.event.AchievementEvent;
import com.almasb.fxgl.event.DisplayEvent;
import com.almasb.fxgl.event.EventBus;
import com.almasb.fxgl.event.LoadEvent;
import com.almasb.fxgl.event.NotificationEvent;
import com.almasb.fxgl.event.SaveEvent;
import com.almasb.fxgl.gameplay.AchievementManager;
import com.almasb.fxgl.settings.UserProfile;
import com.almasb.fxgl.time.UpdateEvent;
import com.almasb.fxgl.time.UpdateEventListener;
import com.google.inject.Inject;
import javafx.animation.AnimationTimer;
import javafx.event.EventHandler;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/almasb/fxgl/app/InitEventHandlersTask;", "Ljava/lang/Runnable;", "app", "Lcom/almasb/fxgl/app/GameApplication;", "(Lcom/almasb/fxgl/app/GameApplication;)V", "run", "", "fxgl"})
public final class InitEventHandlersTask
implements Runnable {
    private final GameApplication app;

    @Override
    public void run() {
        EventBus bus = this.app.getEventBus();
        boolean isMac = StringsKt.contains$default((CharSequence)System.getProperty("os.name"), (CharSequence)"Mac", (boolean)false, (int)2, null);
        Font fpsFont = Font.font((String)(isMac ? "Monaco" : "Lucida Console"), (double)(isMac ? 18.0 : 20.0));
        this.app.getMasterTimer().addUpdateListener(this.app.getInput());
        this.app.getMasterTimer().addUpdateListener(this.app.getAudioPlayer());
        this.app.getMasterTimer().addUpdateListener(this.app.gameWorld);
        this.app.getMasterTimer().addUpdateListener(new UpdateEventListener(this, fpsFont){
            final /* synthetic */ InitEventHandlersTask this$0;
            final /* synthetic */ Font $fpsFont;

            public final void onUpdateEvent(UpdateEvent event) {
                InitEventHandlersTask.access$getApp$p(this.this$0).onUpdate(event.tpf());
                if (InitEventHandlersTask.access$getApp$p(this.this$0).getSettings().isProfilingEnabled()) {
                    GraphicsContext g = InitEventHandlersTask.access$getApp$p((InitEventHandlersTask)this.this$0).gameScene.getGraphicsContext();
                    g.setFont(this.$fpsFont);
                    g.setFill((Paint)Color.RED);
                    g.fillText(InitEventHandlersTask.access$getApp$p((InitEventHandlersTask)this.this$0).profiler.getInfo(), 0.0, InitEventHandlersTask.access$getApp$p(this.this$0).getHeight() - (double)120);
                }
            }
            {
                this.this$0 = initEventHandlersTask;
                this.$fpsFont = font;
            }
        });
        AnimationTimer postUpdateTimer2 = new AnimationTimer(this){
            final /* synthetic */ InitEventHandlersTask this$0;

            public void handle(long now) {
                InitEventHandlersTask.access$getApp$p(this.this$0).onPostUpdate(InitEventHandlersTask.access$getApp$p(this.this$0).getMasterTimer().tpf());
            }
            {
                this.this$0 = $outer;
            }
        };
        bus.addEventHandler(SaveEvent.ANY, (EventHandler)new EventHandler<SaveEvent>(this){
            final /* synthetic */ InitEventHandlersTask this$0;

            public final void handle(SaveEvent event) {
                InitEventHandlersTask.access$getApp$p(this.this$0).getInput().save(event.getProfile());
                InitEventHandlersTask.access$getApp$p(this.this$0).getDisplay().save(event.getProfile());
                InitEventHandlersTask.access$getApp$p(this.this$0).getAudioPlayer().save(event.getProfile());
                AchievementManager achievementManager = InitEventHandlersTask.access$getApp$p(this.this$0).getAchievementManager();
                UserProfile userProfile = event.getProfile();
                Intrinsics.checkExpressionValueIsNotNull((Object)userProfile, (String)"event.getProfile()");
                achievementManager.save(userProfile);
                InitEventHandlersTask.access$getApp$p(this.this$0).getMasterTimer().save(event.getProfile());
            }
            {
                this.this$0 = initEventHandlersTask;
            }
        });
        bus.addEventHandler(LoadEvent.ANY, (EventHandler)new EventHandler<LoadEvent>(this){
            final /* synthetic */ InitEventHandlersTask this$0;

            public final void handle(LoadEvent event) {
                InitEventHandlersTask.access$getApp$p(this.this$0).getInput().load(event.getProfile());
                InitEventHandlersTask.access$getApp$p(this.this$0).getDisplay().load(event.getProfile());
                InitEventHandlersTask.access$getApp$p(this.this$0).getAudioPlayer().load(event.getProfile());
                AchievementManager achievementManager = InitEventHandlersTask.access$getApp$p(this.this$0).getAchievementManager();
                UserProfile userProfile = event.getProfile();
                Intrinsics.checkExpressionValueIsNotNull((Object)userProfile, (String)"event.getProfile()");
                achievementManager.load(userProfile);
                if (Intrinsics.areEqual((Object)event.getEventType(), LoadEvent.RESTORE_SETTINGS) ^ true) {
                    InitEventHandlersTask.access$getApp$p(this.this$0).getMasterTimer().load(event.getProfile());
                }
            }
            {
                this.this$0 = initEventHandlersTask;
            }
        });
        this.app.addFXGLListener(this.app.getInput());
        this.app.addFXGLListener(this.app.getMasterTimer());
        this.app.addFXGLListener(new FXGLListener(this, postUpdateTimer2){
            final /* synthetic */ InitEventHandlersTask this$0;
            final /* synthetic */ run.postUpdateTimer.1 $postUpdateTimer;

            public void onPause() {
                this.$postUpdateTimer.stop();
                InitEventHandlersTask.access$getApp$p(this.this$0).setState(ApplicationState.PAUSED);
            }

            public void onResume() {
                this.$postUpdateTimer.start();
                InitEventHandlersTask.access$getApp$p(this.this$0).setState(ApplicationState.PLAYING);
            }

            public void onReset() {
                InitEventHandlersTask.access$getApp$p(this.this$0).getGameWorld().reset();
            }

            public void onExit() {
            }
            {
                this.this$0 = $outer;
                this.$postUpdateTimer = $captured_local_variable$1;
            }
        });
        this.app.getGameWorld().addWorldListener(this.app.getPhysicsWorld());
        this.app.getGameWorld().addWorldListener(this.app.getGameScene());
        this.app.getGameScene().addEventHandler(MouseEvent.ANY, (EventHandler)new EventHandler<MouseEvent>(this){
            final /* synthetic */ InitEventHandlersTask this$0;

            public final void handle(MouseEvent it) {
                InitEventHandlersTask.access$getApp$p(this.this$0).getInput().onMouseEvent(it, InitEventHandlersTask.access$getApp$p(this.this$0).getGameScene().getViewport(), InitEventHandlersTask.access$getApp$p(this.this$0).getDisplay().getScaleRatio());
            }
            {
                this.this$0 = initEventHandlersTask;
            }
        });
        this.app.getGameScene().addEventHandler(KeyEvent.ANY, (EventHandler)new EventHandler<KeyEvent>(this){
            final /* synthetic */ InitEventHandlersTask this$0;

            public final void handle(KeyEvent it) {
                InitEventHandlersTask.access$getApp$p(this.this$0).getInput().onKeyEvent(it);
            }
            {
                this.this$0 = initEventHandlersTask;
            }
        });
        bus.addEventHandler(NotificationEvent.ANY, (EventHandler)new EventHandler<NotificationEvent>(this){
            final /* synthetic */ InitEventHandlersTask this$0;

            public final void handle(NotificationEvent it) {
                InitEventHandlersTask.access$getApp$p(this.this$0).getAudioPlayer().onNotificationEvent(it);
            }
            {
                this.this$0 = initEventHandlersTask;
            }
        });
        bus.addEventHandler(AchievementEvent.ANY, (EventHandler)new EventHandler<AchievementEvent>(this){
            final /* synthetic */ InitEventHandlersTask this$0;

            public final void handle(AchievementEvent it) {
                InitEventHandlersTask.access$getApp$p(this.this$0).getNotificationService().onAchievementEvent(it);
            }
            {
                this.this$0 = initEventHandlersTask;
            }
        });
        bus.addEventHandler(DisplayEvent.CLOSE_REQUEST, (EventHandler)new EventHandler<DisplayEvent>(this){
            final /* synthetic */ InitEventHandlersTask this$0;

            public final void handle(DisplayEvent e) {
                InitEventHandlersTask.access$getApp$p(this.this$0).exit();
            }
            {
                this.this$0 = initEventHandlersTask;
            }
        });
        bus.addEventHandler(DisplayEvent.DIALOG_OPENED, (EventHandler)new EventHandler<DisplayEvent>(this){
            final /* synthetic */ InitEventHandlersTask this$0;

            public final void handle(DisplayEvent e) {
                if (InitEventHandlersTask.access$getApp$p(this.this$0).getState() == ApplicationState.INTRO || InitEventHandlersTask.access$getApp$p(this.this$0).getState() == ApplicationState.LOADING) {
                    return;
                }
                if (!InitEventHandlersTask.access$getApp$p(this.this$0).isMenuOpen()) {
                    InitEventHandlersTask.access$getApp$p(this.this$0).pause();
                }
                InitEventHandlersTask.access$getApp$p(this.this$0).getInput().onReset();
            }
            {
                this.this$0 = initEventHandlersTask;
            }
        });
        bus.addEventHandler(DisplayEvent.DIALOG_CLOSED, (EventHandler)new EventHandler<DisplayEvent>(this){
            final /* synthetic */ InitEventHandlersTask this$0;

            public final void handle(DisplayEvent e) {
                if (InitEventHandlersTask.access$getApp$p(this.this$0).getState() == ApplicationState.INTRO || InitEventHandlersTask.access$getApp$p(this.this$0).getState() == ApplicationState.LOADING) {
                    return;
                }
                if (!InitEventHandlersTask.access$getApp$p(this.this$0).isMenuOpen()) {
                    InitEventHandlersTask.access$getApp$p(this.this$0).resume();
                }
            }
            {
                this.this$0 = initEventHandlersTask;
            }
        });
        bus.scanForHandlers((Object)this.app);
    }

    @Inject
    public InitEventHandlersTask(@NotNull GameApplication app) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)app), (String)"app");
        this.app = app;
    }

    @NotNull
    public static final /* synthetic */ GameApplication access$getApp$p(InitEventHandlersTask $this) {
        return $this.app;
    }
}

