/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.concurrent;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.concurrent.Executor;
import com.almasb.fxgl.event.EventBus;
import com.almasb.fxgl.event.FXGLEvent;
import com.almasb.fxgl.logging.Logger;
import com.google.inject.Inject;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.event.EventHandler;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u000f\b\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/almasb/fxgl/concurrent/FXGLExecutor;", "Lcom/almasb/fxgl/concurrent/Executor;", "eventBus", "Lcom/almasb/fxgl/event/EventBus;", "(Lcom/almasb/fxgl/event/EventBus;)V", "log", "Lcom/almasb/fxgl/logging/Logger;", "kotlin.jvm.PlatformType", "schedulerService", "Ljava/util/concurrent/ScheduledExecutorService;", "service", "Ljava/util/concurrent/ExecutorService;", "execute", "", "task", "Ljava/lang/Runnable;", "schedule", "Ljava/util/concurrent/ScheduledFuture;", "action", "delay", "Ljavafx/util/Duration;", "FXGLThreadFactory", "fxgl"})
public final class FXGLExecutor
implements Executor {
    private final Logger log = FXGL.Companion.getLogger(this.getClass());
    private final ExecutorService service = Executors.newCachedThreadPool(FXGLThreadFactory.INSTANCE);
    private final ScheduledExecutorService schedulerService = Executors.newScheduledThreadPool(2);

    @Override
    public void execute(@NotNull Runnable task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        this.service.submit(task);
    }

    @Override
    @NotNull
    public ScheduledFuture<?> schedule(@NotNull Runnable action2, @NotNull Duration delay) {
        Intrinsics.checkParameterIsNotNull((Object)action2, (String)"action");
        Intrinsics.checkParameterIsNotNull((Object)delay, (String)"delay");
        ScheduledFuture<?> scheduledFuture = this.schedulerService.schedule(action2, (long)delay.toMillis(), TimeUnit.MILLISECONDS);
        Intrinsics.checkExpressionValueIsNotNull(scheduledFuture, (String)"schedulerService.schedul\u2026), TimeUnit.MILLISECONDS)");
        return scheduledFuture;
    }

    @Inject
    private FXGLExecutor(EventBus eventBus) {
        eventBus.addEventHandler(FXGLEvent.EXIT, (EventHandler)new EventHandler<FXGLEvent>(){

            public final void handle(FXGLEvent event) {
                service.shutdownNow();
                schedulerService.shutdownNow();
            }
        });
        this.log.debug(2.INSTANCE);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/almasb/fxgl/concurrent/FXGLExecutor$FXGLThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "()V", "group", "Ljava/lang/ThreadGroup;", "threadNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "fxgl"})
    private static final class FXGLThreadFactory
    implements ThreadFactory {
        private static final ThreadGroup group;
        private static final AtomicInteger threadNumber;
        public static final FXGLThreadFactory INSTANCE;

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
            Thread t = new Thread(group, r, "FXGL Background Thread " + threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }

        private FXGLThreadFactory() {
            ThreadGroup threadGroup;
            INSTANCE = this;
            threadNumber = new AtomicInteger(1);
            SecurityManager s = System.getSecurityManager();
            if (s != null) {
                ThreadGroup threadGroup2 = s.getThreadGroup();
                threadGroup = threadGroup2;
                Intrinsics.checkExpressionValueIsNotNull((Object)threadGroup2, (String)"s.threadGroup");
            } else {
                ThreadGroup threadGroup3 = Thread.currentThread().getThreadGroup();
                threadGroup = threadGroup3;
                Intrinsics.checkExpressionValueIsNotNull((Object)threadGroup3, (String)"Thread.currentThread().threadGroup");
            }
            group = threadGroup;
        }

        static {
            new FXGLThreadFactory();
        }
    }
}

