/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.effect;

import com.almasb.ents.AbstractControl;
import com.almasb.ents.Entity;
import com.almasb.ents.component.Required;
import com.almasb.fxgl.effect.Particle;
import com.almasb.fxgl.effect.ParticleEmitter;
import com.almasb.fxgl.entity.Entities;
import com.almasb.fxgl.entity.component.PositionComponent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.canvas.GraphicsContext;

@Required(value=PositionComponent.class)
public class ParticleControl
extends AbstractControl {
    private ParticleEmitter emitter;
    protected List<Particle> particles = new ArrayList<Particle>();
    private PositionComponent position;

    public ParticleControl(ParticleEmitter emitter) {
        this.emitter = emitter;
    }

    protected ParticleControl() {
    }

    public void onAdded(Entity entity) {
        this.position = Entities.getPosition(entity);
    }

    public void onUpdate(Entity entity, double tpf) {
        if (this.emitter == null) {
            return;
        }
        this.particles.addAll(this.emitter.emit(this.position.getX(), this.position.getY()));
        Iterator<Particle> it = this.particles.iterator();
        while (it.hasNext()) {
            Particle p = it.next();
            if (!p.update(tpf)) continue;
            it.remove();
        }
    }

    public void onRemoved(Entity entity) {
        this.particles.clear();
    }

    public void renderParticles(GraphicsContext g, Point2D viewportOrigin) {
        this.particles.forEach(p -> p.render(g, viewportOrigin));
    }
}

