/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.effect;

import com.almasb.fxgl.effect.Particle;
import com.almasb.fxgl.util.TriFunction;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.geometry.Point2D;
import javafx.scene.effect.BlendMode;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class ParticleEmitter {
    private static final List<Particle> EMPTY = Collections.emptyList();
    private Random random = new Random();
    private int numParticles = 25;
    private double emissionRate = 1.0;
    private double sizeMin = 9.0;
    private double sizeMax = 12.0;
    private Supplier<Paint> colorFunction = () -> Color.TRANSPARENT;
    private Supplier<Point2D> gravityFunction = () -> Point2D.ZERO;
    private TriFunction<Integer, Double, Double, Point2D> velocityFunction = (i, x, y) -> Point2D.ZERO;
    private TriFunction<Integer, Double, Double, Point2D> spawnPointFunction = (i, x, y) -> Point2D.ZERO;
    private TriFunction<Integer, Double, Double, Point2D> scaleFunction = (i, x, y) -> Point2D.ZERO;
    private TriFunction<Integer, Double, Double, Duration> expireFunction = (i, x, y) -> Duration.seconds((double)1.0);
    private TriFunction<Integer, Double, Double, BlendMode> blendFunction = (i, x, y) -> BlendMode.ADD;
    private Image sourceImage = null;
    private double rateAC = 1.0;

    public final double getSizeMin() {
        return this.sizeMin;
    }

    public final double getSizeMax() {
        return this.sizeMax;
    }

    protected final double getRandomSize() {
        return this.rand(this.getSizeMin(), this.getSizeMax());
    }

    public final void setSize(double min, double max) {
        this.sizeMin = min;
        this.sizeMax = max;
    }

    public final Supplier<Paint> getColorFunction() {
        return this.colorFunction;
    }

    public final void setColorFunction(Supplier<Paint> colorFunction) {
        this.colorFunction = colorFunction;
    }

    public final Supplier<Point2D> getGravityFunction() {
        return this.gravityFunction;
    }

    public final void setGravityFunction(Supplier<Point2D> gravityFunction) {
        this.gravityFunction = gravityFunction;
    }

    public final void setVelocityFunction(TriFunction<Integer, Double, Double, Point2D> velocityFunction) {
        this.velocityFunction = velocityFunction;
    }

    public final void setSpawnPointFunction(TriFunction<Integer, Double, Double, Point2D> spawnPointFunction) {
        this.spawnPointFunction = spawnPointFunction;
    }

    public final void setScaleFunction(TriFunction<Integer, Double, Double, Point2D> scaleFunction) {
        this.scaleFunction = scaleFunction;
    }

    public final void setExpireFunction(TriFunction<Integer, Double, Double, Duration> expireFunction) {
        this.expireFunction = expireFunction;
    }

    public final void setBlendFunction(TriFunction<Integer, Double, Double, BlendMode> blendFunction) {
        this.blendFunction = blendFunction;
    }

    public void setSourceImage(Image sourceImage) {
        this.sourceImage = sourceImage;
    }

    public final int getNumParticles() {
        return this.numParticles;
    }

    public final void setNumParticles(int numParticles) {
        this.numParticles = numParticles;
    }

    public final void setEmissionRate(double emissionRate) {
        this.emissionRate = emissionRate;
    }

    protected final double rand() {
        return this.random.nextDouble();
    }

    protected final double rand(double min, double max) {
        return this.rand() * (max - min) + min;
    }

    final List<Particle> emit(double x, double y) {
        this.rateAC += this.emissionRate;
        if (this.rateAC < 1.0 || this.emissionRate == 0.0) {
            return EMPTY;
        }
        this.rateAC = 0.0;
        return IntStream.range(0, this.numParticles).mapToObj(i -> this.emit(i, x, y)).collect(Collectors.toList());
    }

    private Particle emit(int i, double x, double y) {
        return new Particle(this.sourceImage, this.spawnPointFunction.apply(i, x, y), this.velocityFunction.apply(i, x, y), this.gravityFunction.get(), this.getRandomSize(), this.scaleFunction.apply(i, x, y), this.expireFunction.apply(i, x, y), this.colorFunction.get(), this.blendFunction.apply(i, x, y));
    }
}

